/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitAutoSquashCommitAction;
import git4idea.rebase.GitRebaseCheckinHandlerFactory;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/GitRebaseCheckinHandlerFactory;", "Lcom/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory;", "()V", "createVcsHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "intellij.vcs.git"})
public final class GitRebaseCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    @NotNull
    protected CheckinHandler createVcsHandler(@NotNull CheckinProjectPanel panel2) {
        Intrinsics.checkParameterIsNotNull((Object)panel2, (String)"panel");
        return new CheckinHandler(){
            private boolean active;
            private Project project;
            private GitRepository repository;
            private String rebaseFrom;

            public void checkinSuccessful() {
                if (!this.active) {
                    return;
                }
                Project project = this.project;
                if (project == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                new Task.Backgroundable(this, project, GitBundle.message("rebase.progress.indicator.title", new Object[0])){
                    final /* synthetic */ createVcsHandler.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        GitVcs gitVcs = createVcsHandler.1.access$getRepository$p(this.this$0).getVcs();
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitVcs), (String)"repository.vcs");
                        GitVersion gitVersion = gitVcs.getVersion();
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"repository.vcs.version");
                        GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, createVcsHandler.1.access$getRebaseFrom$p(this.this$0), null, false, null, 16, null);
                        GitRebaseUtils.rebase(this.getProject(), CollectionsKt.listOf((Object)createVcsHandler.1.access$getRepository$p(this.this$0)), params, indicator);
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                }.queue();
            }

            public boolean acceptExecutor(@Nullable CommitExecutor executor) {
                if (executor instanceof GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor) {
                    this.active = true;
                    this.project = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getProject();
                    this.repository = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getRepository();
                    this.rebaseFrom = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getHash();
                    return false;
                }
                return true;
            }

            public static final /* synthetic */ GitRepository access$getRepository$p(createVcsHandler.1 $this) {
                GitRepository gitRepository = $this.repository;
                if (gitRepository == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                }
                return gitRepository;
            }

            public static final /* synthetic */ void access$setRepository$p(createVcsHandler.1 $this, GitRepository gitRepository) {
                $this.repository = gitRepository;
            }

            public static final /* synthetic */ String access$getRebaseFrom$p(createVcsHandler.1 $this) {
                String string = $this.rebaseFrom;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rebaseFrom");
                }
                return string;
            }

            public static final /* synthetic */ void access$setRebaseFrom$p(createVcsHandler.1 $this, String string) {
                $this.rebaseFrom = string;
            }
        };
    }

    public GitRebaseCheckinHandlerFactory() {
        super(GitVcs.getKey());
    }
}

