/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitCommitEditingAction;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitInteractiveRebaseAction;", "Lgit4idea/rebase/GitCommitEditingAction;", "()V", "actionPerformedAfterChecks", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFailureTitle", "", "update", "intellij.vcs.git"})
public final class GitInteractiveRebaseAction
extends GitCommitEditingAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        String string = GitBundle.getString("rebase.log.action.operation.rebase.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.getString(\"reb\u2026n.operation.rebase.name\")");
        GitCommitEditingAction.prohibitRebaseDuringRebase$default(this, e, string, false, 4, null);
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VcsShortCommitDetails commit2 = this.getSelectedCommit(e);
        GitRepository repository = this.getRepository(e);
        if (Registry.is((String)"git.interactive.rebase.collect.entries.using.log")) {
            GitInteractiveRebaseUsingLogKt.interactivelyRebaseUsingLog(repository, commit2, this.getLogData(e));
        } else {
            GitInteractiveRebaseUsingLogKt.startInteractiveRebase$default(repository, commit2, null, 4, null);
        }
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.getString("rebase.log.interactive.action.failure.title");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.getString(\"reb\u2026ve.action.failure.title\")");
        return string;
    }
}

