/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.text.ParseException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @Nullable
    private String myDetectedExecutable;
    @NotNull
    private final Object DETECTED_EXECUTABLE_LOCK = new Object();
    @NotNull
    private final CachingFileTester<GitVersion> myVersionCache = new CachingFileTester<GitVersion>(){

        @Override
        @NotNull
        protected GitVersion testFile(@NotNull String filePath) throws VcsException, ParseException {
            if (filePath == null) {
                1.$$$reportNull$$$0(0);
            }
            GitVersion gitVersion = GitExecutableManager.doGetGitVersion(filePath);
            if (gitVersion == null) {
                1.$$$reportNull$$$0(1);
            }
            return gitVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "testFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "testFile";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    private static GitVersion doGetGitVersion(@NotNull String pathToGit) throws VcsException, ParseException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        LOG.debug("Acquiring git version for " + pathToGit);
        GitLineHandler handler = new GitLineHandler(null, new File("."), pathToGit, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult);
        LOG.info("Git version for " + pathToGit + " : " + version.getPresentation());
        return version;
    }

    @NotNull
    public String getPathToGit() {
        String path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        String string = path == null ? this.getDetectedExecutable() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@NotNull Project project) {
        String path;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        String string = (path = GitVcsSettings.getInstance(project).getPathToGit()) == null ? this.getPathToGit() : path;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDetectedExecutable() {
        Object object = this.DETECTED_EXECUTABLE_LOCK;
        // MONITORENTER : object
        if (this.myDetectedExecutable == null) {
            this.myDetectedExecutable = new GitExecutableDetector().detect();
        }
        String string = this.myDetectedExecutable;
        // MONITOREXIT : object
        if (string != null) return string;
        GitExecutableManager.$$$reportNull$$$0(4);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropExecutableCache() {
        Object object = this.DETECTED_EXECUTABLE_LOCK;
        synchronized (object) {
            this.myDetectedExecutable = null;
        }
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(5);
        }
        GitVersion gitVersion = this.getVersion(this.getPathToGit(project));
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(6);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersion(@NotNull String executable) {
        CachingFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(7);
        }
        if ((result2 = this.myVersionCache.getCachedResultForFile(executable)) == null || result2.getResult() == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(8);
            }
            return gitVersion;
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(9);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(10);
        }
        GitVersion gitVersion = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            String pathToGit = this.getPathToGit(project);
            try {
                version = this.identifyVersion(pathToGit);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.getString("git.executable.version.progress.title"), true, project);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(11);
        }
        return gitVersion;
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(12);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.getString("git.executable.version.progress.title"), () -> {
            try {
                String pathToGit = this.getPathToGit(project);
                return this.identifyVersion(pathToGit);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            catch (GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    private static <T> T runUnderProgressIfNeeded(@NotNull Project project, @NotNull String title, @NotNull ThrowableComputable<T, RuntimeException> task) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(13);
        }
        if (title == null) {
            GitExecutableManager.$$$reportNull$$$0(14);
        }
        if (task == null) {
            GitExecutableManager.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task, title, true, project);
        }
        return (T)task.compute();
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2;
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(16);
        }
        if ((result2 = this.myVersionCache.getResultForFile(pathToGit)).getResult() == null) {
            throw new GitVersionIdentificationException("Cannot identify version of git executable " + pathToGit, result2.getException());
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(17);
        }
        return gitVersion;
    }

    public void dropVersionCache(@NotNull String pathToGit) {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(18);
        }
        this.myVersionCache.dropCache(pathToGit);
    }

    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        String pathToGit;
        GitVersion version;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(19);
        }
        if ((version = this.identifyVersionOrDisplayError(project, pathToGit = this.getPathToGit(project))) == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull String pathToGit) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(20);
        }
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(21);
        }
        try {
            return this.identifyVersion(pathToGit);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGit";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedExecutable";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetGitVersion";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathToGit";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryGetVersion";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgressIfNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dropVersionCache";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "testGitExecutableVersionValid";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersionOrDisplayError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

