/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConsumer;
import com.intellij.vcs.VcsLocaleHelper;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitImplBase;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitHandler {
    protected static final Logger LOG = Logger.getInstance(GitHandler.class);
    protected static final Logger OUTPUT_LOG = Logger.getInstance((String)("#output." + GitHandler.class.getName()));
    private static final Logger TIME_LOG = Logger.getInstance((String)("#time." + GitHandler.class.getName()));
    private final Project myProject;
    @NotNull
    private final String myPathToExecutable;
    private final GitCommand myCommand;
    private boolean myPreValidateExecutable;
    protected final GeneralCommandLine myCommandLine;
    private final Map<String, String> myCustomEnv;
    protected Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    @Nullable
    private ThrowableConsumer<? super OutputStream, IOException> myInputProcessor;
    private final EventDispatcher<ProcessEventListener> myListeners;
    protected boolean mySilent;
    private boolean myWithLowPriority;
    private boolean myWithNoTty;
    private long myStartTime;
    private static final long LONG_TIME = 10000L;
    @Deprecated
    protected final GitVcs myVcs;
    @Deprecated
    private Integer myExitCode;
    @Deprecated
    private final List<String> myLastOutput;
    @Deprecated
    private static final int LAST_OUTPUT_SIZE = 5;
    @Deprecated
    private boolean myProgressParameterAllowed;
    @Deprecated
    private final List<VcsException> myErrors;

    protected GitHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            GitHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(2);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(3);
        }
        this(project, directory, GitExecutableManager.getInstance().getPathToGit(project), command, configParameters);
        this.myProgressParameterAllowed = GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(project);
    }

    protected GitHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            GitHandler.$$$reportNull$$$0(4);
        }
        if (vcsRoot == null) {
            GitHandler.$$$reportNull$$$0(5);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(6);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(7);
        }
        this(project, VfsUtil.virtualToIoFile((VirtualFile)vcsRoot), command, configParameters);
    }

    protected GitHandler(@Nullable Project project, @NotNull File directory, @NotNull String pathToExecutable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitHandler.$$$reportNull$$$0(8);
        }
        if (pathToExecutable == null) {
            GitHandler.$$$reportNull$$$0(9);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(10);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(11);
        }
        this.myPreValidateExecutable = true;
        this.myCustomEnv = new HashMap<String, String>();
        this.myListeners = EventDispatcher.create(ProcessEventListener.class);
        this.myLastOutput = Collections.synchronizedList(new ArrayList());
        this.myProgressParameterAllowed = false;
        this.myErrors = Collections.synchronizedList(new ArrayList());
        this.myProject = project;
        this.myVcs = project != null ? GitVcs.getInstance(project) : null;
        this.myPathToExecutable = pathToExecutable;
        this.myCommand = command;
        this.myCommandLine = new GeneralCommandLine().withWorkDirectory(directory).withExePath(this.myPathToExecutable).withCharset(StandardCharsets.UTF_8);
        for (String parameter : GitHandler.getConfigParameters(project, configParameters)) {
            this.myCommandLine.addParameters(new String[]{"-c", parameter});
        }
        this.myCommandLine.addParameter(command.name());
        this.myStdoutSuppressed = true;
        this.mySilent = this.myCommand.lockingPolicy() != GitCommand.LockingPolicy.WRITE;
    }

    @NotNull
    private static List<String> getConfigParameters(@Nullable Project project, @NotNull List<String> requestedConfigParameters) {
        if (requestedConfigParameters == null) {
            GitHandler.$$$reportNull$$$0(12);
        }
        if (project == null || !GitVersionSpecialty.CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND.existsIn(project)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitHandler.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<String> toPass = new ArrayList<String>();
        toPass.add("core.quotepath=false");
        toPass.add("log.showSignature=false");
        toPass.addAll(requestedConfigParameters);
        ArrayList<String> arrayList = toPass;
        if (arrayList == null) {
            GitHandler.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    protected ProcessEventListener listeners() {
        ProcessEventListener processEventListener = (ProcessEventListener)this.myListeners.getMulticaster();
        if (processEventListener == null) {
            GitHandler.$$$reportNull$$$0(15);
        }
        return processEventListener;
    }

    @Nullable
    public Project project() {
        return this.myProject;
    }

    @NotNull
    File getWorkingDirectory() {
        File file = this.myCommandLine.getWorkDirectory();
        if (file == null) {
            GitHandler.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    String getExecutablePath() {
        String string = this.myPathToExecutable;
        if (string == null) {
            GitHandler.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    GitCommand getCommand() {
        GitCommand gitCommand = this.myCommand;
        if (gitCommand == null) {
            GitHandler.$$$reportNull$$$0(18);
        }
        return gitCommand;
    }

    protected void addListener(@NotNull ProcessEventListener listener) {
        if (listener == null) {
            GitHandler.$$$reportNull$$$0(19);
        }
        this.myListeners.addListener((EventListener)listener);
    }

    public void withLowPriority() {
        this.myWithLowPriority = true;
    }

    public void withNoTty() {
        this.myWithNoTty = true;
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(20);
        }
        this.addParameters(Arrays.asList(parameters));
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(21);
        }
        for (String parameter : parameters) {
            this.myCommandLine.addParameter(this.escapeParameterIfNeeded(parameter));
        }
    }

    @NotNull
    private String escapeParameterIfNeeded(@NotNull String parameter) {
        if (parameter == null) {
            GitHandler.$$$reportNull$$$0(22);
        }
        if (this.escapeNeeded(parameter)) {
            String string = parameter.replaceAll("\\^", "^^^^");
            if (string == null) {
                GitHandler.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = parameter;
        if (string == null) {
            GitHandler.$$$reportNull$$$0(24);
        }
        return string;
    }

    private boolean escapeNeeded(@NotNull String parameter) {
        if (parameter == null) {
            GitHandler.$$$reportNull$$$0(25);
        }
        return SystemInfo.isWindows && this.isCmd() && parameter.contains("^");
    }

    private boolean isCmd() {
        return StringUtil.toLowerCase((String)this.myCommandLine.getExePath()).endsWith("cmd");
    }

    public void addRelativePaths(FilePath ... parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(26);
        }
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            GitHandler.$$$reportNull$$$0(27);
        }
        for (FilePath filePath : filePaths) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (FilePath)filePath));
        }
    }

    public void addRelativeFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            GitHandler.$$$reportNull$$$0(28);
        }
        for (VirtualFile virtualFile : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (VirtualFile)virtualFile));
        }
    }

    public void addAbsoluteFile(@NotNull File file) {
        if (file == null) {
            GitHandler.$$$reportNull$$$0(29);
        }
        this.myCommandLine.addParameter(file.getAbsolutePath());
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    private boolean isStarted() {
        return this.myProcess != null;
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }

    public String printableCommandLine() {
        return this.unescapeCommandLine(this.myCommandLine.getCommandLineString("git"));
    }

    @NotNull
    private String unescapeCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            GitHandler.$$$reportNull$$$0(30);
        }
        if (this.escapeNeeded(commandLine)) {
            String string = commandLine.replaceAll("\\^\\^\\^\\^", "^");
            if (string == null) {
                GitHandler.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = commandLine;
        if (string == null) {
            GitHandler.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCommandLine.getCharset();
        if (charset == null) {
            GitHandler.$$$reportNull$$$0(33);
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            GitHandler.$$$reportNull$$$0(34);
        }
        this.myCommandLine.setCharset(charset);
    }

    public void setSilent(boolean silent) {
        this.mySilent = silent;
        if (silent) {
            this.setStderrSuppressed(true);
            this.setStdoutSuppressed(true);
        }
    }

    boolean isSilent() {
        return this.mySilent;
    }

    boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setInputProcessor(@Nullable ThrowableConsumer<? super OutputStream, IOException> inputProcessor) {
        this.myInputProcessor = inputProcessor;
    }

    public void addCustomEnvironmentVariable(String name, String value) {
        this.myCustomEnv.put(name, value);
    }

    public boolean containsCustomEnvironmentVariable(@NotNull String key) {
        if (key == null) {
            GitHandler.$$$reportNull$$$0(35);
        }
        return this.myCustomEnv.containsKey(key);
    }

    public void setPreValidateExecutable(boolean preValidateExecutable) {
        this.myPreValidateExecutable = preValidateExecutable;
    }

    boolean isPreValidateExecutable() {
        return this.myPreValidateExecutable;
    }

    void runInCurrentThread() throws IOException {
        block7: {
            try {
                this.start();
                if (!this.isStarted()) break block7;
                try {
                    if (this.myInputProcessor != null) {
                        this.myInputProcessor.consume((Object)this.myProcess.getOutputStream());
                    }
                }
                finally {
                    this.waitForProcess();
                }
            }
            finally {
                this.logTime();
            }
        }
    }

    private void logTime() {
        if (this.myStartTime > 0L) {
            long time = System.currentTimeMillis() - this.myStartTime;
            if (!TIME_LOG.isDebugEnabled() && time > 10000L) {
                LOG.info(String.format("git %s took %s ms. Command parameters: %n%s", this.myCommand, time, this.myCommandLine.getCommandLineString()));
            } else {
                TIME_LOG.debug(String.format("git %s took %s ms", this.myCommand, time));
            }
        } else {
            LOG.debug(String.format("git %s finished.", this.myCommand));
        }
    }

    private void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
        try {
            String logDirectoryPath;
            if (this.myWithLowPriority) {
                ExecUtil.setupLowPriorityExecution((GeneralCommandLine)this.myCommandLine);
            }
            if (this.myWithNoTty) {
                ExecUtil.setupNoTtyExecution((GeneralCommandLine)this.myCommandLine);
            }
            this.myStartTime = System.currentTimeMillis();
            String string = logDirectoryPath = this.myProject != null ? GitImplBase.stringifyWorkingDir(this.myProject.getBasePath(), this.myCommandLine.getWorkDirectory()) : this.myCommandLine.getWorkDirectory().getPath();
            if (!this.mySilent) {
                LOG.info("[" + logDirectoryPath + "] " + this.printableCommandLine());
            } else {
                LOG.debug("[" + logDirectoryPath + "] " + this.printableCommandLine());
            }
            this.prepareEnvironment();
            this.myProcess = this.startProcess();
            this.startHandlingStreams();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(t);
            }
            ((ProcessEventListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    private void prepareEnvironment() {
        Map executionEnvironment = this.myCommandLine.getEnvironment();
        executionEnvironment.clear();
        executionEnvironment.putAll(EnvironmentUtil.getEnvironmentMap());
        executionEnvironment.putAll(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git"));
        executionEnvironment.putAll(this.myCustomEnv);
    }

    protected abstract Process startProcess() throws ExecutionException;

    protected abstract void startHandlingStreams();

    protected abstract void waitForProcess();

    public String toString() {
        return this.myCommandLine.toString();
    }

    @Deprecated
    public boolean addProgressParameter() {
        if (this.myProgressParameterAllowed) {
            this.addParameters("--progress");
            return true;
        }
        return false;
    }

    @Deprecated
    public int getExitCode() {
        if (this.myExitCode == null) {
            return -1;
        }
        return this.myExitCode;
    }

    @Deprecated
    protected void setExitCode(int exitCode) {
        if (this.myExitCode == null) {
            this.myExitCode = exitCode;
        } else {
            LOG.info("Not setting exit code " + exitCode + ", because it was already set to " + this.myExitCode);
        }
    }

    @Deprecated
    public void addLastOutput(String line) {
        if (this.myLastOutput.size() < 5) {
            this.myLastOutput.add(line);
        } else {
            this.myLastOutput.add(0, line);
            Collections.rotate(this.myLastOutput, -1);
        }
    }

    @Deprecated
    public List<String> getLastOutput() {
        return this.myLastOutput;
    }

    @Deprecated
    void runInCurrentThread(@Nullable Runnable postStartAction) {
        try {
            this.start();
            if (this.isStarted()) {
                if (postStartAction != null) {
                    postStartAction.run();
                }
                this.waitForProcess();
            }
        }
        finally {
            this.logTime();
        }
    }

    @Deprecated
    abstract void destroyProcess();

    @Deprecated
    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    @Deprecated
    public List<VcsException> errors() {
        return Collections.unmodifiableList(this.myErrors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToExecutable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedConfigParameters";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listeners";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeParameterIfNeeded";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeCommandLine";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfigParameters";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "escapeParameterIfNeeded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "escapeNeeded";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addRelativePaths";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addRelativeFiles";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addAbsoluteFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCommandLine";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "containsCustomEnvironmentVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

