/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceHtmlTagWithCssAction
implements LocalQuickFix {
    @NonNls
    private final String myName;
    @NonNls
    private static final String BODY = "body";
    @NonNls
    private static final String HTML = "html";
    @NonNls
    private static final String HEAD = "head";

    public ReplaceHtmlTagWithCssAction(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = HtmlToolsBundle.message("html.replace.tag.with.css.quickfix.text", this.myName);
        if (string == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = HtmlToolsBundle.message("html.replace.tag.with.css.quickfix.family.name", new Object[0]);
        if (string == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, boolean blocklevel) {
        if (project == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(3);
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, blocklevel ? "div" : "span");
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    private static void addCssAttribute(XmlTag tag, String name) {
        String s = tag.getAttributeValue("style");
        String addString = (String)Holder.ourTagToCssMap.get(name);
        if (s == null) {
            s = addString;
        } else {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (Character.isSpaceChar(s.charAt(i))) continue;
                if (s.charAt(i) == ';') break;
                s = s + ';';
                break;
            }
            s = s + " " + addString;
        }
        tag.setAttribute("style", s);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        boolean toReplaceWithSpan;
        PsiElement parent;
        if (project == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            ReplaceHtmlTagWithCssAction.$$$reportNull$$$0(5);
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && Holder.ourTagToCssMap.containsKey(StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName()))); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        boolean bl = toReplaceWithSpan = parentTag == null || HtmlUtil.isInlineTagContainer((String)parentTag.getLocalName());
        if (!toReplaceWithSpan) {
            String name = StringUtil.toLowerCase((String)parentTag.getLocalName());
            if (BODY.equals(name) || HTML.equals(name) || HEAD.equals(name)) {
                toReplaceWithSpan = true;
            } else {
                int childrenTagCount = 0;
                for (PsiElement child : parentTag.getChildren()) {
                    if (child instanceof XmlTag) {
                        ++childrenTagCount;
                    }
                    if (!(child instanceof XmlText)) continue;
                    childrenTagCount += 2;
                }
                toReplaceWithSpan = childrenTagCount > 1;
            }
        }
        String tagName = StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName());
        if (!toReplaceWithSpan) {
            ReplaceHtmlTagWithCssAction.addCssAttribute(parentTag, tagName);
            PsiElement[] elements = tag.getChildren();
            boolean started = false;
            for (PsiElement psiElement : elements) {
                if (psiElement instanceof XmlToken) {
                    XmlToken xmlToken = (XmlToken)psiElement;
                    IElementType type = xmlToken.getTokenType();
                    if (type == XmlTokenType.XML_TAG_END) {
                        started = true;
                        continue;
                    }
                    if (type == XmlTokenType.XML_END_TAG_START) break;
                }
                if (!started) continue;
                parentTag.addBefore(psiElement, (PsiElement)tag);
            }
            tag.delete();
        } else {
            PsiElement[] elements = ReplaceHtmlTagWithCssAction.generateContainingElements(project, HtmlUtil.isHtmlBlockTag((String)tagName));
            int cnt = 0;
            for (PsiElement psiElement : tag.getChildren()) {
                IElementType type;
                if (!(psiElement instanceof XmlToken) || (type = ((XmlToken)psiElement).getTokenType()) != XmlTokenType.XML_NAME) continue;
                psiElement.replace(elements[cnt++]);
            }
            ReplaceHtmlTagWithCssAction.addCssAttribute(tag, tagName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithCssAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateContainingElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        @NonNls
        private static final Map<String, String> ourTagToCssMap = new HashMap<String, String>();

        private Holder() {
        }

        static {
            ourTagToCssMap.put("center", "text-align: center;");
            ourTagToCssMap.put("i", "font-style: italic;");
            ourTagToCssMap.put("b", "font-weight: bold;");
            ourTagToCssMap.put("big", "font-size: large;");
            ourTagToCssMap.put("small", "font-size: small;");
            ourTagToCssMap.put("tt", "font-family: monospace;");
            ourTagToCssMap.put("u", "text-decoration: underline;");
            ourTagToCssMap.put("s", "text-decoration: line-through;");
            ourTagToCssMap.put("strike", "text-decoration: line-through;");
            ourTagToCssMap.put("xmp", "white-space: pre;");
        }
    }
}

