/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class StringLiteralBreaksHTMLJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("string.literal.breaks.html.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSLiteralExpression(JSLiteralExpression jsLiteralExpression) {
            if (!(jsLiteralExpression.getContainingFile() instanceof XmlFile)) {
                return;
            }
            super.visitJSLiteralExpression(jsLiteralExpression);
            String text = jsLiteralExpression.getText();
            if (!text.startsWith("\"") && !text.startsWith("'")) {
                return;
            }
            if (text.contains("</")) {
                this.registerError((PsiElement)jsLiteralExpression);
            }
        }
    }
}

