/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6DoExpression;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAssertion;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BadExpressionStatementJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("expression.statement.is.not.assignment.or.call.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isLastStatementInES6DoExpression(@NotNull JSExpressionStatement jsExpressionStatement) {
        JSExpressionStatement element;
        if (jsExpressionStatement == null) {
            BadExpressionStatementJSInspection.$$$reportNull$$$0(0);
        }
        for (element = jsExpressionStatement; element != null && !(element instanceof JSFunction) && !(element instanceof ES6DoExpression); element = element.getParent()) {
            JSStatement statement;
            JSStatement jSStatement = statement = element instanceof JSStatement ? (JSStatement)element : null;
            if (statement == null || statement instanceof JSBlockStatement && statement.getParent() instanceof JSIfStatement || PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, JSStatement.class) == null) continue;
            return false;
        }
        return element instanceof ES6DoExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsExpressionStatement", "com/sixrr/inspectjs/validity/BadExpressionStatementJSInspection", "isLastStatementInES6DoExpression"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSExpressionStatement(JSExpressionStatement jsExpressionStatement) {
            super.visitJSExpressionStatement(jsExpressionStatement);
            if (BadExpressionStatementJSInspection.isLastStatementInES6DoExpression(jsExpressionStatement)) {
                return;
            }
            this.validateExpressionStatement(jsExpressionStatement);
        }

        private void validateExpressionStatement(JSExpressionStatement jsExpressionStatement) {
            Language fileLanguage;
            JSExpression expression = jsExpressionStatement.getExpression();
            if (Visitor.isNotPointless(expression)) {
                return;
            }
            PsiFile file2 = jsExpressionStatement.getContainingFile();
            if (file2 instanceof JSExpressionCodeFragment) {
                return;
            }
            PsiElement parent = jsExpressionStatement.getParent();
            if (parent instanceof JSFile && file2.getVirtualFile() instanceof VirtualFileWindow) {
                return;
            }
            if (JSPsiImplUtils.isCompilerDirectiveStatement((PsiElement)jsExpressionStatement) && ((fileLanguage = file2.getLanguage()) == JavascriptLanguage.INSTANCE || fileLanguage instanceof JSLanguageDialect && !((JSLanguageDialect)fileLanguage).getOptionHolder().isECMA4 || PsiTreeUtil.getParentOfType((PsiElement)expression, JSEmbeddedContent.class) != null)) {
                return;
            }
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)jsExpressionStatement);
            if (host != null && host.getLanguage().getID().equals("CSS")) {
                return;
            }
            if (expression == null || JSInheritedLanguagesHelper.isBadExpressionStatement((PsiElement)expression)) {
                JSExpression place = expression != null ? expression : jsExpressionStatement;
                this.registerError((PsiElement)place);
            }
        }

        private static boolean isNotPointless(JSExpression expression) {
            JSPostfixExpression prefix;
            IElementType sign;
            if (expression instanceof JSCallLikeExpression || expression instanceof JSAssignmentExpression || expression instanceof JSYieldExpression || expression instanceof ES6ImportCall || expression instanceof JSStringTemplateExpression) {
                return true;
            }
            if (expression instanceof JSPrefixExpression) {
                JSPrefixExpression prefix2 = (JSPrefixExpression)expression;
                IElementType sign2 = prefix2.getOperationSign();
                if (JSTokenTypes.PLUSPLUS == sign2 || JSTokenTypes.MINUSMINUS == sign2 || JSTokenTypes.VOID_KEYWORD == sign2 || JSTokenTypes.DELETE_KEYWORD == sign2 || JSTokenTypes.AWAIT_KEYWORD == sign2) {
                    return true;
                }
                return Visitor.isNotPointless(prefix2.getExpression());
            }
            if (expression instanceof JSPostfixExpression && (JSTokenTypes.PLUSPLUS.equals(sign = (prefix = (JSPostfixExpression)expression).getOperationSign()) || JSTokenTypes.MINUSMINUS.equals(sign))) {
                return true;
            }
            if (expression instanceof JSBinaryExpression) {
                JSBinaryExpression binary = (JSBinaryExpression)expression;
                sign = binary.getOperationSign();
                if (sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OROR) {
                    JSExpression leftOp = binary.getLOperand();
                    if (leftOp instanceof JSParenthesizedExpression) {
                        leftOp = ((JSParenthesizedExpression)leftOp).getInnerExpression();
                    }
                    if ((leftOp instanceof JSReferenceExpression || leftOp instanceof JSIndexedPropertyAccessExpression || leftOp instanceof JSBinaryExpression || leftOp instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)leftOp).getOperationSign() || Visitor.isNotPointless(leftOp)) && Visitor.isNotPointless(binary.getROperand())) {
                        return true;
                    }
                } else if (sign == JSTokenTypes.COMMA) {
                    return Visitor.isNotPointless(binary.getLOperand()) || Visitor.isNotPointless(binary.getROperand());
                }
            }
            if (expression instanceof JSParenthesizedExpression) {
                PsiElement parent;
                PsiElement grandparent;
                JSExpression innerExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
                if (innerExpression instanceof JSFunctionExpression && (grandparent = (parent = expression.getParent()).getParent()) instanceof JSFile && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)parent) == null && PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent) == null) {
                    return true;
                }
                return Visitor.isNotPointless(innerExpression);
            }
            if (expression instanceof JSReferenceExpression) {
                ResolveResult[] resolveResults;
                JSFunctionExpression fun;
                PsiElement element;
                ResolveResult[] results;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                if ((expression.getParent().getParent() instanceof JSClass || InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectionHost((PsiElement)expression) != null) && (results = referenceExpression.multiResolve(false)).length > 0 && ((element = results[0].getElement()) instanceof JSFunction ? (fun = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunctionExpression.class)) != null && ActionScriptResolveUtil.isAnonymousEventHandler(fun) : element instanceof JSClass)) {
                    return true;
                }
                PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)expression);
                if (docComment instanceof JSDocComment) {
                    if (((JSDocComment)docComment).hasInterfaceTag()) {
                        return true;
                    }
                    JSElementIndexingData indexingData = ((JSDocComment)docComment).getIndexingData();
                    if (indexingData != null && !ContainerUtil.isEmpty((Collection)indexingData.getTypedefs())) {
                        return true;
                    }
                }
                if ((resolveResults = referenceExpression.multiResolve(false)).length == 0 || JSResolveResult.toElements(resolveResults).size() == 0) {
                    return true;
                }
                boolean onlyPropertySignatures = true;
                for (ResolveResult resolveResult : resolveResults) {
                    PsiElement resolveElement = resolveResult.getElement();
                    if (resolveElement instanceof JSProperty) {
                        resolveElement = ((JSProperty)resolveElement).tryGetFunctionInitializer();
                    }
                    if (resolveElement instanceof JSFunctionItem && ((JSFunctionItem)resolveElement).isGetProperty()) {
                        return true;
                    }
                    onlyPropertySignatures &= resolveElement instanceof TypeScriptPropertySignature;
                }
                if (onlyPropertySignatures) {
                    return true;
                }
            }
            if (expression instanceof JSConditionalExpression) {
                JSExpression thenExpr = ((JSConditionalExpression)expression).getThen();
                JSExpression elseExpr = ((JSConditionalExpression)expression).getThen();
                return thenExpr != null && Visitor.isNotPointless(thenExpr) || elseExpr != null && Visitor.isNotPointless(elseExpr);
            }
            if (expression instanceof TypeScriptTypeAssertion) {
                return Visitor.isNotPointless(((TypeScriptTypeAssertion)expression).getExpression());
            }
            return expression instanceof JSDestructuringElement;
        }
    }
}

