/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerFunctionJSInspection
extends FunctionMetricsInspection {
    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("function.parameter.limit", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        JSParameter[] parameters = function2.getParameterVariables();
        int numParameters = parameters.length;
        if (ParametersPerFunctionJSInspection.functionHasIdentifier(function2)) {
            return InspectionJSBundle.message("function.has.too.many.parameters.error.string", numParameters);
        }
        return InspectionJSBundle.message("anonymous.function.has.too.many.parameters.error.string", numParameters);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            JSParameterListElement[] parameters;
            int numParameters;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((numParameters = (parameters = function2.getParameters()).length) <= ParametersPerFunctionJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function2);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

