/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ReturnFromFinallyBlockJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("return.inside.finally.block.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSReturnStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock((JSElement)statement)) {
                return;
            }
            this.registerStatementError((JSSourceElement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/ReturnFromFinallyBlockJSInspection$Visitor", "visitJSReturnStatement"));
        }
    }
}

