/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class DocumentWriteJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("document.write.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSCallExpression(JSCallExpression jsCallExpression) {
            super.visitJSCallExpression(jsCallExpression);
            JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsCallExpression.getMethodExpression(), JSReferenceExpression.class);
            if (referenceExpression == null) {
                return;
            }
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSReferenceExpression.class);
            if (!JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "document")) {
                return;
            }
            String methodName = referenceExpression.getReferenceName();
            if ("write".equals(methodName) || "writeln".equals(methodName)) {
                this.registerError((PsiElement)referenceExpression);
            }
        }
    }
}

