/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class AnonymousFunctionJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("anonymous.function.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionExpression(JSFunctionExpression jsFunctionExpression) {
            super.visitJSFunctionExpression(jsFunctionExpression);
            ASTNode identifier = jsFunctionExpression.findNameIdentifier();
            if (identifier == null || PsiTreeUtil.isAncestor((PsiElement)jsFunctionExpression, (PsiElement)identifier.getPsi(), (boolean)true)) {
                return;
            }
            this.registerError(PsiTreeUtil.getChildOfType((PsiElement)jsFunctionExpression, LeafPsiElement.class));
        }
    }
}

