/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.graph.Graph;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportGraph
implements Graph<VirtualFile> {
    private static final TIntArrayList EMPTY_VALUE = new TIntArrayList(){

        public void add(int val) {
            throw new IllegalStateException("Default list must be immutable");
        }
    };
    private int[] myRootNodes;
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myOutEdges;
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myInEdges;
    @NotNull
    private final TIntObjectHashMap<VirtualFile> myIds;
    @NotNull
    private final TypeScriptFileImports mySearcher;
    private final AtomicBoolean myInitialized;
    private final ReentrantReadWriteLock myLock;

    public TypeScriptImportGraph(@NotNull TypeScriptFileImports searcher) {
        if (searcher == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(0);
        }
        this.myInitialized = new AtomicBoolean(false);
        this.myLock = new ReentrantReadWriteLock();
        this.myOutEdges = new TIntObjectHashMap();
        this.myInEdges = new TIntObjectHashMap();
        this.mySearcher = searcher;
        this.myIds = new TIntObjectHashMap();
    }

    public TypeScriptImportGraph initialize() {
        this.initialize(false);
        return this;
    }

    public boolean initialize(boolean tryOnly) {
        if (this.myInitialized.get()) {
            return true;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (tryOnly) {
            if (!writeLock.tryLock()) {
                return false;
            }
            return this.runUnderWriteLock(writeLock);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)writeLock, (int)10, (TimeUnit)TimeUnit.MILLISECONDS);
        return this.runUnderWriteLock(writeLock);
    }

    private boolean runUnderWriteLock(@NotNull Lock writeLock) {
        if (writeLock == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(1);
        }
        try {
            if (this.myInitialized.get()) {
                boolean bl = true;
                return bl;
            }
            TypeScriptImportGraph.logStartGraphBuilding(this.mySearcher);
            Set<VirtualFile> files = this.mySearcher.getRootFiles();
            this.myRootNodes = TypeScriptImportGraph.extractIdsForFiles(files);
            ProgressManager.checkCanceled();
            this.add(files, true);
            this.myInitialized.set(true);
            TypeScriptImportGraph.logEndGraphBuilding(this);
        }
        catch (ProcessCanceledException e) {
            this.resetGraph();
            throw e;
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    private static int[] extractIdsForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(2);
        }
        return StreamEx.of(files).mapToInt(TypeScriptImportGraph::getFileId).toArray();
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles(this.myRootNodes);
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(3);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    @NotNull
    private Set<VirtualFile> copyAsFiles(int @NotNull [] elements) {
        if (elements == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(4);
        }
        Set<VirtualFile> set = IntStream.of(elements).mapToObj(el -> this.getNode(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getNodes() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles(this.myIds.keys());
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(6);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    public boolean isInitialized() {
        return this.myInitialized.get();
    }

    public boolean containsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(7);
        }
        return this.containsId(TypeScriptImportGraph.getFileId(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int fileId) {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        try {
            boolean bl = this.myIds.contains(fileId);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void recalculateEdges(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(8);
        }
        TypeScriptImportGraph.logStartGraphUpdating(this, file2);
        this.initialize();
        this.validate(file2);
        Set<VirtualFile> newFiles = this.mySearcher.getOutFiles(file2);
        this.recalculateEdges(file2, newFiles);
        TypeScriptImportGraph.logEndGraphUpdating(this);
    }

    @NotNull
    public Iterator<VirtualFile> getIn(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(9);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file2, this.myInEdges).iterator();
        if (iterator == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(10);
        }
        return iterator;
    }

    @NotNull
    public Iterator<VirtualFile> getOut(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(11);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file2, this.myOutEdges).iterator();
        if (iterator == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(12);
        }
        return iterator;
    }

    @NotNull
    public final TypeScriptFileImports getFileImports() {
        TypeScriptFileImports typeScriptFileImports = this.mySearcher;
        if (typeScriptFileImports == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(13);
        }
        return typeScriptFileImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<VirtualFile> getValueUnderLock(@NotNull VirtualFile file2, TIntObjectHashMap<TIntArrayList> mapFrom) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(14);
        }
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        TIntArrayList result2 = TypeScriptImportGraph.getOrDefault(mapFrom, TypeScriptImportGraph.getFileId(file2));
        Set<VirtualFile> set = this.copyAsFiles(result2.toNativeArray());
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(15);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    public boolean includesInPattern(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(16);
        }
        return this.mySearcher.includesInPattern(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateEdges(@NotNull VirtualFile file2, @NotNull Set<VirtualFile> newOutFiles) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(17);
        }
        if (newOutFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(18);
        }
        int fileId = TypeScriptImportGraph.getFileId(file2);
        Set<VirtualFile> oldOutFiles = this.getValueUnderLock(file2, this.myOutEdges);
        if (oldOutFiles.size() == newOutFiles.size() && newOutFiles.containsAll(oldOutFiles)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.removeOutNodesRecursive(fileId);
            this.add(file2, newOutFiles);
            this.removeNotAvailableFromRoots();
            assert (this.myIds.size() >= this.myRootNodes.length);
        }
        finally {
            lock.unlock();
        }
    }

    private void add(@NotNull VirtualFile file2, @NotNull Collection<VirtualFile> newOutFiles) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(19);
        }
        if (newOutFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(20);
        }
        int fileId = TypeScriptImportGraph.getFileId(file2);
        this.myIds.put(fileId, (Object)file2);
        TypeScriptImportGraph.addEdges(this.myOutEdges, file2, newOutFiles);
        ArrayList<VirtualFile> toCheck = new ArrayList<VirtualFile>(newOutFiles.size());
        newOutFiles.forEach(el -> {
            toCheck.add((VirtualFile)el);
            TypeScriptImportGraph.addEdge(this.myInEdges, el, fileId);
        });
        this.add(toCheck, false);
    }

    @NotNull
    private static TIntArrayList getOrDefault(@NotNull TIntObjectHashMap<TIntArrayList> map, int value) {
        TIntArrayList list2;
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(21);
        }
        TIntArrayList tIntArrayList = (list2 = (TIntArrayList)map.get(value)) == null ? EMPTY_VALUE : list2;
        if (tIntArrayList == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(22);
        }
        return tIntArrayList;
    }

    private void removeOutNodesRecursive(int fileId) {
        TIntArrayList oldOut = TypeScriptImportGraph.getOrDefault(this.myOutEdges, fileId);
        oldOut.forEach(oldDestination -> {
            TIntArrayList inForOldValue = TypeScriptImportGraph.getOrDefault(this.myInEdges, oldDestination);
            int index = inForOldValue.indexOf(fileId);
            if (index == -1) {
                VirtualFile node = this.getNode(oldDestination);
                assert (node != null);
                VirtualFile fileNode = this.getNode(fileId);
                assert (fileNode != null);
                throw new IllegalStateException("Inconsistent graph in: " + fileNode.getPath() + " out: " + node.getPath());
            }
            inForOldValue.remove(index);
            return true;
        });
        if (oldOut.size() > 0) {
            oldOut.clear();
        }
    }

    private void removeNotAvailableFromRoots() {
        Set<VirtualFile> availableFromRoot = this.getAvailableFromRoots();
        if (availableFromRoot.size() == this.myIds.size()) {
            return;
        }
        int[] idsBefore = this.myIds.keys();
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>(this.copyAsFiles(idsBefore));
        toRemove.removeAll(availableFromRoot);
        toRemove.forEach(el -> {
            int elId = TypeScriptImportGraph.getFileId(el);
            this.myOutEdges.remove(elId);
            this.myInEdges.remove(elId);
        });
        toRemove.forEach(el -> {
            VirtualFile cfr_ignored_0 = (VirtualFile)this.myIds.remove(TypeScriptImportGraph.getFileId(el));
        });
    }

    private void validate(@NotNull VirtualFile file2) throws IllegalArgumentException {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(23);
        }
        if (!this.myInitialized.get()) {
            throw new IllegalStateException("The graph is not initialized");
        }
        if (!this.myIds.contains(TypeScriptImportGraph.getFileId(file2))) {
            throw new IllegalStateException("No such node present in the graph");
        }
    }

    @Nullable
    private VirtualFile getNode(int id) {
        return (VirtualFile)this.myIds.get(id);
    }

    @NotNull
    Set<VirtualFile> getAvailableFromRoots() {
        this.initialize();
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(this.copyAsFiles(this.myRootNodes));
        THashSet result2 = new THashSet();
        while (!toCheck.isEmpty()) {
            VirtualFile pop = (VirtualFile)toCheck.pop();
            if (!result2.add(pop)) continue;
            TIntArrayList out = TypeScriptImportGraph.getOrDefault(this.myOutEdges, TypeScriptImportGraph.getFileId(pop));
            out.forEach(el -> {
                VirtualFile node = this.getNode(el);
                if (node == null) {
                    throw new IllegalStateException("Graph is inconsistent. Out edges are missing");
                }
                toCheck.add(node);
                return true;
            });
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(24);
        }
        return tHashSet;
    }

    private void add(@NotNull Collection<VirtualFile> toProcess, boolean checkCanceled) {
        if (toProcess == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(25);
        }
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(toProcess);
        while (!toCheck.isEmpty()) {
            VirtualFile file2;
            int fileId;
            if (checkCanceled) {
                ProgressManager.checkCanceled();
            }
            if (this.myIds.contains(fileId = TypeScriptImportGraph.getFileId(file2 = (VirtualFile)toCheck.pop()))) continue;
            this.myIds.put(fileId, (Object)file2);
            Set<VirtualFile> outFiles = this.mySearcher.getOutFiles(file2);
            TypeScriptImportGraph.addEdges(this.myOutEdges, file2, outFiles);
            outFiles.forEach(el -> {
                toCheck.add((VirtualFile)el);
                TypeScriptImportGraph.addEdge(this.myInEdges, el, fileId);
            });
        }
    }

    private static void addEdge(@NotNull TIntObjectHashMap<TIntArrayList> map, @NotNull VirtualFile key, int valueId) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(26);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(27);
        }
        TIntArrayList arr = TypeScriptImportGraph.getOrInitMapFor(map, key);
        arr.add(valueId);
    }

    @NotNull
    private static TIntArrayList getOrInitMapFor(@NotNull TIntObjectHashMap<TIntArrayList> map, @NotNull VirtualFile key) {
        int keyId;
        TIntArrayList arr;
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(28);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(29);
        }
        if ((arr = (TIntArrayList)map.get(keyId = TypeScriptImportGraph.getFileId(key))) == null) {
            arr = new TIntArrayList();
            map.put(keyId, (Object)arr);
        }
        TIntArrayList tIntArrayList = arr;
        if (tIntArrayList == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(30);
        }
        return tIntArrayList;
    }

    private static void addEdges(@NotNull TIntObjectHashMap<TIntArrayList> map, @NotNull VirtualFile key, @NotNull Collection<VirtualFile> values) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(31);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(32);
        }
        if (values == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(33);
        }
        TIntArrayList arr = TypeScriptImportGraph.getOrInitMapFor(map, key);
        arr.add(values.stream().mapToInt(el -> TypeScriptImportGraph.getFileId(el)).toArray());
    }

    private static void logStartGraphBuilding(TypeScriptFileImports references) {
        if (!TypeScriptConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("Start building tsconfig graph. Refs: " + references.hashCode());
    }

    public void resetGraph() {
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.myInitialized.set(false);
            this.myIds.clear();
            this.myOutEdges.clear();
            this.myInEdges.clear();
            this.myRootNodes = null;
        }
        finally {
            lock.unlock();
        }
    }

    private static void logEndGraphBuilding(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(34);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("End building tsconfig graph");
        TypeScriptImportGraph.logGraphState(graph);
    }

    static void logStartGraphUpdating(@NotNull TypeScriptImportGraph graph, @NotNull VirtualFile file2) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(36);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("Start updating tsconfig graph. Source: " + file2.getName() + ". Nodes: " + graph.getNodes().size());
    }

    static void logEndGraphUpdating(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(37);
        }
        if (!TypeScriptConfigGraphCache.LOG.isDebugEnabled()) {
            return;
        }
        TypeScriptConfigGraphCache.LOG.debug("End updating tsconfig graph");
        TypeScriptImportGraph.logGraphState(graph);
    }

    private static void logGraphState(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(38);
        }
        if (TypeScriptConfigGraphCache.LOG.isTraceEnabled()) {
            TypeScriptConfigGraphCache.LOG.trace("Graph roots: " + graph.getRoots().size() + ", nodes: " + graph.getNodes().size() + ", available from roots: " + graph.getAvailableFromRoots().size());
        }
    }

    public static int getFileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(39);
        }
        if (file2 instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)file2).getId();
        }
        return file2.getPath().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 24: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 24: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeLock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOutFiles";
                break;
            }
            case 21: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAsFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOut";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileImports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueUnderLock";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDefault";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFromRoots";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitMapFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runUnderWriteLock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractIdsForFiles";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 24: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyAsFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 8: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "recalculateEdges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOut";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueUnderLock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "includesInPattern";
                break;
            }
            case 19: 
            case 20: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrDefault";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitMapFor";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphBuilding";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "logStartGraphUpdating";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphUpdating";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "logGraphState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 22: 
            case 24: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

