/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.typescript.intentions.TypeScriptAddExplicitEnumValuesIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptAddEnumStringValuesIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.fix.add.string.enum.values", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"javascript.fix.add.string.enum.values", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(3);
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        assert (anEnum != null);
        TypeScriptAddExplicitEnumValuesIntention.NumberFormat format = TypeScriptAddExplicitEnumValuesIntention.NumberFormat.Dec;
        for (JSField field : anEnum.getFields()) {
            String name;
            assert (field instanceof TypeScriptEnumField);
            JSExpression initializer = field.getInitializer();
            if (initializer != null || (name = field.getName()) == null) continue;
            StringBuilder builder = new StringBuilder(field.getName());
            StringUtil.quote((StringBuilder)builder, (char)JSCodeStyleSettings.getQuote((PsiElement)anEnum).charAt(0));
            TypeScriptAddExplicitEnumValuesIntention.appendEnumValue(field, builder.toString());
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TypeScriptAddEnumStringValuesIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        TypeScriptEnum anEnum = TypeScriptAddExplicitEnumValuesIntention.findEnum(element);
        if (anEnum == null) {
            return false;
        }
        boolean hasNonInitialized = false;
        for (JSField field : anEnum.getFields()) {
            JSExpression initializer = field.getInitializer();
            hasNonInitialized |= initializer == null;
            if (!(field instanceof TypeScriptEnumField)) {
                return false;
            }
            EnumConstantValue constantValue = ((TypeScriptEnumField)field).getConstantValue();
            if (initializer != null && (constantValue.getNumericValue() != null || constantValue.getBigIntValue() != null)) {
                return false;
            }
            String value = constantValue.getStringValue();
            if (value == null || value.equals(field.getName())) continue;
            return false;
        }
        return hasNonInitialized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddEnumStringValuesIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddEnumStringValuesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

