/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptAnnotationTooltipActionProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptConfigJsonFixBase
implements LocalQuickFix,
HighPriorityAction,
TypeScriptAnnotationTooltipActionProvider.TooltipFix {
    TypeScriptConfigJsonFixBase() {
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(1);
        }
        if ((element = descriptor2.getStartElement()) == null) {
            return;
        }
        TypeScriptConfig preferableConfig = TypeScriptConfigUtil.getConfigForPsiFile(element.getContainingFile());
        if (preferableConfig == null) {
            return;
        }
        this.applyFix(project, element, preferableConfig);
    }

    protected abstract void applyFix(@NotNull Project var1, @NotNull PsiElement var2, TypeScriptConfig var3);

    @Nullable
    JsonObject getOrCreateCompilerOptionsObject(@Nullable PsiElement element, @NotNull TypeScriptConfig preferableConfig) {
        if (preferableConfig == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(2);
        }
        if (element == null) {
            return null;
        }
        VirtualFile configFile = preferableConfig.getConfigFile();
        PsiFile psiFile = element.getManager().findFile(configFile);
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        PsiElement topLevelObject = psiFile.getFirstChild();
        if (!(topLevelObject instanceof JsonObject)) {
            return null;
        }
        JsonProperty compilerOptions = ((JsonObject)topLevelObject).findProperty("compilerOptions");
        if (compilerOptions == null && (compilerOptions = TypeScriptConfigJsonFixBase.createCompilerOptions(element.getProject(), topLevelObject)) == null) {
            return null;
        }
        return (JsonObject)ObjectUtils.tryCast((Object)compilerOptions.getValue(), JsonObject.class);
    }

    @Nullable
    static JsonProperty createCompilerOptions(@NotNull Project project, @NotNull PsiElement object) {
        if (project == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(3);
        }
        if (object == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(4);
        }
        return TypeScriptConfigJsonFixBase.createProperty(project, "compilerOptions", JsonSchemaType._object, object);
    }

    @Nullable
    static JsonProperty createProperty(@NotNull Project project, @NotNull String name, @NotNull JsonSchemaType type, @NotNull PsiElement object) {
        if (project == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(5);
        }
        if (name == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(6);
        }
        if (type == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(7);
        }
        if (object == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(8);
        }
        JsonValidationError.MissingPropertyIssueData data = new JsonValidationError.MissingPropertyIssueData(name, type, null, 0);
        return TypeScriptConfigJsonFixBase.createProperty(project, object, data);
    }

    @Nullable
    static JsonProperty createProperty(@NotNull Project project, @NotNull PsiElement object, JsonValidationError.MissingPropertyIssueData data) {
        JsonValidationError.MissingMultiplePropsIssueData propsIssueData;
        PsiElement element;
        if (project == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(9);
        }
        if (object == null) {
            TypeScriptConfigJsonFixBase.$$$reportNull$$$0(10);
        }
        return (element = new AddMissingPropertyFix(propsIssueData = new JsonValidationError.MissingMultiplePropsIssueData(Collections.singleton(data)), JsonOriginalPsiWalker.INSTANCE.getSyntaxAdapter(project)).performFix(object, Ref.create())) instanceof JsonProperty ? (JsonProperty)element : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferableConfig";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigJsonFixBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateCompilerOptionsObject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompilerOptions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

