/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    private static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    public static final String EVENT_TYPE = "event";
    public static final String EVENT_PROPERTY = "event";
    public static final String REQUEST_COMPLETED = "requestCompleted";
    public static final String BODY = "body";
    private final String myServicePath;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final Consumer<? super JSLanguageServiceAnswer> myEventConsumer;

    public TypeScriptServiceStandardOutputProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull Consumer<?> readyConsumer, @NotNull Consumer<? super JSLanguageServiceAnswer> eventConsumer, @Nullable String serviceName, @NotNull String tsServicePath) {
        if (project == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(1);
        }
        if (readyConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(2);
        }
        if (eventConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(3);
        }
        if (tsServicePath == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(4);
        }
        super(serviceName, project, readyConsumer);
        this.mySettings = settings;
        this.myEventConsumer = eventConsumer;
        this.myServicePath = tsServicePath;
    }

    @Override
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        this.fillState(state);
        return state;
    }

    protected void fillState(TypeScriptServiceInitialStateObject state) {
        String packageJsonPath;
        state.pluginName = "typescript";
        state.pluginPath = LocalFilePath.create(new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/ts-plugin").getAbsolutePath());
        String path = this.getServicePath();
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.createFromText(this.myServicePath);
        if (yarnPnpNodePackage != null && (packageJsonPath = yarnPnpNodePackage.getPackageJsonPath(this.myProject)) != null) {
            state.packageJson = LocalFilePath.create(packageJsonPath);
            path = yarnPnpNodePackage.getName();
        }
        state.serverFolderPath = LocalFilePath.create(path);
        state.sessionId = String.valueOf(this.mySessionId);
        state.isUseSingleInferredProject = this.mySettings.isUseSingleInferredProject();
        state.defaultConfig = LocalFilePath.create(this.getDefaultConfigPath());
        state.pluginProbeLocations = this.getProbeLocations(state);
        this.setManualOptions(state);
    }

    @Nullable
    private String getDefaultConfigPath() {
        if (this.myProject.isDisposed() || DumbService.isDumb((Project)this.myProject) || !StringUtil.isEmpty((String)this.mySettings.getDefaultServiceOptions())) {
            return null;
        }
        List<VirtualFile> files = TypeScriptConfigService.Provider.get(this.myProject).getConfigFiles();
        if (files.size() == 0) {
            return null;
        }
        List result2 = ContainerUtil.filter(files, el -> {
            VirtualFile directory = el.getParent();
            VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(el);
            return directory.equals(contentRoot);
        });
        return result2.size() == 1 ? JSLanguageServiceUtil.normalizeNameAndPath((VirtualFile)result2.get(0)) : null;
    }

    private LocalFilePath @NotNull [] getProbeLocations(TypeScriptServiceInitialStateObject state) {
        String path;
        VirtualFile dir;
        File nodeModulesParentFile;
        HashSet<LocalFilePath> pluginProbeLocations = new HashSet<LocalFilePath>();
        File tsserverFile = new File(LocalFilePath.getPath(state.serverFolderPath));
        File typescriptPackageFile = tsserverFile.getParentFile();
        File nodeModulesFile = typescriptPackageFile != null ? typescriptPackageFile.getParentFile() : null;
        File file2 = nodeModulesParentFile = nodeModulesFile != null ? nodeModulesFile.getParentFile() : null;
        if (nodeModulesParentFile != null) {
            pluginProbeLocations.add(LocalFilePath.create(nodeModulesParentFile.getPath()));
        }
        if ((dir = this.myProject.getBaseDir()) != null && (path = dir.getCanonicalPath()) != null) {
            pluginProbeLocations.add(LocalFilePath.create(FileUtil.toSystemDependentName((String)path)));
        }
        LocalFilePath[] localFilePathArray = pluginProbeLocations.toArray(new LocalFilePath[0]);
        if (localFilePathArray == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(5);
        }
        return localFilePathArray;
    }

    protected void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        if (state == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(6);
        }
        state.hasManualParams = this.mySettings.useDeprecatedSettings();
        String params = this.mySettings.getDefaultServiceOptions();
        boolean emptyOrSpaces = StringUtil.isEmptyOrSpaces((String)params);
        if (emptyOrSpaces && !state.hasManualParams) {
            return;
        }
        Object[] parsedParams = emptyOrSpaces ? ArrayUtilRt.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
        ArrayList paramList = ContainerUtil.newArrayList((Object[])parsedParams);
        if (!state.hasManualParams) {
            if (paramList.size() != 0) {
                state.commandLineArguments = (LocalFilePath[])ContainerUtil.map2Array((Collection)paramList, LocalFilePath.class, path -> LocalFilePath.create(path));
            }
            return;
        }
        String outFile = null;
        boolean hasMainFile = this.hasMainFile();
        if (this.hasOutputDirectory()) {
            state.projectPath = LocalFilePath.create(this.getProjectPathString());
            Pair<String, String> pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair != null) {
                outFile = (String)pair.first;
                String outDir = (String)pair.second;
                if (!StringUtil.isEmpty((String)outDir)) {
                    if (outFile == null && !outDir.contains("$")) {
                        paramList.add("--outDir");
                        paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
                    } else {
                        state.outPath = LocalFilePath.create((String)pair.second);
                    }
                }
            }
        }
        boolean existsCommandLineOutParam = this.checkExistsCommandLineOut((String[])parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            paramList.add(FileUtilRt.toSystemDependentName(outFile));
        }
        if (this.mySettings.isGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            state.commandLineArguments = (LocalFilePath[])ContainerUtil.map2Array((Collection)paramList, LocalFilePath.class, path -> LocalFilePath.create(path));
        }
        if (hasMainFile) {
            state.mainFilePath = LocalFilePath.create(this.mySettings.getMainFilePath());
        }
    }

    @NotNull
    protected String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)this.mySettings.getOutDirectory());
        DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!outWithExpandedProjectMacro.contains(macroName)) continue;
            String expand = macro.expand(context);
            if (expand == null) {
                expand = "";
            }
            outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
        }
        String string = outWithExpandedProjectMacro;
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull String text) {
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(8);
        }
        if (text == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(9);
        }
        if ("event".equals(answer.getType())) {
            if (!this.processAsEventCompletion(answer)) {
                this.myEventConsumer.consume((Object)answer);
            }
            return;
        }
        super.processAnswer(answer, text);
    }

    private boolean processAsEventCompletion(@NotNull JSLanguageServiceAnswer answer) {
        String property;
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(10);
        }
        if (!REQUEST_COMPLETED.equals(property = answer.getProperty("event"))) {
            return false;
        }
        JsonObject element = answer.getElement();
        JsonElement body = element.get(BODY);
        if (body == null || !body.isJsonObject()) {
            return false;
        }
        JsonObject object = body.getAsJsonObject();
        JsonElement seq = object.get("request_seq");
        if (seq == null || !seq.isJsonPrimitive()) {
            return false;
        }
        int intSeq = seq.getAsInt();
        JSLanguageServiceAnswerConsumer callback = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(intSeq);
        if (callback == null) {
            return false;
        }
        callback.consume(answer);
        return true;
    }

    @Override
    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
    }

    @Override
    public final Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(11);
        }
        if (data == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(12);
        }
        if (!(data instanceof TypeScriptCommandSetRequest)) {
            return super.sendCommand(command, data, resultConsumer);
        }
        final LinkedHashMap<JSLanguageServiceObject, JSLanguageServiceCommand> requests = ((TypeScriptCommandSetRequest)data).nestedRequests;
        if (requests.size() == 1) {
            JSLanguageServiceObject item = (JSLanguageServiceObject)ContainerUtil.getFirstItem(requests.keySet());
            JSLanguageServiceCommand serviceCommand = requests.get(item);
            assert (item != null);
            return super.sendCommand(serviceCommand, item, resultConsumer);
        }
        JSLanguageServiceAnswerConsumer mergedConsumer = resultConsumer == null ? null : new JSLanguageServiceAnswerConsumer(){
            final AtomicInteger requestsCount;
            {
                this.requestsCount = new AtomicInteger(requests.size());
            }

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (this.requestsCount.decrementAndGet() == 0) {
                    resultConsumer.consume(message);
                }
            }
        };
        ArrayList ids = new ArrayList();
        try {
            requests.forEach((nestedObject, nestedCommand) -> {
                try {
                    ids.add(super.sendCommand((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedObject, mergedConsumer));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
        catch (IORuntimeException e) {
            throw e.getCause();
        }
        return ids;
    }

    @Override
    protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(13);
        }
        super.addNodeProcessAdditionalArguments(commandLine);
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            commandLine.withEnvironment("TSS_LOG", JSLanguageServiceQueue.LOGGER.isTraceEnabled() ? "-level verbose" : "");
        }
        if (this.myServiceName != null) {
            JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(commandLine, this.myServiceName, () -> Registry.stringValue((String)"typescript.service.node.arguments"));
        }
        JSLanguageServiceUtil.addNodePathFromRegistry(commandLine, () -> Registry.stringValue((String)"typescript.service.node.path"));
    }

    @NotNull
    public String getServicePath() {
        String string = this.myServicePath + "/";
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected boolean hasMainFile() {
        return this.mySettings.useMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected boolean hasOutputDirectory() {
        return this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        int indexOfSeparator;
        int indexOfDot;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
            if (indexOfSeparator >= 0) {
                outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
            } else {
                outFile = outWithExpandedProjectMacro;
                outWithExpandedProjectMacro = null;
            }
        }
        if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
            String path = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Pair pair = Pair.create(outFile, (Object)path);
            if (pair == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(15);
            }
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        if (pair == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    protected String getProjectPathString() {
        String path = this.myProject.getBasePath();
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path));
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(17);
        }
        return string;
    }

    protected boolean checkExistsCommandLineOut(String[] parse) {
        for (String s : parse) {
            if (!"-out".equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getWorkingDirectory() {
        VirtualFile directory;
        VirtualFile packageJson;
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.createFromText(this.myServicePath);
        if (yarnPnpNodePackage != null && (packageJson = yarnPnpNodePackage.getPackageJson(this.myProject)) != null && (directory = packageJson.getParent()) != null) {
            return directory.getPath();
        }
        return super.getWorkingDirectory();
    }

    @Override
    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        YarnPnpNodePackage nodePackage;
        if (project == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(18);
        }
        if ((nodePackage = YarnPnpNodePackage.createFromText(this.myServicePath)) != null) {
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions(project).withRequiredNodePackage(nodePackage);
            if (options == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(19);
            }
            return options;
        }
        NodeCommandLineConfigurator.Options options = super.getNodeCommandLineConfiguratorOptions(project);
        if (options == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(20);
        }
        return options;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProbeLocations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandOutputDirectoryMacro";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutInformation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPathString";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setManualOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAsEventCompletion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IORuntimeException
    extends RuntimeException {
        IORuntimeException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

