/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptPsiIcons;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceCompletionContributor
extends CompletionContributor {
    private static final Logger LOGGER = Logger.getInstance(TypeScriptLanguageServiceCompletionContributor.class);
    public static final long TIMEOUT_MILLS = 700L;
    public static final long NO_WAITING = 0L;
    private static final Set<String> FUNCTION_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"call", "method", "function", "local function"});
    private static final int SERVICE_ITEMS_LIMIT = 500;
    public static final Couple<String> DEFAULT_SIGNATURE = Couple.of((Object)"(...)", null);
    public static final Key<Object> SERVICE_COMPLETION_KEY = Key.create((String)"service.item");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        long toWait;
        List<TypeScriptCompletionResponse.CompletionEntryDetail> details;
        PsiElement context;
        PsiFile file2;
        MergeStrategy strategy;
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((strategy = this.getMergeStrategy(parameters, file2 = parameters.getOriginalFile(), context = parameters.getPosition())) == MergeStrategy.NON) {
            return;
        }
        TypeScriptCompilerService tsService = this.getServiceIfEnabled(parameters, file2);
        if (tsService == null) {
            return;
        }
        Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> serviceFuture = this.getServiceEntriesFuture(tsService, file2, parameters);
        if (serviceFuture == null) {
            return;
        }
        LinkedHashMap<String, CompletionResult> remainingCollectedItems = new LinkedHashMap<String, CompletionResult>();
        LinkedHashMap<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithServiceCompletionEntries = new LinkedHashMap<String, TypeScriptCompletionResponse.CompletionEntryDetail>();
        Ref serviceFutureWasDone = Ref.create((Object)((Object)State.NOT_COMPLETED));
        HashSet explicitItems = new HashSet();
        SmartList deferredItems = new SmartList();
        long startProcessTime = System.currentTimeMillis();
        resultSet.runRemainingContributors(parameters, arg_0 -> TypeScriptLanguageServiceCompletionContributor.lambda$fillCompletionVariants$4((List)deferredItems, resultSet, explicitItems, namesWithServiceCompletionEntries, serviceFutureWasDone, remainingCollectedItems, serviceFuture, startProcessTime, strategy, arg_0));
        State state = (State)((Object)serviceFutureWasDone.get());
        if (state == State.NOT_COMPLETED && (state = TypeScriptLanguageServiceCompletionContributor.getStateByDetails(details = JSLanguageServiceUtil.awaitFuture(serviceFuture, toWait = TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime), 5L, null))) == State.COMPLETED && details != null) {
            namesWithServiceCompletionEntries.putAll(ContainerUtil.map2Map(details, detail -> Pair.create((Object)detail.name, (Object)detail)));
        }
        if (state == State.COMPLETED_EMPTY) {
            remainingCollectedItems.forEach((key, val) -> resultSet.passResult(val));
            deferredItems.forEach(arg_0 -> ((CompletionResultSet)resultSet).passResult(arg_0));
            resultSet.stopHere();
            return;
        }
        explicitItems.forEach(el -> {
            TypeScriptCompletionResponse.CompletionEntryDetail cfr_ignored_0 = (TypeScriptCompletionResponse.CompletionEntryDetail)namesWithServiceCompletionEntries.remove(el);
        });
        this.processAllServiceCompletionEntries(parameters, resultSet, remainingCollectedItems, namesWithServiceCompletionEntries, tsService, startProcessTime, strategy);
        deferredItems.forEach(arg_0 -> ((CompletionResultSet)resultSet).passResult(arg_0));
        resultSet.stopHere();
    }

    @Nullable
    public TypeScriptCompilerService getServiceIfEnabled(@NotNull CompletionParameters parameters, @NotNull PsiFile file2) {
        VirtualFile virtualFile;
        Project project;
        TypeScriptCompilerService service;
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((service = TypeScriptCompilerService.getServiceForFile(project = parameters.getOriginalFile().getProject(), virtualFile = this.getVirtualFile(file2))) == null || !service.checkCanUseService()) {
            return null;
        }
        if (!(service.isServiceCreated() || !DumbService.isDumb((Project)project) && TypeScriptConfigService.Provider.hasConfigs(project))) {
            return null;
        }
        return service;
    }

    @NotNull
    private MergeStrategy getMergeStrategy(@NotNull CompletionParameters parameters, @Nullable PsiFile file2, @NotNull PsiElement context) {
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(5);
        }
        if (parameters.isExtendedCompletion() || file2 == null) {
            MergeStrategy mergeStrategy = MergeStrategy.NON;
            if (mergeStrategy == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(6);
            }
            return mergeStrategy;
        }
        boolean isJavaScript = DialectDetector.isJavaScript(context);
        if (!isJavaScript && !DialectDetector.isTypeScript(context) || isJavaScript && !TypeScriptConfigUtil.allowJS(file2)) {
            MergeStrategy mergeStrategy = MergeStrategy.NON;
            if (mergeStrategy == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(7);
            }
            return mergeStrategy;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!virtualFile.isInLocalFileSystem() || !TypeScriptLanguageServiceUtil.useServiceCompletion(file2.getProject())) {
            MergeStrategy mergeStrategy = MergeStrategy.NON;
            if (mergeStrategy == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(8);
            }
            return mergeStrategy;
        }
        if (!this.isApplicablePlaceForCompletion(context)) {
            MergeStrategy mergeStrategy = MergeStrategy.NON;
            if (mergeStrategy == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(9);
            }
            return mergeStrategy;
        }
        MergeStrategy mergeStrategy = isJavaScript ? MergeStrategy.MERGE : MergeStrategy.REPLACE;
        if (mergeStrategy == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(10);
        }
        return mergeStrategy;
    }

    private static long timeToWait(long startProcess) {
        long diffAwaited = System.currentTimeMillis() - startProcess;
        return 700L - diffAwaited;
    }

    private static void addElementToRemainingMap(@NotNull Map<String, CompletionResult> remainingCollectedItems, @NotNull CompletionResult completionResult) {
        LookupElement element;
        String lookupString;
        CompletionResult oldCompletionResult;
        if (remainingCollectedItems == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(11);
        }
        if (completionResult == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(12);
        }
        if ((oldCompletionResult = remainingCollectedItems.get(lookupString = (element = completionResult.getLookupElement()).getLookupString())) != null) {
            LookupElement oldLookupElement = oldCompletionResult.getLookupElement();
            if (!(oldLookupElement instanceof TypeScriptOverloadLookupElementDecorator) && !oldLookupElement.equals(element)) {
                CompletionResult decoratedItem = oldCompletionResult.withLookupElement(TypeScriptLanguageServiceCompletionContributor.overloadDecorator(oldLookupElement));
                remainingCollectedItems.replace(lookupString, decoratedItem);
            }
        } else {
            remainingCollectedItems.put(lookupString, completionResult);
        }
    }

    @NotNull
    private static State getStateByDetails(@Nullable List<TypeScriptCompletionResponse.CompletionEntryDetail> details) {
        State state = details != null && !details.isEmpty() && details.size() < 500 ? State.COMPLETED : State.COMPLETED_EMPTY;
        if (state == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(13);
        }
        return state;
    }

    private static void processRemainingItem(@NotNull CompletionResultSet resultSet, @NotNull CompletionResult el, @NotNull Map<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithCompletionEntries, @NotNull MergeStrategy strategy) {
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(14);
        }
        if (el == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(15);
        }
        if (namesWithCompletionEntries == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(16);
        }
        if (strategy == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(17);
        }
        LookupElement element = el.getLookupElement();
        if (namesWithCompletionEntries.isEmpty()) {
            if (strategy == MergeStrategy.MERGE) {
                resultSet.passResult(el);
            }
            return;
        }
        TypeScriptCompletionResponse.CompletionEntryDetail item = namesWithCompletionEntries.remove(element.getLookupString());
        if (item != null) {
            LookupElement newElement = TypeScriptLanguageServiceCompletionContributor.overridePriority(element);
            TypeScriptLanguageServiceCompletionContributor.setServiceCompletion(newElement);
            el = newElement == element ? el : el.withLookupElement(newElement);
            resultSet.passResult(el);
            return;
        }
        if (strategy == MergeStrategy.MERGE) {
            resultSet.passResult(el);
        }
    }

    @NotNull
    private static LookupElement overridePriority(@NotNull LookupElement element) {
        double priority;
        if (element == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(18);
        }
        if ((priority = JSCompletionUtil.getLookupElementPriority(element = JSLookupUtilImpl.withPartial(element, false))) >= (double)JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getPriorityValue()) {
            LookupElement lookupElement = element;
            if (lookupElement == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(19);
            }
            return lookupElement;
        }
        LookupElement lookupElement = JSCompletionUtil.withJSLookupPriority(element, JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY);
        if (lookupElement == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(20);
        }
        return lookupElement;
    }

    /*
     * WARNING - void declaration
     */
    private void processAllServiceCompletionEntries(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet, Map<String, CompletionResult> remainingCollectedItems, Map<String, TypeScriptCompletionResponse.CompletionEntryDetail> namesWithCompletionEntries, @NotNull TypeScriptCompilerService tsService, long startProcessTime, @NotNull MergeStrategy mergeStrategy) {
        void strategy;
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(21);
        }
        if (resultSet == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(22);
        }
        if (tsService == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(23);
        }
        if (mergeStrategy == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(24);
        }
        remainingCollectedItems.values().forEach(arg_0 -> TypeScriptLanguageServiceCompletionContributor.lambda$processAllServiceCompletionEntries$8(resultSet, namesWithCompletionEntries, (MergeStrategy)strategy, arg_0));
        ArrayList<TypeScriptCompletionResponse.CompletionEntryDetail> entriesWithoutDetails = new ArrayList<TypeScriptCompletionResponse.CompletionEntryDetail>(namesWithCompletionEntries.values());
        if (!entriesWithoutDetails.isEmpty()) {
            List<TypeScriptCompletionResponse.CompletionEntryDetail> result2 = this.getDetailedEntries(parameters, tsService, entriesWithoutDetails, startProcessTime);
            if (result2 == null) {
                result2 = entriesWithoutDetails;
            }
            CompletionResultSet finalResultSet = resultSet.withRelevanceSorter((CompletionSorter)JSCompletionContributor.createOwnSorter(parameters));
            result2.forEach(item -> {
                LookupElement el = this.createLookupElement((TypeScriptCompletionResponse.CompletionEntryDetail)item, null);
                if (el != null) {
                    finalResultSet.consume(el);
                }
            });
        }
    }

    @Nullable
    protected List<TypeScriptCompletionResponse.CompletionEntryDetail> getDetailedEntries(@NotNull CompletionParameters parameters, @NotNull TypeScriptCompilerService tsService, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> entriesWithoutDetails, long startProcessTime) {
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(25);
        }
        if (tsService == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(26);
        }
        if (entriesWithoutDetails == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(27);
        }
        PsiFile file2 = parameters.getOriginalFile();
        VirtualFile virtualFile = this.getVirtualFile(file2);
        Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> detailedItems = tsService.getDetailedCompletionItems(virtualFile, entriesWithoutDetails, parameters.getEditor().getDocument(), parameters.getOffset());
        long toWait = TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime);
        if (toWait > 0L) {
            return JSLanguageServiceUtil.awaitFuture(detailedItems, toWait, 5L, null);
        }
        return null;
    }

    @Nullable
    protected Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getServiceEntriesFuture(@NotNull TypeScriptCompilerService service, @NotNull PsiFile file2, @NotNull CompletionParameters parameters) {
        if (service == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(29);
        }
        if (parameters == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = this.getVirtualFile(file2);
        return service.updateAndGetCompletionItems(virtualFile, file2, parameters.getEditor().getDocument(), parameters.getOffset());
    }

    protected VirtualFile getVirtualFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(31);
        }
        return file2.getVirtualFile();
    }

    protected boolean isApplicablePlaceForCompletion(PsiElement position) {
        ASTNode node;
        PsiElement parent = position.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof JSXXmlLiteralExpressionImpl && (node = position.getNode()).getElementType() == JSTokenTypes.XML_TAG_NAME && position.textContains('.') && node.getText().endsWith("IntellijIdeaRulezzz")) {
            return true;
        }
        if (parent instanceof JSXmlAttributeImpl) {
            return true;
        }
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() != null) {
            return true;
        }
        if (parent instanceof JSReferenceExpression && TypeScriptLanguageServiceCompletionContributor.isShorthandedProperty(parent)) {
            return true;
        }
        return parent instanceof JSVariable && parent.getParent() instanceof JSDestructuringProperty;
    }

    private static boolean isShorthandedProperty(@NotNull PsiElement parent) {
        PsiElement candidate;
        if (parent == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(32);
        }
        return (candidate = parent.getParent()) instanceof ES6Property && ((ES6Property)candidate).isShorthanded();
    }

    @Nullable
    private LookupElement createLookupElement(@NotNull TypeScriptCompletionResponse.CompletionEntryDetail entry, @Nullable LookupElement realSource) {
        if (entry == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(33);
        }
        LookupElement serviceLookupItem = this.createLookupElementImpl(entry, realSource);
        TypeScriptLanguageServiceCompletionContributor.setServiceCompletion(serviceLookupItem);
        return serviceLookupItem;
    }

    private static void setServiceCompletion(@Nullable LookupElement serviceLookupItem) {
        if (serviceLookupItem != null && ApplicationManager.getApplication().isUnitTestMode()) {
            serviceLookupItem.putUserData(SERVICE_COMPLETION_KEY, (Object)Boolean.TRUE);
        }
    }

    @Nullable
    protected LookupElement createLookupElementImpl(@NotNull TypeScriptCompletionResponse.CompletionEntryDetail entry, @Nullable LookupElement realSource) {
        String signature;
        LookupElementBuilder item;
        int defaultProximity;
        if (entry == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(34);
        }
        ProgressManager.checkCanceled();
        String kind = entry.kind;
        String kindModifiers = entry.kindModifiers;
        boolean isFunction = FUNCTION_TYPES.contains(kind);
        String lookupString = entry.name;
        if (lookupString == null) {
            return null;
        }
        LookupElement lookupSource = realSource;
        PsiElement psiSource = lookupSource == null ? null : lookupSource.getPsiElement();
        String source = psiSource == null ? lookupString : psiSource;
        int defaultPriority = JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getPriorityValue();
        double sourcePriority = defaultPriority;
        int sourceProximity = defaultProximity = JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getProximityValue();
        int sourceGrouping = 0;
        InsertHandler sourceInsertHandler = null;
        boolean hasPriority = false;
        if (lookupSource instanceof TypeScriptOverloadLookupElementDecorator) {
            lookupSource = ((TypeScriptOverloadLookupElementDecorator)lookupSource).getDelegate();
        }
        if (lookupSource instanceof PrioritizedLookupElement) {
            PrioritizedLookupElement prioritizedLookupElement = (PrioritizedLookupElement)lookupSource;
            sourcePriority = prioritizedLookupElement.getPriority();
            sourceProximity = prioritizedLookupElement.getExplicitProximity();
            sourceGrouping = prioritizedLookupElement.getGrouping();
            lookupSource = prioritizedLookupElement.getDelegate();
            hasPriority = true;
        }
        if (lookupSource instanceof LookupElementBuilder) {
            item = (LookupElementBuilder)lookupSource;
            sourceInsertHandler = ((LookupElementBuilder)lookupSource).getInsertHandler();
        } else {
            LookupElementBuilder builder = LookupElementBuilder.create((Object)source, (String)lookupString);
            item = builder.withBoldness(JSLookupUtilImpl.isBold(lookupSource));
            hasPriority = true;
        }
        boolean isLowPriority = TypeScriptLanguageServiceCompletionContributor.isLowPriority(psiSource);
        Couple<String> signatureAndReturn = isFunction ? TypeScriptLanguageServiceCompletionContributor.getSignatureAndResultType(entry) : null;
        int moveCaret = 1;
        if (signatureAndReturn != null && (signature = (String)signatureAndReturn.first) != null && signatureAndReturn.second != null && signature.length() == 2) {
            moveCaret = 2;
        }
        int toMoveCaret = moveCaret;
        if ((signatureAndReturn == DEFAULT_SIGNATURE || !isFunction && !(psiSource instanceof JSFunction)) && realSource != null) {
            TypeScriptFunction function2;
            if (source instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadsWithImplementation(function2 = (TypeScriptFunction)source).size() > 0) {
                return TypeScriptLanguageServiceCompletionContributor.overloadDecorator(realSource);
            }
            return sourcePriority <= 1.0 ? PrioritizedLookupElement.withExplicitProximity((LookupElement)TypeScriptLanguageServiceCompletionContributor.withPriority(realSource, defaultPriority), (int)defaultProximity) : realSource;
        }
        item = item.withRenderer((LookupElementRenderer)new TypeScriptServiceLookupElementRenderer(lookupString, kind, kindModifiers, signatureAndReturn, entry));
        if (isFunction && sourceInsertHandler == null) {
            item = item.withInsertHandler(TypeScriptLanguageServiceCompletionContributor.createFunctionInsertHandler(toMoveCaret));
        }
        if (isLowPriority) {
            return TypeScriptLanguageServiceCompletionContributor.withPriority((LookupElement)item, -1.0);
        }
        return hasPriority ? TypeScriptLanguageServiceCompletionContributor.newPrioritizedElement((LookupElement)item, sourcePriority, sourceProximity, sourceGrouping) : item;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static LookupElement newPrioritizedElement(@NotNull LookupElement item, double sourcePriority, int sourceProximity, int n) {
        void sourceGrouping;
        if (item == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(35);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)TypeScriptLanguageServiceCompletionContributor.withPriority(item, sourcePriority), (int)sourceGrouping), (int)sourceProximity);
        if (lookupElement == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(36);
        }
        return lookupElement;
    }

    @Contract(value="!null -> !null")
    private static LookupElement overloadDecorator(LookupElement lookupSource) {
        if (lookupSource instanceof TypeScriptOverloadLookupElementDecorator || lookupSource == null || lookupSource instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)lookupSource).getDelegate() instanceof TypeScriptOverloadLookupElementDecorator) {
            return lookupSource;
        }
        if (lookupSource instanceof PrioritizedLookupElement) {
            PrioritizedLookupElement lookupElement = (PrioritizedLookupElement)lookupSource;
            LookupElement original = ((PrioritizedLookupElement)lookupSource).getDelegate();
            TypeScriptOverloadLookupElementDecorator newElement = new TypeScriptOverloadLookupElementDecorator(original);
            return TypeScriptLanguageServiceCompletionContributor.newPrioritizedElement((LookupElement)newElement, lookupElement.getPriority(), lookupElement.getExplicitProximity(), lookupElement.getGrouping());
        }
        return new TypeScriptOverloadLookupElementDecorator(lookupSource);
    }

    private static LookupElement withPriority(@NotNull LookupElement element, double newPriority) {
        if (element == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(37);
        }
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)newPriority);
    }

    private static boolean isLowPriority(PsiElement psiSource) {
        String name;
        JSClass memberContainingClass;
        return psiSource instanceof JSElement && (memberContainingClass = JSUtils.getMemberContainingClass(psiSource)) != null && JSCommonTypeNames.OBJECT_FUNCTION_CLASS_NAMES.contains(name = memberContainingClass.getName());
    }

    @NotNull
    private static InsertHandler<LookupElement> createFunctionInsertHandler(final int toMoveCaret) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSInsertHandler.insertBracesIfNeeded(context, toMoveCaret);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static Couple<String> getSignatureAndResultType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        StringBuilder signature;
        int cursor;
        TypeScriptSymbolDisplayPart[] parts;
        block21: {
            int indexToStart;
            block20: {
                block19: {
                    int indexToStartReadParameter;
                    block18: {
                        block17: {
                            block16: {
                                Couple<String> couple;
                                try {
                                    parts = entry.displayParts;
                                    if (parts != null && parts.length != 0) break block16;
                                    couple = DEFAULT_SIGNATURE;
                                }
                                catch (Exception e) {
                                    LOGGER.error(e.getMessage(), (Throwable)e);
                                    Couple<String> couple2 = DEFAULT_SIGNATURE;
                                    if (couple2 == null) {
                                        TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(45);
                                    }
                                    return couple2;
                                }
                                if (couple == null) {
                                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(38);
                                }
                                return couple;
                            }
                            indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
                            if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) break block17;
                            Couple<String> couple = DEFAULT_SIGNATURE;
                            if (couple == null) {
                                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(39);
                            }
                            return couple;
                        }
                        indexToStartReadParameter = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, '(');
                        if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStartReadParameter)) break block18;
                        Couple<String> couple = DEFAULT_SIGNATURE;
                        if (couple == null) {
                            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(40);
                        }
                        return couple;
                    }
                    cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStartReadParameter);
                    if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block19;
                    Couple<String> couple = DEFAULT_SIGNATURE;
                    if (couple == null) {
                        TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(41);
                    }
                    return couple;
                }
                signature = new StringBuilder();
                cursor = TypeScriptLanguageServiceCompletionContributor.readFunctionSignature(parts, cursor, signature);
                if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block20;
                Couple couple = Couple.of((Object)signature.toString(), null);
                if (couple == null) {
                    TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(42);
                }
                return couple;
            }
            cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (!TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) break block21;
            Couple couple = Couple.of((Object)signature.toString(), null);
            if (couple == null) {
                TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(43);
            }
            return couple;
        }
        String typeText = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
        Couple couple = Couple.of((Object)signature.toString(), (Object)typeText);
        if (couple == null) {
            TypeScriptLanguageServiceCompletionContributor.$$$reportNull$$$0(44);
        }
        return couple;
    }

    private static int skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (TypeScriptLanguageServiceCompletionContributor.isWhitespace(part.kind)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static String readPropertyType(TypeScriptCompletionResponse.CompletionEntryDetail entry) {
        try {
            TypeScriptSymbolDisplayPart[] parts = entry.displayParts;
            if (parts == null || parts.length == 0) {
                return null;
            }
            int indexToStart = TypeScriptLanguageServiceCompletionContributor.skipDescriptionBraces(parts);
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
                return null;
            }
            int cursor = TypeScriptLanguageServiceCompletionContributor.skipWhitespaces(parts, indexToStart);
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
                return null;
            }
            cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
            if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
                return null;
            }
            String typeText = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
            if (!StringUtil.isEmpty((String)typeText)) {
                return typeText;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static int readFunctionSignature(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        ArrayDeque<Boolean> openedBraces = new ArrayDeque<Boolean>();
        openedBraces.add(true);
        signature.append("(");
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) {
                openedBraces.add(true);
            }
            if (TypeScriptLanguageServiceCompletionContributor.isCloseBrace(kind, text)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceResponseParser.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static int skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        ArrayDeque<Boolean> braces = new ArrayDeque<Boolean>();
        boolean firstBraceAdded = false;
        for (int i = 0; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String kind = part.kind;
            String text = part.text;
            if (!firstBraceAdded) {
                if (!TypeScriptLanguageServiceCompletionContributor.isOpenBrace(kind, text)) continue;
                int nextToken = i + 1;
                if (nextToken < parts.length && "parameterName".equals(parts[nextToken].kind)) {
                    return i;
                }
                braces.add(true);
                firstBraceAdded = true;
                continue;
            }
            TypeScriptLanguageServiceCompletionContributor.fillBraces(braces, kind, text);
            if (!braces.isEmpty()) continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean isWhitespace(String kind) {
        return "space".equals(kind);
    }

    private static boolean isOpenBrace(String kind, String text) {
        return "punctuation".equals(kind) && text.equals("(");
    }

    private static boolean isCloseBrace(String kind, String text) {
        return "punctuation".equals(kind) && text.equals(")");
    }

    private static void fillBraces(Deque<Boolean> braces, String kind, String text) {
        if ("punctuation".equals(kind)) {
            if (text.equals(")")) {
                braces.pop();
            } else if (text.equals("(")) {
                braces.add(true);
            }
        }
    }

    @Nullable
    protected Icon getIcon(String kind, @Nullable String kindModifiers) {
        Icon resultIcon = TypeScriptLanguageServiceCompletionContributor.getKindIcon(kind);
        if (resultIcon != null) {
            String[] modifiers = kindModifiers == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : kindModifiers.split(",");
            boolean isStatic = false;
            boolean isReadonly = false;
            for (String modifier : modifiers) {
                if ("static".equals(modifier = StringUtil.trim((String)modifier))) {
                    isStatic = true;
                }
                if (!"readonly".equals(modifier)) continue;
                isReadonly = true;
            }
            resultIcon = JSStubElementImpl.blendFlags(resultIcon, isStatic, isReadonly);
        }
        return resultIcon;
    }

    @Nullable
    protected static Icon getKindIcon(@Nullable String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "function": 
            case "local function": {
                return PlatformIcons.FUNCTION_ICON;
            }
            case "method": 
            case "call": 
            case "index": {
                return PlatformIcons.METHOD_ICON;
            }
            case "construct": 
            case "constructor": {
                return JSFunctionImpl.CONSTRUCTOR_ICON;
            }
            case "getter": 
            case "setter": 
            case "property": {
                return PlatformIcons.FIELD_ICON;
            }
            case "class": {
                return JavaScriptPsiIcons.Classes.TypeScriptClass;
            }
            case "interface": {
                return JavaScriptPsiIcons.Classes.Typescript_Interface;
            }
            case "enum": {
                return JavaScriptPsiIcons.Classes.Typescript_Enum;
            }
            case "module": {
                return JavaScriptPsiIcons.Classes.Typescript_Module;
            }
        }
        return PlatformIcons.VARIABLE_ICON;
    }

    private static /* synthetic */ void lambda$processAllServiceCompletionEntries$8(CompletionResultSet resultSet, Map namesWithCompletionEntries, MergeStrategy strategy, CompletionResult current) {
        TypeScriptLanguageServiceCompletionContributor.processRemainingItem(resultSet, current, namesWithCompletionEntries, strategy);
    }

    private static /* synthetic */ void lambda$fillCompletionVariants$4(List deferredItems, CompletionResultSet resultSet, Set explicitItems, Map namesWithServiceCompletionEntries, Ref serviceFutureWasDone, Map remainingCollectedItems, Future serviceFuture, long startProcessTime, MergeStrategy strategy, CompletionResult el) {
        boolean isDeferred;
        LookupElement element = el.getLookupElement();
        String lookupString = element.getLookupString();
        double priority = JSCompletionUtil.getLookupElementPriority(element);
        boolean bl = isDeferred = !StringUtil.isJavaIdentifier((String)lookupString);
        if (priority >= (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue() || isDeferred) {
            if (isDeferred) {
                deferredItems.add(el);
            } else {
                resultSet.passResult(el);
            }
            explicitItems.add(lookupString);
            namesWithServiceCompletionEntries.remove(lookupString);
            return;
        }
        State state = (State)((Object)serviceFutureWasDone.get());
        if (state == State.NOT_COMPLETED) {
            TypeScriptLanguageServiceCompletionContributor.addElementToRemainingMap(remainingCollectedItems, el);
            if (!serviceFuture.isDone() && TypeScriptLanguageServiceCompletionContributor.timeToWait(startProcessTime) >= 0L) {
                return;
            }
            List details = (List)JSLanguageServiceUtil.awaitFuture(serviceFuture, 0L, 5L, null);
            State newState = TypeScriptLanguageServiceCompletionContributor.getStateByDetails(details);
            serviceFutureWasDone.set((Object)newState);
            if (newState == State.COMPLETED && details != null) {
                namesWithServiceCompletionEntries.putAll(ContainerUtil.map2Map((Collection)details, detail -> Pair.create((Object)detail.name, (Object)detail)));
                explicitItems.forEach(smartItem -> {
                    TypeScriptCompletionResponse.CompletionEntryDetail cfr_ignored_0 = (TypeScriptCompletionResponse.CompletionEntryDetail)namesWithServiceCompletionEntries.remove(smartItem);
                });
                remainingCollectedItems.values().forEach(el1 -> TypeScriptLanguageServiceCompletionContributor.processRemainingItem(resultSet, el1, namesWithServiceCompletionEntries, strategy));
            } else {
                remainingCollectedItems.forEach((key, val) -> resultSet.passResult(val));
            }
            remainingCollectedItems.clear();
        } else if (state == State.COMPLETED_EMPTY) {
            resultSet.passResult(el);
        } else {
            TypeScriptLanguageServiceCompletionContributor.processRemainingItem(resultSet, el, namesWithServiceCompletionEntries, strategy);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingCollectedItems";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesWithCompletionEntries";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 18: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsService";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entriesWithoutDetails";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/ide/TypeScriptLanguageServiceCompletionContributor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeStrategy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateByDetails";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "overridePriority";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newPrioritizedElement";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureAndResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceIfEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMergeStrategy";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addElementToRemainingMap";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processRemainingItem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "overridePriority";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processAllServiceCompletionEntries";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedEntries";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getServiceEntriesFuture";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandedProperty";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementImpl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newPrioritizedElement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "withPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TypeScriptServiceLookupElementRenderer
    extends LookupElementRenderer<LookupElement> {
        private final String myLookupString;
        private final String myKind;
        private final String myKindModifiers;
        private final Couple<String> mySignatureAndReturn;
        private final TypeScriptCompletionResponse.CompletionEntryDetail myEntry;

        TypeScriptServiceLookupElementRenderer(String lookupString, String kind, String kindModifiers, Couple<String> signatureAndReturn, TypeScriptCompletionResponse.CompletionEntryDetail entry) {
            this.myLookupString = lookupString;
            this.myKind = kind;
            this.myKindModifiers = kindModifiers;
            this.mySignatureAndReturn = signatureAndReturn;
            this.myEntry = entry;
        }

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                presentation.setItemTextBold(true);
            }
            presentation.setItemText(this.myLookupString);
            Icon icon = TypeScriptLanguageServiceCompletionContributor.this.getIcon(this.myKind, this.myKindModifiers);
            if (icon != null) {
                presentation.setIcon(icon);
            }
            if (this.mySignatureAndReturn != null) {
                String signature = (String)this.mySignatureAndReturn.first;
                String returnType = (String)this.mySignatureAndReturn.second;
                if (signature != null) {
                    presentation.setTailText(signature);
                }
                if (returnType != null) {
                    presentation.setTypeText(returnType);
                }
            } else {
                String type = TypeScriptLanguageServiceCompletionContributor.readPropertyType(this.myEntry);
                if (type != null) {
                    presentation.setTypeText(type);
                }
            }
        }
    }

    private static class TypeScriptOverloadLookupElementDecorator
    extends LookupElementDecorator<LookupElement> {
        TypeScriptOverloadLookupElementDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            String text = presentation.getTypeText();
            if (text != null) {
                presentation.setTypeText(text + " (+ overloads)");
            }
        }
    }

    static enum MergeStrategy {
        MERGE,
        REPLACE,
        NON;

    }

    static enum State {
        NOT_COMPLETED,
        COMPLETED,
        COMPLETED_EMPTY;

    }
}

