/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class RemoveASTNodeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix");
    private final String myPropKey;
    private final boolean myFixNewLines;

    public RemoveASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, @NotNull PsiElement element) {
        if (propKey == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(1);
        }
        this(propKey, false, element, element);
    }

    public RemoveASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (propKey == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(4);
        }
        super(startElement, endElement);
        LOG.assertTrue(startElement.getParent() == endElement.getParent());
        this.myPropKey = propKey;
        this.myFixNewLines = fixNewLines;
    }

    private static ASTNode @NotNull [] collectNodes(ASTNode from, ASTNode to) {
        ArrayList<ASTNode> result2 = new ArrayList<ASTNode>();
        ASTNode node = from;
        while (true) {
            result2.add(node);
            if (node == to) break;
            LOG.assertTrue((node = node.getTreeNext()) != null);
        }
        ASTNode[] aSTNodeArray = result2.toArray(ASTNode.EMPTY_ARRAY);
        if (aSTNodeArray == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(5);
        }
        return aSTNodeArray;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)this.myPropKey, (Object[])new Object[0]);
        if (string == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(11);
        }
        if (startElement.getParent() != endElement.getParent()) {
            return false;
        }
        for (ASTNode astNode : RemoveASTNodeFix.collectNodes(startElement.getNode(), endElement.getNode())) {
            if (astNode.getPsi().isValid()) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(13);
        }
        if (startElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            RemoveASTNodeFix.$$$reportNull$$$0(15);
        }
        FormatFixer fixer = null;
        ASTNode[] myAstNodes = RemoveASTNodeFix.collectNodes(startElement.getNode(), endElement.getNode());
        if (this.myFixNewLines && editor != null) {
            fixer = FormatFixer.create(file2, new TextRange(myAstNodes[0].getStartOffset(), myAstNodes[myAstNodes.length - 1].getStartOffset() + myAstNodes[myAstNodes.length - 1].getTextLength()), editor.getDocument(), FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        }
        for (ASTNode astNode : myAstNodes) {
            if (!astNode.getPsi().isValid()) continue;
            astNode.getPsi().delete();
        }
        if (fixer != null) {
            fixer.fixFormat();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

