/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import org.jetbrains.annotations.NotNull;

public interface JSTemplateExpressionCondition
extends PostfixTemplateExpressionCondition<JSExpression> {

    public static class ArrayCondition
    implements JSTemplateExpressionCondition {
        public static final String ID = "arrayType";

        @NotNull
        public String getPresentableName() {
            return "array";
        }

        @NotNull
        public String getId() {
            return ID;
        }

        public boolean value(@NotNull JSExpression expression) {
            if (expression == null) {
                ArrayCondition.$$$reportNull$$$0(0);
            }
            JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(expression));
            expanded = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(expanded);
            return expanded instanceof JSArrayType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$ArrayCondition", "value"));
        }
    }

    public static class NonVoidCondition
    implements JSTemplateExpressionCondition {
        public static final String ID = "nonVoid";

        public boolean value(@NotNull JSExpression expression) {
            JSType expanded;
            if (expression == null) {
                NonVoidCondition.$$$reportNull$$$0(0);
            }
            return !((expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(expression))) instanceof JSVoidType);
        }

        @NotNull
        public String getPresentableName() {
            return "non void";
        }

        @NotNull
        public String getId() {
            return ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/template/postfix/JSTemplateExpressionCondition$NonVoidCondition", "value"));
        }
    }

    public static interface Factory {
        public JSTemplateExpressionCondition create();
    }
}

