/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.ui.GuiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="JavaScriptSettings")
public class JSRootConfigurationBase
extends JSRootConfiguration
implements PersistentStateComponent<State> {
    protected final Project myProject;
    protected State myState;

    public JSRootConfigurationBase(Project project) {
        this.myProject = project;
    }

    public void storeLanguageLevel(@Nullable JSLanguageLevel languageLevel) {
        if (this.myState == null) {
            this.myState = new State();
        }
        this.myState.myLanguageLevel = languageLevel;
        if (languageLevel == null) {
            languageLevel = JSLanguageLevel.DEFAULT;
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
        if (languageLevel.isXmlEnabled() && languageLevel != JSLanguageLevel.FLOW) {
            mappings.associate(null, "HTML", true);
        }
        if (languageLevel == JSLanguageLevel.NASHORN) {
            mappings.associate(null, "Nashorn", true);
        } else {
            mappings.disassociate(null, "Nashorn");
        }
        GuiUtils.invokeLaterIfNeeded(() -> this.updateLibraries(), (ModalityState)ModalityState.defaultModalityState());
    }

    private void updateLibraries() {
        WriteAction.run(() -> JSLibraryManager.getInstance(this.myProject).commitChanges());
    }

    @Override
    public void storeLanguageLevelAndUpdateCaches(@Nullable JSLanguageLevel languageLevel) {
        this.storeLanguageLevel(languageLevel);
    }

    public static boolean requiresReparse(JSLanguageLevel oldLanguageLevel, JSLanguageLevel languageLevel) {
        return oldLanguageLevel != languageLevel;
    }

    @Override
    @NotNull
    public JSLanguageLevel getLanguageLevel() {
        JSLanguageLevel storedLanguageLevel = this.getStoredLanguageLevel();
        JSLanguageLevel jSLanguageLevel = storedLanguageLevel != null ? storedLanguageLevel : JSLanguageLevel.DEFAULT;
        if (jSLanguageLevel == null) {
            JSRootConfigurationBase.$$$reportNull$$$0(0);
        }
        return jSLanguageLevel;
    }

    @Override
    @Nullable
    public JSLanguageLevel getStoredLanguageLevel() {
        State state = this.myState;
        return state != null && state.myLanguageLevel != null ? state.myLanguageLevel : null;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            JSRootConfigurationBase.$$$reportNull$$$0(1);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/settings/JSRootConfigurationBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/settings/JSRootConfigurationBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        @Nullable
        private JSLanguageLevel myLanguageLevel;

        public String getLanguageLevel() {
            return this.myLanguageLevel != null ? this.myLanguageLevel.getId() : null;
        }

        public void setLanguageLevel(String languageLevel) {
            if (languageLevel != null) {
                this.myLanguageLevel = JSLanguageLevel.ofId(languageLevel);
            }
        }
    }
}

