/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSCustomExtractInterfaceHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractInterfaceHandler
extends BaseJSRefactoringHandler {
    private final BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> myDialogFactory;

    public JSExtractInterfaceHandler(BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> factory) {
        super(JSExtractInterfaceHandler.getRefactoringName(), JSExtractInterfaceHandler.getCannotRefactorReason());
        this.myDialogFactory = factory;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if (editor != null) {
            for (JSCustomExtractInterfaceHandler handler : JSCustomExtractInterfaceHandler.EP_NAME.getExtensionList()) {
                if (!handler.isAvailableOnEditorAndFile(editor, file2)) continue;
                handler.invoke(editor, file2);
                return;
            }
        }
        super.invoke(project, editor, file2, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractInterfaceHandler.getClass(element);
        if (aClass instanceof TypeScriptTypeAlias) {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, JavaScriptBundle.message((String)"interface.cannot.be.extracted.from.type.alias", (Object[])new Object[0]));
        } else if (aClass instanceof TypeScriptEnum) {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, JavaScriptBundle.message((String)"interface.cannot.be.extracted.from.enum", (Object[])new Object[0]));
        } else if (aClass != null) {
            JSElement selected = element instanceof JSElement ? (JSElement)element : null;
            RefactoringDialog dialog = this.myDialogFactory.apply((JSClass)aClass, (JSElement)selected);
            dialog.show();
        } else {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, RefactoringBundle.getCannotRefactorMessage((String)JSExtractInterfaceHandler.getCannotRefactorReason()));
        }
    }

    private static void showErrorHint(@NotNull Project project, @Nullable DataContext data, String message) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(3);
        }
        Editor editor = data != null ? (Editor)CommonDataKeys.EDITOR.getData(data) : null;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSExtractInterfaceHandler.getRefactoringName(), null);
    }

    private static String getCannotRefactorReason() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.class");
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.interface.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractInterfaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

