/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSFunctionInplaceIntroducer
extends AbstractInplaceIntroducer<JSNamedElement, PsiElement> {
    private final JSExtractFunctionHandler myHandler;
    private final DefaultJSExtractFunctionSettings mySettings;
    private final JSExtractFunctionHandler.ContextInfo myContextInfo;
    private final SmartPsiElementPointer<PsiElement> scopePointer;
    private PsiFile myFile;
    @Nullable
    private String myOriginalDocumentText;
    @Nullable
    private TextRange myOriginalSelection;

    JSFunctionInplaceIntroducer(@NotNull JSExtractFunctionHandler extractFunctionHandler, @NotNull DefaultJSExtractFunctionSettings settings, @NotNull JSExtractFunctionHandler.ContextInfo contextInfo, @NotNull JSExtractFunctionHandler.IntroductionScope introductionScope) {
        if (extractFunctionHandler == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (contextInfo == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(2);
        }
        if (introductionScope == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(3);
        }
        super(contextInfo.project, contextInfo.editor, null, null, (PsiElement[])JSElement.EMPTY_ARRAY, JSExtractFunctionHandler.getRefactoringName(), (FileType)JSChangeSignatureDialog.getFileTypeFromContext(contextInfo.getContextElement()));
        this.myWholePanel.add(this.getPreviewComponent());
        this.myHandler = extractFunctionHandler;
        this.mySettings = settings;
        this.myContextInfo = contextInfo;
        this.scopePointer = SmartPointerManager.getInstance((Project)contextInfo.project).createSmartPsiElementPointer(introductionScope.parent);
    }

    @Nullable
    public JSExtractFunctionHandler.IntroductionScope restoreUsedScope(@NotNull List<JSExtractFunctionHandler.IntroductionScope> scopes) {
        if (scopes == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(4);
        }
        PsiElement scopeParent = this.getScopeElement();
        return (JSExtractFunctionHandler.IntroductionScope)ContainerUtil.find(scopes, t -> t.parent == scopeParent);
    }

    @Nullable
    private PsiElement getScopeElement() {
        return this.scopePointer.getElement();
    }

    protected String getActionName() {
        return "ExtractMethod";
    }

    @Nullable
    protected JSNamedElement createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(5);
        }
        this.myOriginalDocumentText = this.myEditor.getDocument().getText();
        this.myOriginalSelection = new TextRange(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
        this.mySettings.setMethodName((String)ObjectUtils.coalesce((Object)this.mySettings.getMethodName(), (Object)ArrayUtil.getFirstElement((Object[])names)));
        JSExtractFunctionHandler.Result result2 = (JSExtractFunctionHandler.Result)WriteAction.compute(() -> this.myHandler.doRefactoring(this.myContextInfo, this.mySettings));
        if (result2 == null) {
            return null;
        }
        JSNamedElement declaration = result2.getDeclaration();
        JSReferenceExpression reference = result2.getReference();
        assert (declaration != null) : "expected declaration to be valid";
        assert (reference != null) : "expected reference to be valid";
        this.myLocalVariable = declaration;
        this.myFile = ((JSNamedElement)this.myLocalVariable).getContainingFile();
        this.myLocalMarker = this.createMarker((PsiElement)this.myLocalVariable);
        this.myExpr = reference.getReferenceNameElement();
        this.myExprMarker = this.createMarker(this.myExpr);
        return (JSNamedElement)this.myLocalVariable;
    }

    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
        JSReferenceExpression expression;
        PsiElement expr = this.getExpr();
        if (expr == null) {
            return;
        }
        if (expr instanceof JSReferenceExpression) {
            refs.add((PsiReference)expr);
        }
        if ((expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr.getParent(), JSReferenceExpression.class)) != null) {
            refs.add((PsiReference)expression);
        }
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable JSNamedElement variable) {
        String[] stringArray = JSExtractFunctionHandler.suggestNames(this.myContextInfo.myCodeFragment);
        if (stringArray == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    protected boolean ensureValid() {
        return true;
    }

    protected void performIntroduce() {
        JSNamedElement declaration = (JSNamedElement)this.getLocalVariable();
        String name = this.getInputName();
        if (declaration != null && !RenameUtil.isValidName((Project)this.myProject, (PsiElement)declaration, (String)name) || !JSNamesValidation.isIdentifierName(name)) {
            this.performOnInvalidName("Inserted identifier is not valid");
        }
        if (declaration == null) {
            return;
        }
        PsiElement conflict = JSExtractFunctionHandler.findConflictingElementInScope(name, this.getScopeElement(), this.mySettings.makeStatic(), (PsiElement)declaration);
        if (conflict != null) {
            this.performOnInvalidName(name + " already exists in this scope");
        }
    }

    protected void performOnInvalidName(@NotNull String message) {
        if (message == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new BaseRefactoringProcessor.ConflictsInTestsException(Collections.singletonList(message));
        }
        Runnable onContinue = () -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            JSFunctionInplaceIntroducer forRestart = this.createIntroducerForRestart();
            if (forRestart == null) {
                return;
            }
            forRestart.startInplaceIntroduceTemplate();
        }, this.getCommandName(), (Object)this.getCommandName());
        Runnable onCancel = () -> DocumentUtil.writeInRunUndoTransparentAction(this::revertStateOnFailure);
        JBPopupFactory.getInstance().createConfirmation(message, "Continue editing", "Cancel", onContinue, onCancel, 0).showInBestPositionFor(this.myEditor);
    }

    @Nullable
    private JSFunctionInplaceIntroducer createIntroducerForRestart() {
        JSExtractFunctionHandler.ContextInfo contextInfo = this.myHandler.createContextInfo(this.myEditor, this.myFile);
        if (contextInfo == null) {
            return null;
        }
        JSExtractFunctionHandler.IntroductionScope restoredScope = this.restoreUsedScope(contextInfo.introductionScopes);
        if (restoredScope == null) {
            return null;
        }
        this.mySettings.introductionScope = restoredScope;
        return new JSFunctionInplaceIntroducer(this.myHandler, this.mySettings, contextInfo, restoredScope);
    }

    protected void moveOffsetAfter(boolean success) {
        JSCallExpression moveTarget;
        RangeMarker exprMarker = this.getExprMarker();
        if (exprMarker == null || !exprMarker.isValid()) {
            return;
        }
        if (!success) {
            this.myEditor.getCaretModel().moveToOffset(this.restoreCaretOffset(exprMarker.getEndOffset()));
            return;
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myFile.findElementAt(exprMarker.getEndOffset()), JSCallExpression.class);
        if (callExpression == null) {
            return;
        }
        Object object = moveTarget = this.myContextInfo.isExpression ? callExpression : (JSElement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSStatement.class);
        if (moveTarget == null) {
            return;
        }
        this.myEditor.getCaretModel().moveToOffset(moveTarget.getTextRange().getEndOffset());
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public boolean isReplaceAllOccurrences() {
        return false;
    }

    protected int getCaretOffset() {
        PsiElement expr = this.myExpr;
        if (expr != null && expr.isValid()) {
            return expr.getTextRange().getStartOffset();
        }
        return super.getCaretOffset();
    }

    protected void updateTitle(@Nullable JSNamedElement variable, @Nullable String value) {
        String preview;
        if (variable instanceof JSVariable && (preview = JSFunctionInplaceIntroducer.getPreviewForVarStatement((JSVariable)variable, value)) != null) {
            this.setPreviewText(preview);
            this.revalidate();
            return;
        }
        super.updateTitle((PsiNameIdentifierOwner)variable, value);
    }

    protected void updateTitle(@Nullable JSNamedElement variable) {
        if (variable instanceof JSVariable) {
            this.updateTitle(variable, variable.getName());
            return;
        }
        super.updateTitle((PsiNameIdentifierOwner)variable);
    }

    public void finish(boolean success) {
        if (!this.myFinished) {
            super.finish(success);
        }
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    protected void saveSettings(@NotNull JSNamedElement variable) {
        if (variable == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myFile;
    }

    @Nullable
    protected JSNamedElement getVariable() {
        if (this.myFile == null || this.myLocalVariable == null) {
            return null;
        }
        return JSBaseInplaceIntroducer.restoreDeclarationFromMarker(this.myFile, this.myLocalMarker, ((JSNamedElement)this.myLocalVariable).getClass());
    }

    protected RangeMarker createMarker(PsiElement element) {
        RangeMarker marker = super.createMarker(element);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        return marker;
    }

    protected void performCleanup() {
        JSNamedElement variable = this.getVariable();
        if (variable != null) {
            this.revertStateOnFailure();
        }
    }

    protected void restoreState(@NotNull JSNamedElement psiField) {
        if (psiField == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(9);
        }
    }

    private void revertStateOnFailure() {
        WriteAction.run(() -> {
            if (this.myOriginalDocumentText != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document document2 = this.myEditor.getDocument();
                document2.replaceString(0, document2.getTextLength(), (CharSequence)this.myOriginalDocumentText);
                documentManager.commitDocument(document2);
            }
            if (this.myOriginalSelection != null) {
                this.myEditor.getCaretModel().moveToOffset(this.myOriginalSelection.getEndOffset());
                this.myEditor.getSelectionModel().setSelection(this.myOriginalSelection.getStartOffset(), this.myOriginalSelection.getEndOffset());
            }
            this.myExpr = null;
            this.myExprMarker = null;
        });
    }

    public JSElement restoreExpression(@NotNull PsiFile containingFile, @NotNull JSNamedElement variable, @NotNull RangeMarker marker, @Nullable String exprText) {
        if (containingFile == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(10);
        }
        if (variable == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(11);
        }
        if (marker == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    private static String getPreviewForVarStatement(@NotNull JSVariable variable, @Nullable String newName) {
        if (variable == null) {
            JSFunctionInplaceIntroducer.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            return null;
        }
        JSVarStatement varStatement = variable.getStatement();
        if (varStatement == null) {
            return null;
        }
        PsiElement identifier = variable.getNameIdentifier();
        if (identifier != null) {
            int identifierOffset = identifier.getTextRange().getStartOffset() - varStatement.getTextRange().getStartOffset();
            return varStatement.getText().substring(0, identifierOffset) + newName + varStatement.getText().substring(identifierOffset + identifier.getTextLength());
        }
        if (variable.getName() != null) {
            return varStatement.getText().replaceFirst(variable.getName(), newName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractFunctionHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSFunctionInplaceIntroducer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSFunctionInplaceIntroducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreUsedScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performOnInvalidName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewForVarStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

