/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralBasedPropertyElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveReadonlyArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSTypeWithIncompleteSubstitution,
JSDistributedType,
JSEvaluableType,
JSTypeWithGenericParameters {
    private static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> CONVERT_TO_INDEX_ACCESS_KEY = Key.create((String)"convert.as.index.key");
    private static final String INFER_GENERIC_PREFIX = "_infer_";
    private final boolean myReadonly;
    private final boolean myMinusReadonly;
    private final boolean myOptional;
    private final boolean myMinusOptional;
    @NotNull
    private final JSTypeSubstitutor.JSTypeGenericId myParameterId;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;
    private final AtomicNotNullLazyValue<Boolean> myHasForeignParameters;
    private static final int MAX_SOURCE_DEPTH = 10;

    @ApiStatus.Internal
    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSType parameterType, @NotNull JSType resultType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myHasForeignParameters = AtomicNotNullLazyValue.createValue(() -> JSTypeUtils.hasForeignGenericParameter(this.getParameterType(), ContainerUtil.newHashSet((Object[])new JSTypeSubstitutor.JSTypeGenericId[]{this.getParameterId()})));
        this.myReadonly = isReadonly;
        this.myMinusReadonly = isMinusReadonly;
        this.myOptional = isOptional;
        this.myMinusOptional = isMinusOptional;
        this.myParameterId = parameterId;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
        }
        builder.append("{");
        boolean readonly = this.isReadonly();
        boolean minusReadonly = this.isMinusReadonly();
        if (readonly || minusReadonly) {
            builder.append(minusReadonly ? "-readonly " : "readonly ");
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name);
        builder.append(" in ");
        this.getParameterType().buildTypeText(format, builder);
        builder.append("]");
        boolean optional = this.isOptional();
        boolean minusOptional = this.isMinusOptional();
        if (optional || minusOptional) {
            builder.append(optional ? "?" : "-?");
        }
        builder.append(this.getTypeSeparator());
        this.getResultType().buildTypeText(format, builder);
        builder.append("}");
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getParameterType().resolvedHashCode(), this.getResultType().resolvedHashCode());
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        JSType newResultType = JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform);
        if (newParameterType == this.getParameterType() && newResultType == this.getResultType()) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
            }
            return typeScriptMappedJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createMappedType(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, newParameterType, newResultType);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
        }
        return new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myMinusReadonly, this.myMinusOptional, this.myParameterId, this.myParameterType, this.myResultType);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
        }
        if ((substitute = this.substitute()) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        JSType paramType = this.getParameterType();
        if (JSTypeCastUtil.isTypeOperatorLikeType(paramType) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(elementType, this, processingContext, false)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    public Set<JSTypeSubstitutor.JSTypeGenericId> getGenericIds() {
        return Collections.singleton(this.myParameterId);
    }

    public static boolean isDirectAssignableForMappedTypeWithTypeOperator(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, boolean isDirectComparing) {
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        JSType paramType = mappedType.getParameterType();
        TypeScriptMappedTypeGenericParameterImpl nameAsType = new TypeScriptMappedTypeGenericParameterImpl(mappedType.myParameterId, mappedType.getSource());
        JSType typeForGuard = TypeScriptMappedJSTypeImpl.getSubstitutionTypeInIndexAccess(operand);
        Boolean referencedType = TypeScriptMappedJSTypeImpl.processHomomorphicType(operand, mappedType, processingContext, paramType);
        if (referencedType != null) {
            return referencedType;
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(typeForGuard.getResolvedTypeId(), nameAsType.getResolvedTypeId(), CONVERT_TO_INDEX_ACCESS_KEY, nameAsType, processingContext, (type, ctx) -> {
            JSType result2;
            JSType indexedType = JSCompositeTypeFactory.createIndexedAccessType(operand, type, mappedType.getSource());
            if (!TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(indexedType, result2 = mappedType.getResultType(), ctx, isDirectComparing)) {
                return false;
            }
            if (JSGenericTypesEvaluator.isGenericProcessingInProgress(ctx) && JSTypeUtils.hasForeignGenericParameter(paramType)) {
                JSType typeOperator = JSCompositeTypeFactory.createKeyOfType(operand, operand.getSource());
                TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(typeOperator, paramType, ctx, isDirectComparing);
            }
            return true;
        });
    }

    @Nullable
    private static Boolean processHomomorphicType(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, JSType paramType) {
        JSType parameterType;
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (!(paramType instanceof JSKeyofType)) {
            return null;
        }
        JSType referencedType = ((JSKeyofType)paramType).getReferencedType();
        JSType resultType = mappedType.getResultType();
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && (parameterType = ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType()) instanceof JSGenericParameterType && mappedType.getGenericIds().contains(((JSGenericParameterType)parameterType).getGenericId()) && referencedType.isEquivalentTo(((TypeScriptIndexedAccessJSTypeImpl)resultType).getOwner(), processingContext)) {
            return referencedType instanceof JSGenericParameterType && operand.isJavaScript() || referencedType.isDirectlyAssignableType(operand, processingContext);
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && referencedType instanceof JSGenericParameterType) {
            HashMap<String, JSRecordType.MemberSource> sourceMap = new HashMap<String, JSRecordType.MemberSource>();
            Collection allProperties = operand.asRecordType().getProperties();
            HashSet<String> optionalProps = new HashSet<String>();
            HashSet<String> readonlyProps = new HashSet<String>();
            for (JSRecordType.PropertySignature property : allProperties) {
                JSGenericParameterImpl temp_Generic = new JSGenericParameterImpl((JSTypeSubstitutor.JSTypeGenericId)new JSTypeSubstitutor.StringGenericId(INFER_GENERIC_PREFIX + property.getMemberName()), resultType.getSource(), true, null);
                JSType type = resultType.transformTypeHierarchy(t -> t instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isIndexedByOwnKey((TypeScriptIndexedAccessJSTypeImpl)t, mappedType.getGenericIds()) ? temp_Generic : t);
                JSType propType = property.getJSType();
                if (propType == null) continue;
                RecursionManager.doPreventingRecursion((Object)"TypeScriptMappedJSTypeImpl.processHomomorphicType", (boolean)false, () -> {
                    JSRecursiveTypeUtil.computeWithRecursiveTypes(type.getResolvedTypeId(), propType.getResolvedTypeId(), CONVERT_TO_INDEX_ACCESS_KEY, propType, processingContext, (t, ctx) -> type.isDirectlyAssignableType(t, ctx));
                    return null;
                });
                sourceMap.put(property.getMemberName(), JSRecordMemberSourceFactory.createSource(property.getMemberSource().getAllSourceElements(), JSRecordType.MemberSourceKind.MappedNoStatus));
                if (property.isOptional()) {
                    optionalProps.add(property.getMemberName());
                }
                if (!property.isConst()) continue;
                readonlyProps.add(property.getMemberName());
            }
            JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
            ArrayList<JSRecordTypeImpl.PropertySignatureImpl> newTypeProps = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
            int inferredCount = 0;
            for (JSTypeSubstitutor.JSTypeGenericId id : new HashSet(mappings.getMapping().keySet())) {
                String name = id.getName();
                if (!name.startsWith(INFER_GENERIC_PREFIX)) continue;
                Collection types2 = mappings.getMapping().remove((Object)id);
                String propName = name.substring(INFER_GENERIC_PREFIX.length());
                if (types2 == null || !sourceMap.containsKey(propName)) continue;
                JSType type = JSCompositeTypeFactory.createUnionType(referencedType.getSource(), types2);
                newTypeProps.add(new JSRecordTypeImpl.PropertySignatureImpl(propName, type, optionalProps.contains(propName), readonlyProps.contains(propName), (JSRecordType.MemberSource)sourceMap.get(propName)));
                ++inferredCount;
            }
            if (inferredCount == allProperties.size()) {
                mappings.getMapping().put((Object)((JSGenericParameterType)referencedType).getGenericId(), (Collection)new SmartList((Object)new JSRecordTypeImpl(referencedType.getSource(), newTypeProps)));
            }
        }
        return null;
    }

    private static boolean isIndexedByOwnKey(TypeScriptIndexedAccessJSTypeImpl t, Set<JSTypeSubstitutor.JSTypeGenericId> ids) {
        JSType type = t.getParameterType();
        return type instanceof JSGenericParameterType && ids.contains(((JSGenericParameterType)type).getGenericId());
    }

    private static boolean isAssignableDirectOrInverseType(@NotNull JSType thisType, @NotNull JSType rType, @NotNull ProcessingContext context, boolean direct) {
        if (thisType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(18);
        }
        if (rType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(20);
        }
        return direct ? thisType.isDirectlyAssignableType(rType, context) : rType.isDirectlyAssignableType(thisType, context);
    }

    @NotNull
    public static JSType getSubstitutionTypeInIndexAccess(@NotNull JSType elementType) {
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(21);
        }
        while (elementType instanceof TypeScriptIndexedAccessJSTypeImpl) {
            elementType = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
        }
        JSType jSType = elementType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            return this;
        }
        return this.substituteInternal(context);
    }

    @NotNull
    public JSType substituteCompletely() {
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            JSType jSType = this.getLocalCachedType(() -> this.substituteInternal(new JSTypeSubstitutionContextImpl()), SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    public boolean hasForeignGenericParameters() {
        return this.myHasForeignParameters.getValue() == Boolean.TRUE;
    }

    @Nullable
    private JSType substituteInternal(@NotNull JSTypeSubstitutionContext context) {
        JSType distributeType;
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(26);
        }
        if ((distributeType = this.distributeType()) != this) {
            return distributeType;
        }
        JSType parameterType = this.getParameterType();
        JSType originalResultType = this.getResultType();
        JSType type = context.substituteNested(parameterType);
        if (type == null) {
            return null;
        }
        Collection<String> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        if (strings.isEmpty()) {
            JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
            substitutor.put(this.getParameterId(), (JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE));
            JSType resultType = JSTypeUtils.applyGenericArguments(originalResultType, substitutor);
            if (this.myOptional) {
                resultType = TypeScriptTypeGuard.wrapWithUndefined(resultType, this.getSource());
            }
            if (JSTypeUtils.isAnyType(type) || type instanceof JSGenericParameterType) {
                return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false)));
            }
            if (type instanceof JSStringType || type instanceof JSNumberType) {
                return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl(type, resultType, this.getSourceElement(), false)));
            }
            if (type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(t -> t instanceof JSStringType || t instanceof JSNumberType)) {
                return new JSRecordTypeImpl(this.getSource(), Arrays.asList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false), new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false)));
            }
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                return new JSRecordTypeImpl(this.getSource(), Collections.emptyList());
            }
            return JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
        }
        JSType resultType = context.substituteNested(originalResultType);
        if (resultType == null) {
            return null;
        }
        boolean hasOptionalKeyword = this.isOptional();
        boolean hasMinusOptionalKeyword = this.isMinusOptional();
        SmartList result2 = new SmartList();
        JSRecordType originalType = TypeScriptMappedJSTypeImpl.getOriginalType(parameterType);
        MultiMap<String, PsiElement> sources = TypeScriptMappedJSTypeImpl.buildLiteralSourceElementsMap(parameterType);
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(this.myParameterId, ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)resultType;
            JSType owner = accessJSType.getOwner();
            if (JSTypeUtils.isAnyType(owner)) {
                JSAnyType pureAny = JSAnyType.get(owner.getSource());
                for (String string : strings) {
                    result2.add(new JSRecordTypeImpl.PropertySignatureImpl(string, (JSType)pureAny, hasOptionalKeyword, this.isReadonly(), type.getSourceElement()));
                }
            } else {
                JSRecordType ownerRecordType = owner.asRecordType();
                HashSet<String> propertyNames = new HashSet<String>(strings);
                for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                    JSRecordType.PropertySignature propertySignature;
                    String memberName;
                    if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                    JSRecordType.PropertySignature originalSignature = originalType != null ? originalType.findPropertySignature(memberName) : null;
                    JSRecordType.MemberSource source = this.computeCommonMemberSource(sources, originalType, propertySignature, memberName);
                    if (originalSignature == null) {
                        PsiElement element = source.getSingleElement();
                        originalSignature = element instanceof JSRecordType.TypeMember ? (JSRecordType.TypeMember)element : null;
                    }
                    boolean propIsOptional = TypeScriptMappedJSTypeImpl.canPropagateOptionalStatus(parameterType) && TypeScriptMappedJSTypeImpl.calcOptionality((JSRecordType.TypeMember)originalSignature, hasOptionalKeyword, hasMinusOptionalKeyword);
                    result2.add(new JSRecordTypeImpl.PropertySignatureImpl(memberName, propertySignature.getJSType(), propIsOptional, this.isReadonly(), source));
                }
            }
        } else {
            List<JSRecordType> keyBases = TypeScriptMappedJSTypeImpl.getKeyBases(parameterType);
            for (String string : strings) {
                final JSStringLiteralTypeImpl toReplace = !keyBases.isEmpty() ? new JSTypeKeyTypeImpl(string, keyBases, originalResultType.getSource()) : new JSStringLiteralTypeImpl(string, false, originalResultType.getSource());
                JSType propertyType = originalResultType.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSCacheableTypeTransformerResolvedIdBase(){

                    @NotNull
                    public JSType fun(JSType el) {
                        JSType jSType = TypeScriptMappedJSTypeImpl.isParameter(TypeScriptMappedJSTypeImpl.this.myParameterId, el) ? toReplace : el;
                        if (jSType == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return jSType;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$1", "fun"));
                    }
                });
                JSRecordType.MemberSource source = this.computeCommonMemberSource(sources, originalType, null, string);
                PsiElement sourceSingleElement = source.getSingleElement();
                JSRecordType.TypeMember originalSourceProperty = sourceSingleElement instanceof JSRecordType.TypeMember ? (JSRecordType.TypeMember)sourceSingleElement : null;
                boolean propIsOptional = TypeScriptMappedJSTypeImpl.canPropagateOptionalStatus(parameterType) && TypeScriptMappedJSTypeImpl.calcOptionality(originalSourceProperty, hasOptionalKeyword, hasMinusOptionalKeyword);
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(string, propertyType, propIsOptional, this.isReadonly(), source));
            }
        }
        return new JSRecordTypeImpl(originalType != null ? originalType.getSource() : this.getSource(), (List<? extends JSRecordType.TypeMember>)result2);
    }

    private static boolean canPropagateOptionalStatus(@Nullable JSType parameterType) {
        if (!(parameterType instanceof JSUnionOrIntersectionType)) {
            return true;
        }
        return parameterType.getSourceElement() instanceof TypeScriptTypeOperator;
    }

    @NotNull
    private static List<JSRecordType> getKeyBases(@Nullable JSType parameterType) {
        if (parameterType instanceof JSKeyofType) {
            List<JSRecordType> list2 = Collections.singletonList(((JSKeyofType)parameterType).getReferencedType().asRecordType());
            if (list2 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(27);
            }
            return list2;
        }
        if (parameterType instanceof JSUnionOrIntersectionType) {
            List<JSRecordType> list3 = ((JSUnionOrIntersectionType)parameterType).getTypes().stream().filter(t -> t instanceof JSKeyofType).map(t -> ((JSKeyofType)t).getReferencedType().asRecordType()).collect(Collectors.toList());
            if (list3 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(28);
            }
            return list3;
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(29);
        }
        return list4;
    }

    private static boolean calcOptionality(@Nullable JSRecordType.TypeMember candidate, boolean hasOptionalKeyword, boolean hasMinusOptionalKeyword) {
        boolean propIsOptional = hasOptionalKeyword;
        if (candidate instanceof JSRecordType.PropertySignature) {
            propIsOptional |= !hasMinusOptionalKeyword && ((JSRecordType.PropertySignature)candidate).isOptional();
        }
        return propIsOptional;
    }

    @NotNull
    private static List<JSType> collectReferencedTypes(@Nullable JSType type, boolean expandTypeof) {
        JSResolvedTypeInfo info;
        JSType alias;
        if (type instanceof JSKeyofType) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JSKeyofType)type).getReferencedType());
            if (list2 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(30);
            }
            return list2;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            ArrayList<JSType> types2 = new ArrayList<JSType>();
            for (JSType part : ((JSUnionOrIntersectionType)type).getTypes()) {
                types2.addAll(TypeScriptMappedJSTypeImpl.collectReferencedTypes(part, false));
            }
            ArrayList<JSType> arrayList = types2;
            if (arrayList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        if (expandTypeof && type instanceof JSResolvableType && (alias = (info = ((JSResolvableType)type).resolveType()).getAliasedType()) != null) {
            return TypeScriptMappedJSTypeImpl.collectReferencedTypes(alias, false);
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(32);
        }
        return list3;
    }

    @Nullable
    private static JSRecordType getOriginalType(@Nullable JSType type) {
        List<JSType> types2 = TypeScriptMappedJSTypeImpl.collectReferencedTypes(type, true);
        if (types2.size() == 0) {
            return null;
        }
        if (types2.size() == 1) {
            return types2.get(0).asRecordType();
        }
        assert (type != null);
        return JSCompositeTypeFactory.createUnionType(type.getSource(), types2).asRecordType();
    }

    @NotNull
    private JSRecordType.MemberSource computeCommonMemberSource(@NotNull MultiMap<String, PsiElement> extraSourceElements, @Nullable JSRecordType originalType, @Nullable JSRecordType.PropertySignature propertySignature, @NotNull String memberName) {
        JSRecordType.MemberSource originalSignatureSource;
        JSRecordType.PropertySignature originalSignature;
        JSRecordType.MemberSource source;
        if (extraSourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(33);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(34);
        }
        JSRecordType.MemberSource memberSource = source = propertySignature == null ? JSRecordMemberSourceFactory.createEmptySource() : propertySignature.getMemberSource().copyWithKind(this.getMemberSourceKind());
        if (originalType != null && (originalSignature = originalType.findPropertySignature(memberName)) != null && !(originalSignatureSource = originalSignature.getMemberSource()).isEmpty()) {
            source = source.isEmpty() ? originalSignatureSource.copyWithKind(this.getMemberSourceKind()) : JSRecordMemberSourceFactory.createSource(ContainerUtil.concat((List)source.getAllSourceElements(), (List)originalSignatureSource.getAllSourceElements()), this.getMemberSourceKind());
        }
        HashSet sourceElements = new HashSet();
        if (!source.isEmpty()) {
            sourceElements.addAll(source.getAllSourceElements());
        }
        sourceElements.addAll(extraSourceElements.get((Object)memberName));
        JSRecordType.MemberSource memberSource2 = JSRecordMemberSourceFactory.createSource(new ArrayList<PsiElement>(sourceElements), this.getMemberSourceKind());
        if (memberSource2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(35);
        }
        return memberSource2;
    }

    @NotNull
    private JSRecordType.MemberSourceKind getMemberSourceKind() {
        JSRecordType.MemberSourceKind memberSourceKind = JSRecordType.MemberSourceKind.getMappedKind((boolean)this.isOptional(), (boolean)this.isMinusOptional(), (boolean)this.isReadonly(), (boolean)this.isMinusReadonly());
        if (memberSourceKind == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(36);
        }
        return memberSourceKind;
    }

    @NotNull
    private static MultiMap<String, PsiElement> buildLiteralSourceElementsMap(@Nullable JSType type) {
        if (type == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(37);
            }
            return multiMap;
        }
        MultiMap set = MultiMap.createSet();
        TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(type, (MultiMap<String, PsiElement>)set, 0);
        MultiMap multiMap = set;
        if (multiMap == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(38);
        }
        return multiMap;
    }

    private static void fillExtraLiteralSourceElements(@Nullable JSType type, @NotNull MultiMap<String, PsiElement> sourceElements, int depth) {
        PsiElement owner;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(39);
        }
        if (depth > 10) {
            return;
        }
        if (type instanceof JSTypeImpl) {
            TypeScriptEnumField field;
            JSResolvedTypeInfo typeInfo = ((JSTypeImpl)type).resolveType();
            if (typeInfo.getDeclarationOfType(TypeScriptTypeAlias.class) != null) {
                TypeScriptMappedJSTypeImpl.addSourceElementsFromAliasedType(sourceElements, typeInfo.getAliasedType());
                return;
            }
            if (typeInfo.isEnumWithLiteralValues()) {
                TypeScriptEnum tsEnum = typeInfo.getDeclarationOfType(TypeScriptEnum.class);
                if (tsEnum != null) {
                    for (JSField field2 : tsEnum.getFields()) {
                        TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, (TypeScriptEnumField)field2);
                    }
                }
            } else if (typeInfo.isEnumLiteral() && (field = typeInfo.getDeclarationOfType(TypeScriptEnumField.class)) != null) {
                TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, field);
            }
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSUnionOrIntersectionType) {
            for (JSType part : JSCompositeTypeBaseImpl.flattenTypes(((JSUnionOrIntersectionType)type).getTypes().stream(), type.getClass())) {
                TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(part, sourceElements, depth + 1);
            }
        }
        if (type instanceof JSTypeKeyTypeImpl) {
            String literal = ((JSTypeKeyTypeImpl)type).getLiteral();
            sourceElements.putValues((Object)literal, ((JSTypeKeyTypeImpl)type).getKeySourceElements());
        }
        if (type instanceof JSTaggedLiteralKeyTypeImpl && (owner = type.getSource().getSourceElement()) instanceof TypeScriptStringLiteralType) {
            String literal = ((JSTaggedLiteralKeyTypeImpl)type).getLiteral();
            sourceElements.putValue((Object)literal, (Object)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
        }
    }

    private static void putIfStringLiteral(@NotNull MultiMap<String, PsiElement> sourceElements, @NotNull TypeScriptEnumField field) {
        String stringValue;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(40);
        }
        if (field == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(41);
        }
        if (!StringUtil.isEmpty((String)(stringValue = field.getConstantValue().getAsString()))) {
            sourceElements.putValue((Object)stringValue, (Object)new TypeScriptLiteralBasedPropertyElementImpl(stringValue, (PsiElement)field));
        }
    }

    private static void addSourceElementsFromAliasedType(MultiMap<String, PsiElement> sourceElements, JSType typedef) {
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSStringLiteralTypeImpl) {
                PsiElement owner = t.getSource().getSourceElement();
                String literal = ((JSStringLiteralTypeImpl)t).getLiteral();
                if (owner instanceof TypeScriptLiteralType) {
                    sourceElements.putValue((Object)literal, (Object)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
                } else if ((owner instanceof JSField || owner instanceof JSProperty) && t instanceof JSTypeKeyTypeImpl) {
                    sourceElements.putValue((Object)literal, (Object)owner);
                }
            }
            return true;
        }), typedef, false, true, true);
    }

    private static boolean isParameter(@NotNull JSTypeSubstitutor.JSTypeGenericId id, @NotNull JSType el) {
        if (id == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(42);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(43);
        }
        return el instanceof TypeScriptMappedTypeGenericParameterImpl && id.equals((Object)((TypeScriptMappedTypeGenericParameterImpl)el).getGenericId());
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean isMinusReadonly() {
        return this.myMinusReadonly;
    }

    public boolean isMinusOptional() {
        return this.myMinusOptional;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(44);
        }
        TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
        return this.isReadonly() == mappedType.isReadonly() && this.isMinusReadonly() == mappedType.isMinusReadonly() && this.isOptional() == mappedType.isOptional() && this.isMinusOptional() == mappedType.isMinusOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve);
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @NotNull
    public String getParameterName() {
        String string = this.myParameterId.getName();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public JSTypeSubstitutor.JSTypeGenericId getParameterId() {
        JSTypeSubstitutor.JSTypeGenericId jSTypeGenericId = this.myParameterId;
        if (jSTypeGenericId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(48);
        }
        return jSTypeGenericId;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(49);
        }
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    @NotNull
    public JSType distributeType() {
        JSType parameterType = this.getParameterType();
        if (parameterType instanceof JSKeyofType) {
            return this.distributeByKey(((JSKeyofType)parameterType).getReferencedType());
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(50);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @NotNull
    private JSType distributeByKey(JSType keyType) {
        if (keyType instanceof JSPrimitiveType && !(keyType instanceof JSPrimitiveLiteralType)) {
            JSType jSType = keyType;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(51);
            }
            return jSType;
        }
        if (keyType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)keyType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types2.size());
            JSType resultType = this.getResultType();
            for (JSType type : types2) {
                newTypes.add(JSCompositeTypeFactory.createMappedType(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, JSCompositeTypeFactory.createKeyOfType(type, this.getSource()), TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, type, resultType, true)));
            }
            JSType jSType = JSCompositeTypeFactory.createUnionType(this.getSource(), newTypes);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(52);
            }
            return jSType;
        }
        JSGenericTypeImpl genericArrayType = TypeScriptMappedJSTypeImpl.getGenericArrayType(keyType);
        if (genericArrayType != null) {
            JSType arrayBase = genericArrayType.getType();
            JSType S = genericArrayType.getArguments().get(0);
            JSType X = this.getResultType();
            if (this.isReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "Array")) {
                arrayBase = new JSPrimitiveReadonlyArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            } else if (this.isMinusReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "ReadonlyArray")) {
                arrayBase = new JSPrimitiveArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            }
            return new JSGenericTypeImpl(this.getSource(), arrayBase, TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, S, X, false));
        }
        if (keyType instanceof JSTupleType) {
            List types3 = ((JSTupleType)keyType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types3.size());
            JSType X = this.getResultType();
            for (JSType type : types3) {
                newTypes.add(TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, type, X, false));
            }
            JSType jSType = JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, keyType.isSourceStrict(), ((JSTupleType)keyType).getOptionalStart(), !this.isMinusReadonly() && (this.isReadonly() || ((JSTupleType)keyType).isReadonly()));
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(53);
            }
            return jSType;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(54);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private static boolean isArrayKind(JSType type, String arrayClass) {
        return type instanceof JSNamedType && arrayClass.equals(((JSNamedType)type).getQualifiedName().getQualifiedName());
    }

    private static JSType transformForIndexer(JSType keyType, JSTypeSubstitutor.JSTypeGenericId parameterId, JSType type, JSType x, boolean preserveIndexer) {
        return x.transformTypeHierarchy(t -> {
            if (t instanceof TypeScriptIndexedAccessJSTypeImpl) {
                JSType owner = ((TypeScriptIndexedAccessJSTypeImpl)t).getOwner();
                JSType parameterType = ((TypeScriptIndexedAccessJSTypeImpl)t).getParameterType();
                if (owner.isEquivalentTo(keyType, null, true) && TypeScriptMappedJSTypeImpl.isParameter(parameterId, parameterType)) {
                    return preserveIndexer ? JSCompositeTypeFactory.createIndexedAccessType(type, parameterType, t.getSource()).substitute() : type;
                }
            }
            return t;
        });
    }

    @Nullable
    private static JSGenericTypeImpl getGenericArrayType(@Nullable JSType keyType) {
        String typeText;
        JSType type;
        JSGenericTypeImpl genericArrayType = null;
        if (keyType instanceof JSArrayType) {
            genericArrayType = ((JSArrayType)keyType).asGenericType();
        } else if (keyType instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)keyType).getType()) instanceof JSNamedType && ("Array".equals(typeText = type.getTypeText(JSType.TypeTextFormat.SIMPLE)) || "ReadonlyArray".equals(typeText))) {
            genericArrayType = (JSGenericTypeImpl)keyType;
        }
        return genericArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSourceElements";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElements";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyBases";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedTypes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonMemberSource";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSourceKind";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLiteralSourceElementsMap";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterId";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableForMappedTypeWithTypeOperator";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processHomomorphicType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableDirectOrInverseType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonMemberSource";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fillExtraLiteralSourceElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "putIfStringLiteral";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

