/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl
implements JSTupleType {
    private final boolean myStrict;
    private final boolean myReadonly;
    private final int myFirstOptional;

    @Deprecated
    public JSTupleTypeImpl(JSTypeSource source, Collection<? extends JSType> _types, boolean strict, int firstOptional) {
        this(source, _types, strict, firstOptional, false);
    }

    @ApiStatus.Internal
    public JSTupleTypeImpl(JSTypeSource source, Collection<? extends JSType> _types, boolean strict, int firstOptional, boolean isReadonly) {
        super(source, _types);
        this.myStrict = strict;
        this.myFirstOptional = firstOptional;
        this.myReadonly = isReadonly;
    }

    protected JSTupleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
        this.myStrict = JSTypeSerializer.readBoolean(inputStream);
        this.myReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myFirstOptional = JSTypeSerializer.readInt(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(2);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myStrict, outputStream);
        JSTypeSerializer.writeBoolean(this.myReadonly, outputStream);
        JSTypeSerializer.writeInt(this.myFirstOptional, outputStream);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        return ",";
    }

    public int getOptionalStart() {
        return this.myFirstOptional;
    }

    public int getMinLength() {
        List<JSType> types2 = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types2);
        if (this.myFirstOptional != -1) {
            return this.myFirstOptional;
        }
        return lastItem instanceof JSSpreadType ? types2.size() - 1 : types2.size();
    }

    public int getMaxLength() {
        List<JSType> types2 = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types2);
        return lastItem instanceof JSSpreadType ? Integer.MAX_VALUE : types2.size();
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean allowWidening() {
        return !this.myStrict;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        if (this.isTypeScript() && this.isReadonly()) {
            builder.append("readonly ");
        }
        builder.append("[");
        super.buildTypeTextImpl(format, builder);
        builder.append("]");
    }

    @Override
    protected void buildNestedTypePresentation(@NotNull JSType t, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (t == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(7);
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            builder.append("*");
            return;
        }
        super.buildNestedTypePresentation(t, format, builder);
    }

    @Override
    @NotNull
    protected String getTypeSeparatorForTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        return ", ";
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(10);
        }
        JSType jSType = JSCompositeTypeFactory.createTupleType(newSource, transformedTypes, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(13);
        }
        if (this.myStrict && elementType instanceof JSTupleType) {
            if (!this.myReadonly && ((JSTupleType)elementType).isReadonly()) {
                return false;
            }
            List elementTypes = ((JSTupleType)elementType).getTypes();
            List<JSType> currentTypes = this.getTypes();
            int min = Math.min(elementTypes.size(), currentTypes.size());
            for (int i = 0; i < min; ++i) {
                JSType nestedElement;
                JSType nestedCurrent = currentTypes.get(i);
                if (nestedCurrent instanceof JSSpreadType) {
                    nestedCurrent = ((JSSpreadType)nestedCurrent).getComponentType();
                }
                if ((nestedElement = (JSType)elementTypes.get(i)) instanceof JSSpreadType) {
                    nestedElement = ((JSSpreadType)nestedElement).getComponentType();
                }
                if (nestedCurrent.isDirectlyAssignableType(nestedElement, processingContext)) continue;
                return false;
            }
            if (currentTypes.size() == elementTypes.size()) {
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                JSType lastOther = (JSType)ContainerUtil.getLastItem((List)elementTypes);
                if (this.isTypeScript() && lastOther instanceof JSSpreadType && lastCurrent != null && !(lastCurrent instanceof JSSpreadType)) {
                    return false;
                }
            }
            if (currentTypes.size() < elementTypes.size()) {
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                if (!(lastCurrent instanceof JSSpreadType)) {
                    return !this.isTypeScript();
                }
                if (currentTypes.size() - elementTypes.size() + 1 == 0 && ContainerUtil.getLastItem((List)elementTypes) instanceof JSSpreadType) {
                    return true;
                }
                return !this.isTypeScript() || JSTupleTypeImpl.checkWithSpreads(processingContext, elementTypes, min, ((JSSpreadType)lastCurrent).getComponentType(), false);
            }
            if (elementTypes.size() < currentTypes.size()) {
                JSType lastItem = (JSType)ContainerUtil.getLastItem((List)elementTypes);
                if (!(lastItem instanceof JSSpreadType)) {
                    return this.myFirstOptional != -1 && min >= this.myFirstOptional || elementTypes.size() - currentTypes.size() + 1 == 0 && ContainerUtil.getLastItem(currentTypes) instanceof JSSpreadType;
                }
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                if (this.isTypeScript() && lastCurrent instanceof JSSpreadType) {
                    return false;
                }
                JSType componentType = ((JSSpreadType)lastItem).getComponentType();
                return JSTupleTypeImpl.checkWithSpreads(processingContext, currentTypes, min, componentType, true);
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean checkWithSpreads(@NotNull ProcessingContext processingContext, @NotNull List<JSType> currentTypes, int min, @NotNull JSType componentType, boolean forward) {
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(14);
        }
        if (currentTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(15);
        }
        if (componentType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(16);
        }
        for (int i = min; i < currentTypes.size(); ++i) {
            JSType type = currentTypes.get(i);
            if (type instanceof JSSpreadType) {
                type = ((JSSpreadType)type).getComponentType();
            }
            if ((forward ? type : componentType).isDirectlyAssignableType(forward ? componentType : type, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        JSType type;
        if (index < 0) {
            return null;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            JSType type2 = types2.get(index);
            if (index == lastIndex && type2 instanceof JSSpreadType) {
                return ((JSSpreadType)type2).getComponentType();
            }
            return type2;
        }
        if (lastIndex >= 0 && (type = types2.get(lastIndex)) instanceof JSSpreadType) {
            return ((JSSpreadType)type).getComponentType();
        }
        return null;
    }

    public boolean hasTypeByIndex(int index) {
        if (index < 0) {
            return false;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            return true;
        }
        if (lastIndex >= 0) {
            return types2.get(lastIndex) instanceof JSSpreadType;
        }
        return false;
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (length > lastIndex) {
            JSType lastType;
            if (lastIndex >= 0 && (lastType = types2.get(lastIndex)) instanceof JSSpreadType) {
                return JSCompositeTypeFactory.createTupleType(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)lastType), this.myStrict, -1, this.myReadonly);
            }
            return null;
        }
        List<JSType> newTypes = types2.subList(length, types2.size());
        return JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, this.myStrict, this.myFirstOptional == -1 || this.myFirstOptional + length >= newTypes.size() ? -1 : this.myFirstOptional + length, this.myReadonly);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(18);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(19);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(20);
        }
        return assignableResult3;
    }

    @NotNull
    public final JSType toArrayType(boolean allowResolve) {
        return this.toArrayImpl(allowResolve);
    }

    @NotNull
    private JSType toArrayImpl(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types2 = this.getTypes();
        List providers = ContainerUtil.map(types2, el -> () -> el instanceof JSSpreadType ? ((JSSpreadType)el).getComponentType() : el);
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType || !this.isTypeScript() && commonType instanceof TypeScriptNeverJSTypeImpl) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        return this.myReadonly ? new JSReadonlyArrayTypeImpl(commonType, source) : new JSArrayTypeImpl(commonType, source);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = this.toArrayImpl(true).asRecordType();
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> members = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(parent.getTypeMembers());
        List<JSType> types2 = this.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            members.add(new JSRecordTypeImpl.PropertySignatureImpl(String.valueOf(i), types2.get(i), false, false));
        }
        return new JSRecordTypeImpl(parent.getSource(), members);
    }

    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Array", null);
    }

    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(super.resolvedHashCodeImpl(), this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(21);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myReadonly == ((JSTupleTypeImpl)type).myReadonly && this.myStrict == ((JSTupleTypeImpl)type).myStrict && this.myFirstOptional == ((JSTupleTypeImpl)type).myFirstOptional;
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder type = new StringBuilder("[");
        List<JSType> types2 = this.getTypes();
        int size = types2.size();
        int i = 0;
        for (JSType jsType : types2) {
            type.append(JSTypeUtils.defaultValueOfType(jsType));
            if (i < size - 1) {
                type.append(",");
            }
            ++i;
        }
        String string = type.append("]").toString();
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    protected boolean preserveInnerTypes() {
        return true;
    }

    @NotNull
    public final JSTupleType transformTypes(@NotNull BiFunction<? super JSType, Long, JSType> converter) {
        if (converter == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(23);
        }
        List<JSType> originalTypes = this.getTypes();
        ArrayList<JSType> result2 = new ArrayList<JSType>(originalTypes.size());
        for (int i = 0; i < originalTypes.size(); ++i) {
            result2.add(converter.apply((JSType)originalTypes.get(i), Long.valueOf(i)));
        }
        if (ContainerUtil.equalsIdentity(result2, originalTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(24);
            }
            return jSTupleTypeImpl;
        }
        return new JSTupleTypeImpl(this.getSource(), result2, this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildNestedTypePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparatorForTypeText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkWithSpreads";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transformTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

