/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSLocalNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedTypeFactory {
    static final char QUOTE_ESCAPE_MARK = 'q';
    static final String QUOTE_ESCAPE = '\u0001' + Character.toString('q');
    private static final String PROTOTYPE_SUFFIX = ".prototype";
    private static final String PROTOTYPE_CONSTRUCTOR_SUFFIX = ".prototype.constructor";

    @NotNull
    public static JSType createExplicitlyDeclaredType(@NotNull String typeString, @Nullable PsiElement element) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(0);
        }
        return JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource(element, true), JSContext.INSTANCE);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSContext staticOrInstance) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(2);
        }
        if (staticOrInstance == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(3);
        }
        return JSNamedTypeFactory.createType(typeString, source, JSTypeContext.fromJSContext(staticOrInstance));
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(5);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(6);
        }
        return JSNamedTypeFactory.createType(typeString, source, typeContext, true);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext typeContext, boolean isFromJSDoc) {
        if (typeString == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(7);
        }
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(8);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(9);
        }
        if ("*".equals(typeString) || "any".equals(typeString) && (source.getLanguage() != JSTypeSource.SourceLanguage.AS || source.getSourceElement() instanceof JSTypeDeclaration)) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(source.getLanguage(), true);
            if (jSAnyType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(10);
            }
            return jSAnyType;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.TS && "unknown".equals(typeString)) {
            JSUnknownType jSUnknownType = JSUnknownType.TS_INSTANCE;
            if (jSUnknownType == null) {
                JSNamedTypeFactory.$$$reportNull$$$0(11);
            }
            return jSUnknownType;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.AS) {
            JSType genericArgument = null;
            if ("Vector$object".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Object", source, JSContext.INSTANCE);
            }
            if ("Vector$int".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("int", source, JSContext.INSTANCE);
            }
            if ("Vector$uint".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("uint", source, JSContext.INSTANCE);
            }
            if ("Vector$double".equals(typeString)) {
                genericArgument = JSNamedTypeFactory.createType("Number", source, JSContext.INSTANCE);
            }
            if (genericArgument != null) {
                return new JSGenericTypeImpl(source, JSNamedTypeFactory.createType("Vector", source, typeContext), genericArgument);
            }
        }
        if ((typeString = StringUtil.replace((String)typeString, (String)QUOTE_ESCAPE, (String)"\"")).endsWith(PROTOTYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_SUFFIX.length());
            typeContext = JSTypeContext.PROTOTYPE;
        } else if (typeString.endsWith(PROTOTYPE_CONSTRUCTOR_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_CONSTRUCTOR_SUFFIX.length());
            typeContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith(".")) {
            typeString = typeString.substring(0, typeString.length() - 1);
            typeContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith("#")) {
            typeString = typeString.substring(0, typeString.length() - 1);
            typeContext = JSTypeContext.INSTANCE;
        }
        if (typeString.startsWith("typeof import(")) {
            typeContext = JSTypeContext.STATIC;
            typeString = typeString.substring("typeof ".length());
        }
        if (typeString.startsWith("import(")) {
            return new JSImportType(typeString, source, typeContext);
        }
        JSType primitiveType = JSSpecialNamedTypeImpl.getSpecialType(typeString, source, typeContext, isFromJSDoc);
        return primitiveType != null ? primitiveType : new JSTypeImpl(typeString, source, typeContext);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(12);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, false);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(13);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, true);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(14);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, source, isStrict, isDeclaration, false);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, @Nullable PsiElement source, boolean isStrict, boolean isDeclaration, boolean isLocal) {
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(15);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, isStrict);
        JSTypeContext typeContext = JSTypeContext.fromJSContext(jsContext, isDeclaration);
        return JSNamedTypeFactory.createNamespace(qualifiedName, typeSource, typeContext, isLocal);
    }

    @NotNull
    public static JSNamespace createNamespace(@Nullable JSQualifiedName qualifiedName, @NotNull JSTypeSource typeSource, @NotNull JSTypeContext typeContext, boolean isLocal) {
        if (typeSource == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(16);
        }
        if (typeContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(17);
        }
        if (qualifiedName == null) {
            return new JSTopLevelNamespace(typeSource, isLocal, typeContext.toJSContext());
        }
        if (isLocal) {
            return new JSLocalNamedType(qualifiedName, typeSource, typeContext);
        }
        String typeString = qualifiedName.getQualifiedName();
        JSType type = JSNamedTypeFactory.createType(typeString, typeSource, typeContext, false);
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        Object object = type instanceof JSNamespace ? (JSNamespace)type : JSAnyType.get(JSTypeSourceFactory.copyTypeSource(typeSource, false));
        if (object == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(18);
        }
        return object;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(19);
        }
        return JSNamedTypeFactory.buildProvidedNamespace(element, isStrict, null);
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict, boolean forcedLocal) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(20);
        }
        return JSNamedTypeFactory.buildProvidedNamespace(element, isStrict, forcedLocal, null);
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(21);
        }
        return JSNamedTypeFactory.buildProvidedNamespace(element, isStrict, false, visited);
    }

    @Nullable
    private static JSNamespace buildProvidedNamespace(@NotNull JSElementBase element, boolean isStrict, boolean forcedLocal, @Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        JSQualifiedName qName;
        JSNamespace ns;
        String name;
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmpty((String)(name = element.getName()))) {
            return null;
        }
        JSNamespace jSNamespace = ns = visited != null && element instanceof JSDefinitionExpressionImpl ? ((JSDefinitionExpressionImpl)element).calculateSymbolNamespace(visited) : element.getJSNamespace();
        if ("prototype".equals(name)) {
            qName = ns.getQualifiedName();
            jsContext = JSContext.INSTANCE;
        } else {
            qName = JSQualifiedNameImpl.create(name, ns.getQualifiedName());
            jsContext = JSContext.STATIC;
        }
        return JSNamedTypeFactory.createNamespace(qName, jsContext, element instanceof PsiElement ? (PsiElement)element : null, ns.isSourceStrict() && isStrict && !ns.isLocal(), true, forcedLocal || ns.isLocal());
    }

    public static JSNamespace buildJSNamespace(@NotNull JSElementBase element) {
        if (element == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(23);
        }
        return JSNamedTypeFactory.createNamespace(element.getNamespace(), element.getJSContext(), element instanceof PsiElement ? (PsiElement)element : null, element.isNamespaceExplicitlyDeclared());
    }

    @NotNull
    public static JSNamespace fromNamepath(@NotNull String namepath, boolean isExplicitlyDeclared) {
        if (namepath == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(24);
        }
        JSContext jsContext = JSContext.STATIC;
        if (namepath.endsWith(PROTOTYPE_SUFFIX)) {
            namepath = namepath.substring(0, namepath.length() - "prototype".length() - 1);
            jsContext = JSContext.INSTANCE;
        } else if (namepath.endsWith("#")) {
            namepath = namepath.substring(0, namepath.length() - 1);
            jsContext = JSContext.INSTANCE;
        }
        return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromNamepath(namepath), jsContext, null, isExplicitlyDeclared);
    }

    @NotNull
    public static JSNamespace copyWithJSContext(@NotNull JSNamespace namespace, @NotNull JSContext jsContext) {
        if (namespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(25);
        }
        if (jsContext == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(26);
        }
        JSNamespace jSNamespace = namespace instanceof JSNamedType ? ((JSNamedType)namespace).copyWithJSContext(jsContext) : namespace;
        if (jSNamespace == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(27);
        }
        return jSNamespace;
    }

    @NotNull
    public static JSTypeImpl createEnumLiteralType(JSResolvableType enumType, @NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(28);
        }
        return JSNamedTypeFactory.createEnumLiteralType(enumType.getTypeText(), jsVariable, enumType.getSource());
    }

    @NotNull
    public static JSTypeImpl createEnumLiteralType(String enumName, JSFieldVariable enumField, JSTypeSource typeSource) {
        return JSNamedTypeFactory.createEnumLiteralType(enumName, enumField.getName(), typeSource);
    }

    @NotNull
    public static JSTypeImpl createEnumLiteralType(String enumName, String fieldName, JSTypeSource typeSource) {
        return (JSTypeImpl)JSNamedTypeFactory.createType(enumName + "." + fieldName, typeSource, JSTypeContext.INSTANCE, false);
    }

    @NotNull
    public static JSType createFunctionType(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedTypeFactory.$$$reportNull$$$0(29);
        }
        return source.getLanguage() == JSTypeSource.SourceLanguage.AS ? JSNamedTypeFactory.createType(JSTypeUtils.getFunctionTypeName(source.getScope(), false), source, JSTypeContext.INSTANCE) : new JSFunctionTypeImpl(source, JSFunctionTypeImpl.ANY_PARAMETERS, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNamedTypeFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespace";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExplicitlyDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 27: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createNamespace";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildJSNamespace";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyWithJSContext";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createEnumLiteralType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 18: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

