/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileStubBuilder
extends DefaultStubBuilder {
    public static final Key<Boolean> ALLOW_HANDLERS = Key.create((String)"js.stubs.allow.handlers");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder");

    public StubElement buildStubTree(final @NotNull PsiFile file2) {
        StubElement parentStub;
        if (file2 == null) {
            JSFileStubBuilder.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building stub for " + file2.getViewProvider().getVirtualFile().getCanonicalPath() + ", language: " + file2.getLanguage());
        }
        if (!((parentStub = this.createStubForFile(file2)) instanceof JSFileStubImpl) || !(file2 instanceof JSFile) || ((JSFileStubImpl)parentStub).getCachedData() != null) {
            new JSStubBuildingWalkingVisitor((ASTNode)file2.getNode(), parentStub).buildStubTreeAndUpdateLinks();
            return parentStub;
        }
        final JSFileCachedData cachedData = new JSFileCachedData();
        if (JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)file2)) {
            file2.putUserData(ALLOW_HANDLERS, (Object)false);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)file2)) {
            handler.processFile((JSFile)file2, cachedData);
        }
        new JSStubBuildingWalkingVisitor((ASTNode)file2.getNode(), parentStub){
            final JSFileCachedDataEvaluator evaluator;
            {
                super(root, parentStub);
                this.evaluator = JSDialectSpecificHandlersFactory.forLanguage(file2.getLanguage()).newFileCachedDataEvaluator(cachedData);
            }

            protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
                PsiElement element = node.getPsi();
                this.evaluator.startElement(element);
                super.visitNode(parentStub, node, immediateParentStubbed);
                if (node.getLastChildNode() == null) {
                    this.evaluator.finishElement(element);
                    ASTNode nextNode = this.peekNextElement();
                    if (nextNode != null) {
                        ASTNode nextNodeParent = nextNode.getTreeParent();
                        for (ASTNode currentParent = node.getTreeParent(); currentParent != null && currentParent != nextNodeParent; currentParent = currentParent.getTreeParent()) {
                            this.evaluator.finishElement(currentParent.getPsi());
                        }
                    }
                }
            }
        }.buildStubTreeAndUpdateLinks();
        ((JSFileStubImpl)parentStub).setCachedData(cachedData);
        return parentStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSFileStubBuilder.$$$reportNull$$$0(1);
        }
        if (file2 instanceof JSFile) {
            return new JSFileStubImpl((JSFile)file2);
        }
        StubElement stubElement = super.createStubForFile(file2);
        if (stubElement == null) {
            JSFileStubBuilder.$$$reportNull$$$0(2);
        }
        return stubElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSStubLinksTracker {
        private final Map<StubBasedPsiElement<?>, ObjectStubBase<?>> myMap = new THashMap();
        private final List<JSStubBasedExpressionType> myTypesToProcess = new SmartList();

        private JSStubLinksTracker() {
        }

        void stubCreated(StubElement stub, ASTNode node) {
            JSType type;
            JSStubElementTypeHolder typeHolder;
            PsiElement psi;
            if (stub instanceof ObjectStubBase && (psi = node.getPsi()) instanceof StubBasedPsiElement) {
                this.myMap.put((StubBasedPsiElement)psi, (ObjectStubBase)stub);
            }
            if (stub instanceof JSTypeHolderOwner && (typeHolder = ((JSTypeHolderOwner)stub).getJSTypeHolder()) != null && (type = typeHolder.getJSType()) != null) {
                type.accept(new JSRecursiveTypeVisitor(){

                    public void visitJSType(@NotNull JSType type) {
                        if (type == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (type instanceof JSStubBasedExpressionType) {
                            myTypesToProcess.add((JSStubBasedExpressionType)type);
                        }
                        super.visitJSType(type);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder$JSStubLinksTracker$1", "visitJSType"));
                    }
                });
            }
        }

        void updateCollectedTypes() {
            for (JSStubBasedExpressionType stubBasedExpressionType : this.myTypesToProcess) {
                stubBasedExpressionType.applyMappings(this.myMap);
            }
        }
    }

    private class JSStubBuildingWalkingVisitor
    extends DefaultStubBuilder.StubBuildingWalkingVisitor {
        @NotNull
        private final JSStubLinksTracker myLinksTracker;

        protected JSStubBuildingWalkingVisitor(ASTNode root, StubElement parentStub) {
            super((DefaultStubBuilder)JSFileStubBuilder.this, root, parentStub);
            this.myLinksTracker = new JSStubLinksTracker();
        }

        protected void buildStubTreeAndUpdateLinks() {
            this.buildStubTree();
            this.myLinksTracker.updateCollectedTypes();
        }

        @Nullable
        protected StubElement createStub(StubElement parentStub, ASTNode node) {
            StubElement stub = super.createStub(parentStub, node);
            this.myLinksTracker.stubCreated(stub, node);
            return stub;
        }
    }
}

