/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSDocModulesIndex;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocCommentStubImpl
extends JSPossiblyStoredStubImpl<JSDocComment>
implements JSDocCommentStub {
    private static final BooleanStructureElement HAS_GENERIC_PARAMETERS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONSTRUCTS_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_NAMESPACE_TAG_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final EnumStructureElement<JSDocComment.BrowserFamily> BROWSER_FAMILY_FLAG = new EnumStructureElement<JSDocComment.BrowserFamily>(JSDocComment.BrowserFamily.class);
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ABSTRACT_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONST_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_MODULE_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ALIAS_TAG_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSPossiblyStoredStubImpl.FLAGS_STRUCTURE, HAS_GENERIC_PARAMETERS_FLAG, IS_INTERFACE_FLAG, HAS_CONSTRUCTS_TAG_FLAG, HAS_NAMESPACE_TAG_FLAG, JS_CONTEXT_FLAG, BROWSER_FAMILY_FLAG, IS_CLASS_EXPLICITLY_FLAG, HAS_ABSTRACT_TAG_FLAG, HAS_CONST_TAG_FLAG, HAS_MODULE_TAG_FLAG, HAS_ALIAS_TAG_FLAG);
    @NotNull
    private final @NotNull List<Pair<@NotNull String, @Nullable String>> myGenericParameters;
    @Nullable
    private final String myNamespaceForGenericParameters;
    @Nullable
    private final String myModuleName;
    @Nullable
    private final String myAlias;

    public JSDocCommentStubImpl(JSDocComment psi, StubElement parent) {
        super(psi, parent, JSStubElementTypes.DOC_COMMENT);
        List typedefs;
        this.myGenericParameters = psi.getGenericParameters();
        String ns = psi.findNameOfClassAppliedTo();
        if (ns == null && !(typedefs = psi.getTypedefs()).isEmpty()) {
            ns = (String)((Pair)typedefs.get((int)0)).first;
        }
        this.myNamespaceForGenericParameters = ns;
        this.writeFlag(IS_INTERFACE_FLAG, psi.hasInterfaceTag());
        this.writeFlag(HAS_CONSTRUCTS_TAG_FLAG, psi.hasConstructsTag());
        this.writeFlag(JS_CONTEXT_FLAG, psi.getJSContext());
        this.writeFlag(BROWSER_FAMILY_FLAG, psi.getBrowserFamily());
        this.writeFlag(HAS_NAMESPACE_TAG_FLAG, psi.hasNamespaceTag());
        this.writeFlag(HAS_GENERIC_PARAMETERS_FLAG, !this.myGenericParameters.isEmpty());
        this.writeFlag(IS_CLASS_EXPLICITLY_FLAG, this.isClassExplicitly());
        this.writeFlag(HAS_ABSTRACT_TAG_FLAG, psi.hasAbstractTag());
        this.writeFlag(HAS_CONST_TAG_FLAG, psi.hasConstTag());
        String explicitName = psi.getExplicitName();
        boolean hasModule = explicitName != null && explicitName.startsWith("module:");
        this.writeFlag(HAS_MODULE_TAG_FLAG, hasModule);
        this.myModuleName = hasModule ? explicitName.substring("module:".length()) : null;
        String alias = psi.getAlias();
        this.writeFlag(HAS_ALIAS_TAG_FLAG, alias != null);
        this.myAlias = alias;
    }

    public JSDocCommentStubImpl(StubInputStream stream, StubElement stub) throws IOException {
        super(stream, stub, JSStubElementTypes.DOC_COMMENT);
        boolean hasGenericParameters = this.readFlag(HAS_GENERIC_PARAMETERS_FLAG);
        if (hasGenericParameters) {
            int size = DataInputOutputUtil.readINT((DataInput)stream);
            this.myGenericParameters = new SmartList();
            for (int i = 0; i < size; ++i) {
                this.myGenericParameters.add((Pair<String, String>)Pair.create((Object)ObjectUtils.notNull((Object)stream.readNameString(), (Object)""), (Object)stream.readNameString()));
            }
        } else {
            this.myGenericParameters = Collections.emptyList();
        }
        this.myNamespaceForGenericParameters = stream.readNameString();
        boolean hasModule = this.readFlag(HAS_MODULE_TAG_FLAG);
        this.myModuleName = hasModule ? stream.readNameString() : null;
        boolean hasAlias = this.readFlag(HAS_ALIAS_TAG_FLAG);
        this.myAlias = hasAlias ? stream.readNameString() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_GENERIC_PARAMETERS_FLAG).booleanValue()) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myGenericParameters.size());
            for (Pair<String, String> pair : this.myGenericParameters) {
                dataStream.writeName((String)pair.getFirst());
                dataStream.writeName((String)pair.getSecond());
            }
        }
        dataStream.writeName(this.myNamespaceForGenericParameters);
        if (this.readFlag(HAS_MODULE_TAG_FLAG).booleanValue()) {
            dataStream.writeName(this.myModuleName);
        }
        if (this.readFlag(HAS_ALIAS_TAG_FLAG).booleanValue()) {
            dataStream.writeName(this.myAlias);
        }
    }

    public JSDocComment createPsi() {
        return new JSDocCommentImpl(this, (IStubElementType)JSStubElementTypes.DOC_COMMENT);
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        if (!this.myGenericParameters.isEmpty() && this.myNamespaceForGenericParameters != null) {
            sink.occurrence(JSGenericsIndex.KEY, (Object)this.myNamespaceForGenericParameters);
        }
        if (this.myModuleName != null) {
            sink.occurrence(JSDocModulesIndex.KEY, (Object)this.myModuleName);
        }
    }

    public boolean hasInterfaceTag() {
        return this.readFlag(IS_INTERFACE_FLAG);
    }

    public boolean hasConstructsTag() {
        return this.readFlag(HAS_CONSTRUCTS_TAG_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(1);
        }
        return jSContext;
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocComment.BrowserFamily browserFamily = this.readFlag(BROWSER_FAMILY_FLAG);
        if (browserFamily == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(2);
        }
        return browserFamily;
    }

    @NotNull
    public @NotNull List<Pair<@NotNull String, @Nullable String>> getGenericParameters() {
        List<Pair<String, String>> list2 = this.myGenericParameters;
        if (list2 == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public boolean hasNamespaceTag() {
        return this.readFlag(HAS_NAMESPACE_TAG_FLAG);
    }

    public boolean isClassExplicitly() {
        return this.readFlag(IS_CLASS_EXPLICITLY_FLAG);
    }

    public boolean hasAbstractTag() {
        return this.readFlag(HAS_ABSTRACT_TAG_FLAG);
    }

    public boolean hasConstTag() {
        return this.readFlag(HAS_CONST_TAG_FLAG);
    }

    @Nullable
    public String getAlias() {
        return this.myAlias;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

