/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class JSApplyIndexedAccessToDestructuringElement
implements JSApplyIndexedAccessElement {
    @NotNull
    private final JSDestructuringArray myDestructuringArray;
    @NotNull
    private final PsiElement myArrayElement;

    public JSApplyIndexedAccessToDestructuringElement(@NotNull JSDestructuringArray destructuringArray, @NotNull PsiElement arrayElement) {
        if (destructuringArray == null) {
            JSApplyIndexedAccessToDestructuringElement.$$$reportNull$$$0(0);
        }
        if (arrayElement == null) {
            JSApplyIndexedAccessToDestructuringElement.$$$reportNull$$$0(1);
        }
        this.myDestructuringArray = destructuringArray;
        this.myArrayElement = arrayElement;
    }

    public int getIndex() {
        JSInitializerOwner[] elements = this.myDestructuringArray.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != this.myArrayElement) continue;
            return i;
        }
        if (this.myDestructuringArray.getRestElement() == this.myArrayElement) {
            return elements.length;
        }
        return -1;
    }

    @Override
    public boolean applyWithArgument(@NotNull JSType qualifierType, @NotNull Consumer<? super JSType> callback) {
        if (qualifierType == null) {
            JSApplyIndexedAccessToDestructuringElement.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            JSApplyIndexedAccessToDestructuringElement.$$$reportNull$$$0(3);
        }
        JSDestructuringArrayRestElement restElement = this.myDestructuringArray.getRestElement();
        if (qualifierType instanceof JSTupleType) {
            JSType newType;
            JSTupleType tupleType = (JSTupleType)qualifierType;
            int indexMatched = ArrayUtil.indexOf((Object[])this.myDestructuringArray.getElements(), (Object)this.myArrayElement);
            if (tupleType.hasTypeByIndex(indexMatched)) {
                callback.accept((JSType)tupleType.getTypeByIndex(indexMatched));
                return true;
            }
            if (this.myArrayElement == restElement && (newType = tupleType.excludePrefix(this.myDestructuringArray.getElements().length)) != null) {
                callback.accept((JSType)newType);
                return true;
            }
        }
        if (this.myArrayElement == restElement) {
            callback.accept((JSType)qualifierType);
            return true;
        }
        return false;
    }

    @NotNull
    public PsiElement getArrayElement() {
        PsiElement psiElement = this.myArrayElement;
        if (psiElement == null) {
            JSApplyIndexedAccessToDestructuringElement.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringArray";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyIndexedAccessToDestructuringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyIndexedAccessToDestructuringElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyWithArgument";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

