/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportHandler {
    private static final JSImportHandler INSTANCE = new JSImportHandler();

    protected JSImportHandler() {
    }

    public static JSImportHandler getInstance() {
        return INSTANCE;
    }

    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSImportHandler.$$$reportNull$$$0(1);
        }
        return this.resolveMainElementName(type, context, JSContext.UNKNOWN).getQualifiedName();
    }

    @NotNull
    public Collection<? extends PsiElement> resolveObjectOrTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSImportHandler.$$$reportNull$$$0(3);
        }
        Collection<? extends PsiElement> collection = this.resolveName(type, context).getElements();
        if (collection == null) {
            JSImportHandler.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context, @NotNull JSContext jsContext) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSImportHandler.$$$reportNull$$$0(6);
        }
        if (jsContext == null) {
            JSImportHandler.$$$reportNull$$$0(7);
        }
        return this.resolveName(type, context);
    }

    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSImportHandler.$$$reportNull$$$0(9);
        }
        return this.resolveName(type, context);
    }

    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSImportHandler.$$$reportNull$$$0(11);
        }
        if (context.getContainingFile() == null) {
            return new JSTypeResolveResult(type, null);
        }
        Collection<PsiElement> elements = new ES6QualifiedNameResolver(context, false, true).resolveQualifiedName(type);
        if (elements.isEmpty()) {
            return new JSTypeResolveResult(type, null);
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (element instanceof JSVariable && context.getContainingFile() == element.getContainingFile()) {
            String text;
            String qualifiedName = ((JSVariable)element).getQualifiedName();
            if (qualifiedName != null) {
                type = qualifiedName;
            }
            if ((text = ((JSVariable)element).getLiteralOrReferenceInitializerText()) != null && !StringUtil.isQuotedString((String)text)) {
                boolean looksLikeTypeAlias = true;
                int dotIndex = text.indexOf(46);
                if (dotIndex > 0) {
                    PsiElement qualifierResolve = JSStubBasedPsiTreeUtil.resolveLocally(text.substring(0, dotIndex), element);
                    boolean bl = looksLikeTypeAlias = qualifierResolve == null;
                }
                if (looksLikeTypeAlias) {
                    return new JSTypeResolveResult(text, elements);
                }
            }
        }
        return new JSTypeResolveResult(type, elements);
    }

    @Nullable
    public JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSImportHandler.$$$reportNull$$$0(12);
        }
        return null;
    }

    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement parent) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSImportHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSImportHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectOrTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameResolvedType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectOrTypeName";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMainElementName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameUsingImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

