/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocTagImpl
extends JSElementImpl
implements JSDocTag {
    private volatile PsiReference[] myRefs;
    private volatile long myModificationCount = -1L;

    public JSDocTagImpl(IElementType elementType) {
        super(elementType);
    }

    public String getName() {
        ASTNode element = this.findChildByType(JSDocTokenTypes.DOC_TAG_NAME);
        return element != null ? element.getText().substring(1) : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSDocTagImpl.$$$reportNull$$$0(0);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocTagImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTag((JSDocTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSDocTagValue getValue() {
        return (JSDocTagValue)PsiTreeUtil.findChildOfType((PsiElement)this, JSDocTagValue.class);
    }

    @Nullable
    public JSDocTagNamepath getNamepath() {
        return (JSDocTagNamepath)PsiTreeUtil.findChildOfType((PsiElement)this, JSDocTagNamepath.class);
    }

    @Nullable
    public PsiElement getDocCommentData() {
        return this.findPsiChildByType(JSDocTokenTypes.DOC_COMMENT_DATA);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public PsiReference @NotNull [] getReferences() {
        long count = this.getManager().getModificationTracker().getModificationCount();
        if (count != this.myModificationCount) {
            PsiElement data;
            String name = this.getName();
            PsiReference[] result2 = PsiReference.EMPTY_ARRAY;
            if ("param".equals(name) && (data = this.getDocCommentData()) != null) {
                result2 = JSDocParamReference.createReferences(this);
            }
            this.myRefs = result2;
            this.myModificationCount = count;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])this.myRefs.clone();
        if (psiReferenceArray == null) {
            JSDocTagImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode treePrev;
        ASTNode node = this.getNode();
        ASTNode parentNode = node.getTreeParent();
        for (treePrev = node.getTreePrev(); treePrev != null && (treePrev.getElementType() == TokenType.WHITE_SPACE || treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treePrev = treePrev.getTreePrev()) {
            node = treePrev;
            parentNode.removeChild(node);
        }
        if (treePrev != null && treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            ASTNode treeNext;
            for (treeNext = this.getNode().getTreeNext(); treeNext != null && (treeNext.getElementType() == TokenType.WHITE_SPACE || treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treeNext = treeNext.getTreeNext()) {
            }
            if (treeNext != null && treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_END) {
                parentNode.getTreeParent().removeChild(parentNode);
                return;
            }
        }
        super.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

