/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSArrowFunctionDetector {
    public static final JSArrowFunctionDetector INSTANCE = new JSArrowFunctionDetector();
    private static final Map<IElementType, IElementType> PARENS = new HashMap<IElementType, IElementType>();

    private JSArrowFunctionDetector() {
    }

    public boolean isArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = this.checkArrowFunctionExpression(builder, parser);
        marker.rollbackTo();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(3);
        }
        this.skipAngleBrackets(builder);
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        builder.advanceLexer();
        if (next == JSTokenTypes.RPAR) {
            builder.advanceLexer();
            if (builder.getTokenType() == JSTokenTypes.COLON) {
                return true;
            }
        } else {
            while (!builder.eof()) {
                ThreeState subResult;
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSTokenTypes.RPAR) {
                    builder.advanceLexer();
                    break;
                }
                if (tokenType == JSTokenTypes.COMMA) {
                    if (builder.lookAhead(1) == JSTokenTypes.EQ) {
                        return true;
                    }
                    builder.advanceLexer();
                }
                if ((subResult = this.checkCommaSeparatedListElement(builder, parser)) == ThreeState.UNSURE) continue;
                return subResult.toBoolean();
            }
        }
        Boolean data = (Boolean)builder.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
        try {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
            if (builder.getTokenType() == JSTokenTypes.COLON && !((JSPsiTypeParser)parser.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
        }
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    @NotNull
    private ThreeState checkCommaSeparatedListElement(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(4);
        }
        if (parser == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(5);
        }
        boolean seenEquals = false;
        boolean seenColon = false;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder)) continue;
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR) break;
            if (seenEquals) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JSTokenTypes.EQ) {
                seenEquals = true;
            } else if (tokenType == JSTokenTypes.QUEST) {
                IElementType lookahead = builder.lookAhead(1);
                if (lookahead == JSTokenTypes.COLON || lookahead == JSTokenTypes.EQ || lookahead == JSTokenTypes.COMMA || lookahead == JSTokenTypes.RPAR) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(7);
                    }
                    return threeState;
                }
                if (!seenColon || !parser.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(8);
                    }
                    return threeState;
                }
            } else if (tokenType == JSTokenTypes.COLON) {
                if (!parser.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(9);
                    }
                    return threeState;
                }
                seenColon = true;
            }
            builder.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(10);
        }
        return threeState;
    }

    public boolean isArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(11);
        }
        if (parser == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(12);
        }
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = this.checkArrowFunctionType(builder, parser);
        marker.rollbackTo();
        return result2;
    }

    public boolean checkArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        ThreeState state;
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(13);
        }
        if (parser == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(14);
        }
        if (builder.getTokenType() == JSTokenTypes.LT) {
            return true;
        }
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        builder.advanceLexer();
        boolean foundParameter = false;
        while (!builder.eof() && parser.myJavaScriptParser.isIdentifierName(builder.getTokenType())) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if ((builder.getTokenType() == JSTokenTypes.LBRACE || builder.getTokenType() == JSTokenTypes.LBRACKET) && (state = this.skipAndCheckUnionOrIntersection(builder)) == ThreeState.NO) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if (!foundParameter) {
            return false;
        }
        next = builder.getTokenType();
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA || next == JSTokenTypes.QUEST || next == JSTokenTypes.EQ) {
            return true;
        }
        if (next != JSTokenTypes.RPAR) {
            return false;
        }
        builder.advanceLexer();
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    private void skipAngleBrackets(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(15);
        }
        if (builder.getTokenType() == JSTokenTypes.LT) {
            builder.advanceLexer();
            int balance = 1;
            while (!builder.eof()) {
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSTokenTypes.LT) {
                    ++balance;
                } else if (tokenType == JSTokenTypes.GT) {
                    --balance;
                }
                builder.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
    }

    private boolean skipParentheses(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(16);
        }
        IElementType lpar = builder.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == rpar) {
                builder.advanceLexer();
                return true;
            }
            if (PARENS.containsValue(tokenType)) {
                return false;
            }
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder)) continue;
                return false;
            }
            builder.advanceLexer();
        }
        return false;
    }

    @NotNull
    private ThreeState skipAndCheckUnionOrIntersection(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(17);
        }
        IElementType lpar = builder.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        boolean hasUnionOrIntersection = false;
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == rpar) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)hasUnionOrIntersection);
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(18);
                }
                return threeState;
            }
            if (PARENS.containsValue(tokenType)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(19);
                }
                return threeState;
            }
            if (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.AND) {
                hasUnionOrIntersection = true;
            }
            if (PARENS.containsKey(tokenType)) {
                ThreeState isUnionOrIntersectionInner = this.skipAndCheckUnionOrIntersection(builder);
                if (isUnionOrIntersectionInner == ThreeState.UNSURE) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(20);
                    }
                    return threeState;
                }
                hasUnionOrIntersection |= isUnionOrIntersectionInner == ThreeState.YES;
            }
            builder.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(21);
        }
        return threeState;
    }

    static {
        PARENS.put(JSTokenTypes.LPAR, JSTokenTypes.RPAR);
        PARENS.put(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE);
        PARENS.put(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSArrowFunctionDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSArrowFunctionDetector";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCommaSeparatedListElement";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCommaSeparatedListElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "skipAngleBrackets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "skipParentheses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

