/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleUtil {
    @NonNls
    public static final String NODE_MODULES = "node_modules";
    public static final String[] NODE_MODULES_ARRAY = new String[]{"node_modules"};
    public static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        int cnt2;
        String path1 = o1.getPath();
        String path2 = o2.getPath();
        int cnt1 = StringUtil.countChars((CharSequence)path1, (char)'/');
        if (cnt1 != (cnt2 = StringUtil.countChars((CharSequence)path2, (char)'/'))) {
            return cnt1 - cnt2;
        }
        return path1.compareTo(path2);
    };
    private static final Key<CachedValue<VirtualFile>> ourModuleRoot = Key.create((String)"NodeJs.Current.Module.Root");

    public static boolean isModuleFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(0);
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file2.getFileType())) {
            return NodeCoreLibraryManager.isAssociatedWithNodeCoreLibrary(file2);
        }
        return false;
    }

    @Nullable
    public static VirtualFile getProjectChildModuleByName(@NotNull Project project, @NotNull VirtualFile moduleRoot, @NotNull String name) {
        Object nodeModules;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(1);
        }
        if (moduleRoot == null) {
            NodeModuleUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            NodeModuleUtil.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        boolean projectScope = moduleRoot.equals(project.getBaseDir());
        if ((projectScope || ApplicationManager.getApplication().isUnitTestMode()) && (nodeModules = moduleRoot.findChild(NODE_MODULES)) != null) {
            return nodeModules.findChild(name);
        }
        nodeModules = new ArrayList(FilenameIndex.getVirtualFilesByName((Project)project, (String)NODE_MODULES, (GlobalSearchScope)scope));
        if (nodeModules.isEmpty()) {
            return null;
        }
        Collections.sort(nodeModules, Comparator.comparing(VirtualFile::getUrl));
        Iterator iterator = nodeModules.iterator();
        while (iterator.hasNext()) {
            VirtualFile child;
            VirtualFile root = (VirtualFile)iterator.next();
            String path = VfsUtilCore.getRelativePath((VirtualFile)root.getParent(), (VirtualFile)moduleRoot);
            if (path == null || path.contains(NODE_MODULES) || (child = root.findChild(name)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ForRequireModuleInfo getRequireModuleInfo(@NotNull Project project, @NotNull VirtualFile mainModuleRoot, @NotNull VirtualFile targetFile) {
        VirtualFile current;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(4);
        }
        if (mainModuleRoot == null) {
            NodeModuleUtil.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(6);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)mainModuleRoot, (VirtualFile)targetFile, (boolean)true)) {
            NodeModuleStructure structure = NodeModuleUtil.getNodeModuleStructure(project, targetFile);
            if (structure == null) {
                Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(mainModuleRoot);
                return new ForRequireModuleInfo(targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.EXACT_PATH);
            }
            return NodeModuleUtil.addFromChildModule(targetFile, structure.moduleDirectory);
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile moduleRoot = NodeModuleUtil.findModuleRoot(baseDir, current = targetFile.getParent());
        if (moduleRoot == null) {
            return null;
        }
        return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
    }

    public static boolean checkNodeModulesAssociation(@NotNull PsiFile targetPsiFile, boolean checkForNodeLibraryAssociation) {
        if (targetPsiFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(7);
        }
        return !checkForNodeLibraryAssociation || NodeModuleSearchUtil.canLoadFile(targetPsiFile.getVirtualFile()) && NodeModuleUtil.isLocalModuleOrNodeModulesLibrary(targetPsiFile, targetPsiFile.getVirtualFile());
    }

    private static boolean isLocalModuleOrNodeModulesLibrary(PsiFile targetPsiFile, VirtualFile targetFile) {
        return NodeModuleUtil.isModuleFile(targetPsiFile) || JSLibraryUtil.hasDirectoryInPath(targetFile, NODE_MODULES, null);
    }

    @NotNull
    private static ForRequireModuleInfo addFromChildModule(VirtualFile targetFile, VirtualFile moduleRoot) {
        Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(moduleRoot);
        return new ForRequireModuleInfo(targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.NODE_MODULES_DIR);
    }

    @Nullable
    private static VirtualFile findModuleRoot(@NotNull VirtualFile baseDir, @Nullable VirtualFile current) {
        if (baseDir == null) {
            NodeModuleUtil.$$$reportNull$$$0(8);
        }
        VirtualFile moduleRoot = null;
        while (current != null && !baseDir.equals(current)) {
            if (current.getParent() != null && NODE_MODULES.equals(current.getParent().getName())) {
                moduleRoot = current;
                break;
            }
            current = current.getParent();
        }
        return moduleRoot;
    }

    @Nullable
    public static VirtualFile getMainModuleRoot(@NotNull PsiElement context) {
        if (context == null) {
            NodeModuleUtil.$$$reportNull$$$0(9);
        }
        PsiFile file2 = context.getContainingFile();
        return (VirtualFile)CachedValuesManager.getCachedValue((PsiElement)file2, ourModuleRoot, () -> CachedValueProvider.Result.create((Object)NodeModuleUtil.findMainModuleRoot(file2.getProject(), file2.getVirtualFile()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    public static VirtualFile findMainModuleRoot(Project project, VirtualFile file2) {
        VirtualFile current;
        if (file2 == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile contentRoot = NodeModuleUtil.findParentContentRoot(project, file2);
        if (contentRoot == null) {
            return null;
        }
        VirtualFile virtualFile = current = file2.isDirectory() ? file2 : file2.getParent();
        while (current != null) {
            VirtualFile packageJson = current.findChild("package.json");
            if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
                return current;
            }
            if (baseDir != null && baseDir.equals(current)) {
                return baseDir;
            }
            current = current.getParent();
        }
        return ApplicationManager.getApplication().isUnitTestMode() ? baseDir : null;
    }

    @Nullable
    public static VirtualFile findParentContentRoot(Project project, VirtualFile file2) {
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        VirtualFile contentRoot = null;
        for (VirtualFile root : contentRoots) {
            if (!root.equals(VfsUtilCore.getCommonAncestor((VirtualFile)root, (VirtualFile)file2))) continue;
            contentRoot = root;
            break;
        }
        return contentRoot;
    }

    public static boolean isForNode(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(10);
        }
        if (vf == null) {
            NodeModuleUtil.$$$reportNull$$$0(11);
        }
        return NodeCoreLibraryManager.isAssociatedWithNodeCoreLibrary(project, vf);
    }

    public static boolean isWrappedInAmdDefinition(@NotNull PsiElement element) {
        if (element == null) {
            NodeModuleUtil.$$$reportNull$$$0(12);
        }
        return JSAmdUtil.getCachedWrappingAmdDefinition(element) != null;
    }

    public static boolean isResolvedGloballyCommonJS(@NotNull ResolveResult result2, @NotNull Set<VirtualFile> predefinedFiles) {
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(13);
        }
        if (predefinedFiles == null) {
            NodeModuleUtil.$$$reportNull$$$0(14);
        }
        if (!result2.isValidResult()) {
            return false;
        }
        PsiElement element = result2.getElement();
        if (element == null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return true;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(element);
        if (module == null && file2 instanceof JSFile && ((JSFile)file2).getModuleStatus() == JSFile.ModuleStatus.NONE) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return predefinedFiles.contains(virtualFile) || NodeModuleUtil.isResolvedGloballyForNode(result2) || NodeModuleUtil.isResolvedGloballyForFlowOrTypeScript(result2);
    }

    public static boolean isResolvedGloballyForNode(@NotNull ResolveResult result2) {
        JSQualifiedName qualifier;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(15);
        }
        return result2.getElement() != null && result2.getElement() instanceof JSDefinitionExpression && (qualifier = ((JSDefinitionExpression)result2.getElement()).getNamespace()) != null && "global".equals(qualifier.getName());
    }

    private static boolean isResolvedGloballyForFlowOrTypeScript(@NotNull ResolveResult result2) {
        JSAttributeList attributeList;
        DialectOptionHolder holder;
        PsiElement element;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(16);
        }
        return (element = result2.getElement()) instanceof JSAttributeListOwner && (holder = DialectDetector.dialectOfElement(element)) != null && (holder.isFlow || holder.isTypeScript) && JSUseScopeProvider.getLexicalScopeOrFile(element) instanceof JSFile && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isFromNodeModules(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile nodeModulesDir;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(18);
        }
        if ((nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file2)) == null) {
            return false;
        }
        return NodeModuleUtil.findParentContentRoot(project, nodeModulesDir) == null && !VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)nodeModulesDir, (boolean)true);
    }

    public static boolean hasNodeModulesDirInPath(@NotNull VirtualFile file2, @Nullable VirtualFile fileToStop) {
        if (file2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(19);
        }
        return JSLibraryUtil.hasDirectoryInPath(file2, NODE_MODULES, fileToStop);
    }

    @Nullable
    public static VirtualFile findNodeModulesByPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModuleUtil.$$$reportNull$$$0(20);
        }
        return NodeModuleUtil.findChildNodeModulesDir(packageJson.isDirectory() ? null : packageJson.getParent());
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildNodeModulesDir(@Nullable VirtualFile parent) {
        VirtualFile nodeModulesDir;
        if (parent != null && parent.isDirectory() && parent.isValid() && (nodeModulesDir = parent.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory() && nodeModulesDir.isValid()) {
            return nodeModulesDir;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findPackageJsonByNodeModules(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile parent;
        VirtualFile virtualFile = parent = nodeModulesDir != null && nodeModulesDir.isDirectory() ? nodeModulesDir.getParent() : null;
        if (parent != null) {
            return PackageJsonUtil.findChildPackageJsonFile(parent);
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(21);
        }
        return JSLibraryUtil.findUpClosestNodeModulesResolveRoot(file2);
    }

    public static boolean moduleNotInPackageJson(@NotNull String name, @NotNull VirtualFile packageJsonFile) {
        PackageJsonData data;
        if (name == null) {
            NodeModuleUtil.$$$reportNull$$$0(22);
        }
        if (packageJsonFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(23);
        }
        return !(data = PackageJsonData.getOrCreate(packageJsonFile)).isDependencyOfAnyType(name);
    }

    @Nullable
    public static String inferNodeModulePackageName(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModuleUtil.$$$reportNull$$$0(24);
        }
        VirtualFile parent = packageJson.getParent();
        String packageName = null;
        for (int depth = 0; depth < 3 && parent != null && !NodeModulesDirectoryManager.isNodeModulesDir(parent); parent = parent.getParent(), ++depth) {
            if (depth == 0) {
                packageName = parent.getName();
                continue;
            }
            if (depth == 1 && NodeModuleSearchUtil.isScopeDir(parent)) {
                packageName = parent.getName() + "/" + packageName;
                continue;
            }
            return null;
        }
        return parent != null ? packageName : null;
    }

    @Nullable
    public static NodeModuleStructure getNodeModuleStructure(@NotNull Project project, @NotNull VirtualFile fileToImport) {
        Pair<VirtualFile, VirtualFile> directories;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(25);
        }
        if (fileToImport == null) {
            NodeModuleUtil.$$$reportNull$$$0(26);
        }
        if ((directories = ES6CreateImportUtil.findParentLibraryDirectory(project, fileToImport, NODE_MODULES_ARRAY)) == null) {
            return null;
        }
        VirtualFile moduleDirectory = (VirtualFile)directories.first;
        if (moduleDirectory == null) {
            return null;
        }
        VirtualFile nodeModules = (VirtualFile)directories.second;
        VirtualFile directoryToCalcModuleName = NodeModuleUtil.getDirectoryToCalcModuleNameInNodeModules(moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return null;
        }
        return new NodeModuleStructure(moduleDirectory, directoryToCalcModuleName, nodeModules);
    }

    @Nullable
    public static VirtualFile getDirectoryToCalcModuleNameInNodeModules(@NotNull VirtualFile moduleDirectory) {
        VirtualFile directoryToCalcModuleName;
        if (moduleDirectory == null) {
            NodeModuleUtil.$$$reportNull$$$0(27);
        }
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = NodeModuleUtil.isTypesDir(current) ? current : null;
        while (current != null) {
            if ((current = current.getParent()) == null) continue;
            if (NodeModuleUtil.isTypesDir(current)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!NODE_MODULES.equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        return directoryToCalcModuleName;
    }

    @Contract(value="null -> false")
    public static boolean isTypesDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && StringUtil.equals((CharSequence)"@types", (CharSequence)dir.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isNodeModules(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)dir.getNameSequence());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModuleRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/NodeModuleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectChildModuleByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequireModuleInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNodeModulesAssociation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainModuleRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isForNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isWrappedInAmdDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyCommonJS";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyForNode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyForFlowOrTypeScript";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isFromNodeModules";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNodeModulesDirInPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "findNodeModulesByPackageJson";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleNotInPackageJson";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "inferNodeModulePackageName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeModuleStructure";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectoryToCalcModuleNameInNodeModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class NodeModuleStructure {
        @NotNull
        public final VirtualFile directoryToCalcModuleName;
        @NotNull
        public final VirtualFile moduleDirectory;
        @NotNull
        public final VirtualFile nodeModules;

        public NodeModuleStructure(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcName, @NotNull VirtualFile nodeModules) {
            if (moduleDirectory == null) {
                NodeModuleStructure.$$$reportNull$$$0(0);
            }
            if (directoryToCalcName == null) {
                NodeModuleStructure.$$$reportNull$$$0(1);
            }
            if (nodeModules == null) {
                NodeModuleStructure.$$$reportNull$$$0(2);
            }
            this.directoryToCalcModuleName = directoryToCalcName;
            this.moduleDirectory = moduleDirectory;
            this.nodeModules = nodeModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directoryToCalcName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodeModules";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/NodeModuleUtil$NodeModuleStructure";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

