/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSLiteralExpressionReferenceInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseModulesDependenciesElementVisitor
extends JSElementVisitor {
    private final ProblemsHolder myHolder;

    public JSBaseModulesDependenciesElementVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(1);
        }
        if ((qualifier = node.getQualifier()) != null) {
            return;
        }
        if (!DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) || !JSBaseModulesDependenciesElementVisitor.checkContext(node)) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSBaseModulesDependenciesElementVisitor.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        JSModuleReferenceExpressionInfo moduleReferenceInfo = new JSModuleReferenceExpressionInfo(node);
        if (moduleReferenceInfo.getContextName() == null) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)moduleReferenceInfo.getParentName()))) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, resolveResults);
        if (modulesSuggester == null) {
            return;
        }
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, resolveResults);
    }

    private static boolean checkContext(JSReferenceExpression node) {
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class);
        if (embeddedContent != null) {
            PsiElement parent = embeddedContent.getParent();
            return parent.getNode().getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE;
        }
        return true;
    }

    public void visitJSLiteralExpression(JSLiteralExpression node) {
        if (!(node instanceof JSXmlLiteralExpression) || !this.isJsxSupported((PsiElement)node)) {
            return;
        }
        String name = node.getName();
        if (!StringUtil.isCapitalized((String)name)) {
            return;
        }
        JSXmlLiteralExpression xmlLiteralExpression = (JSXmlLiteralExpression)node;
        boolean isResolved = JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty(xmlLiteralExpression);
        if (isResolved) {
            return;
        }
        JSLiteralExpressionReferenceInfo moduleReferenceInfo = new JSLiteralExpressionReferenceInfo(xmlLiteralExpression);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, ResolveResult.EMPTY_ARRAY);
        if (modulesSuggester == null) {
            return;
        }
        this.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, ResolveResult.EMPTY_ARRAY);
    }

    private void processResolvedElements(@NotNull PsiElement node, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull JsModulesSuggester modulesSuggester, ResolveResult @NotNull [] resolveResults) {
        if (node == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(2);
        }
        if (moduleReferenceInfo == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(3);
        }
        if (modulesSuggester == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(4);
        }
        if (resolveResults == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(5);
        }
        if (!JSBaseModulesDependenciesElementVisitor.shouldAddFixes(node, resolveResults, modulesSuggester)) {
            return;
        }
        String inspectionText = this.getInspectionText();
        MultiMap<PsiElement, LocalQuickFix> fixes = modulesSuggester.findFixes(resolveResults);
        if (fixes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : fixes.entrySet()) {
            Collection<LocalQuickFix> list2 = (Collection<LocalQuickFix>)entry.getValue();
            if ((list2 = JSBaseModulesDependenciesElementVisitor.sortAndFilter(list2, moduleReferenceInfo)).isEmpty()) {
                return;
            }
            PsiElement currentElement = (PsiElement)entry.getKey();
            PsiReference reference = currentElement.getReference();
            if (reference == null) continue;
            this.myHolder.registerProblemForReference(reference, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, inspectionText, list2.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    protected abstract String getInspectionText();

    @Nullable
    protected abstract JsModulesSuggester createSuggester(@NotNull PsiElement var1, @NotNull ModuleReferenceInfo var2, ResolveResult @NotNull [] var3);

    @NotNull
    public static Collection<LocalQuickFix> sortAndFilter(@NotNull Collection<LocalQuickFix> fixes, ModuleReferenceInfo moduleReferenceInfo) {
        if (fixes == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(6);
        }
        SmartList sublist = new SmartList();
        for (LocalQuickFix fix : fixes) {
            String path;
            if (!(fix instanceof ImportCommonJSModuleFix) || !(path = ((ImportCommonJSModuleFix)fix).getPath()).equals(moduleReferenceInfo.getContextName()) && !path.startsWith(moduleReferenceInfo.getContextName() + "/")) continue;
            sublist.add(fix);
        }
        if (!sublist.isEmpty()) {
            SmartList smartList = sublist;
            if (smartList == null) {
                JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(7);
            }
            return smartList;
        }
        if (fixes.size() > 10) {
            List<LocalQuickFix> list2 = new ArrayList<LocalQuickFix>(fixes).subList(0, 10);
            if (list2 == null) {
                JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(8);
            }
            return list2;
        }
        Collection<LocalQuickFix> collection = fixes;
        if (collection == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean shouldAddFixes(@NotNull PsiElement refExpression, ResolveResult @NotNull [] resolveResults, @NotNull JsModulesSuggester modulesSuggester) {
        if (refExpression == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(10);
        }
        if (modulesSuggester == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(11);
        }
        if (resolveResults == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(12);
        }
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            return false;
        }
        PsiFile file2 = refExpression.getContainingFile();
        if (new LocalReferenceResolver(file2).checkResolveResults(resolveResults)) {
            return false;
        }
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult result2 : resolveResults) {
            if (result2.isValidResult()) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(13);
        }
        if (vf == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(14);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }

    protected boolean isJsxSupported(@NotNull PsiElement node) {
        if (node == null) {
            JSBaseModulesDependenciesElementVisitor.$$$reportNull$$$0(15);
        }
        return DialectDetector.isJSX((PsiElement)node.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesSuggester";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddFixes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isForBrowser";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isJsxSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

