/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.jscs.JscsConfigurable;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsExternalRunner;
import com.intellij.lang.javascript.linter.jscs.JscsFixAction;
import com.intellij.lang.javascript.linter.jscs.JscsInspection;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.EditFirstTypeErrorInConfig;
import com.intellij.lang.javascript.linter.jscs.config.JscsCreateConfigAndExcludeFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsCreateConfigFromPresetFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsExcludeFileInConfigFix;
import com.intellij.lang.javascript.linter.jscs.config.JscsTypeError;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsExternalAnnotator
extends JSLinterExternalAnnotator<JscsState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private static final JscsExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JscsExternalAnnotator(false);
    private static final String JSCS_CODE_TEMP_FILE_MAP_KEY_NAME = "JSCS_CODE_TEMP_FILE_MAP_KEY";
    private static final String JSCS_CONFIG_TEMP_FILE_MAP_KEY_NAME = "JSCS_CONFIG_TEMP_FILE_MAP_KEY";
    private final FilesMirror myCodeFilesMirror = new FilesMirror("JSCS_CODE_TEMP_FILE_MAP_KEY", "jscs");
    private final FilesMirror myConfigFilesMirror = new FilesMirror("JSCS_CONFIG_TEMP_FILE_MAP_KEY", "jscs");
    private final AtomicReference<File> myEmptyConfig = new AtomicReference();

    public static JscsExternalAnnotator getInstanceForBatchInspection() {
        return INSTANCE_FOR_BATCH_INSPECTION;
    }

    public JscsExternalAnnotator() {
        this(true);
    }

    public JscsExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    private void tryCreateEmptyConfig() {
        if (this.myEmptyConfig.get() != null) {
            return;
        }
        try {
            File empty = FileUtil.createTempFile((String)"jscs_empty", (String)".jscsrc");
            FileUtil.writeToFile((File)empty, (String)"{}");
            this.myEmptyConfig.set(empty);
            empty.deleteOnExit();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JscsState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            JscsExternalAnnotator.$$$reportNull$$$0(0);
        }
        return new JscsConfigurable(project, true);
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JscsState>> getConfigurationClass() {
        return JscsConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JscsInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JscsExternalAnnotator.$$$reportNull$$$0(1);
        }
        return file2 instanceof JSFile && JSUtils.isJavaScriptFile(file2);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult doAnnotate(@Nullable JSLinterInput<JscsState> collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        return this.createJscsRunner(collectedInfo).execute();
    }

    @NotNull
    public JscsExternalRunner createJscsRunner(@NotNull JSLinterInput<JscsState> collectedInfo) {
        if (collectedInfo == null) {
            JscsExternalAnnotator.$$$reportNull$$$0(2);
        }
        return new JscsExternalRunner(collectedInfo, this.myCodeFilesMirror, this.myConfigFilesMirror, collectedInfo.getProject(), (Getter<? extends File>)((Getter)() -> {
            this.tryCreateEmptyConfig();
            return this.myEmptyConfig.get();
        }));
    }

    @Override
    public void apply(@NotNull PsiFile file2, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            JscsExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JscsExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (annotationResult == null) {
            return;
        }
        boolean useDefault = annotationResult.getConfigFile() == null;
        boolean noConfig = annotationResult.getConfigFile() != null && FileUtil.filesEqual((File)this.myEmptyConfig.get(), (File)new File(annotationResult.getConfigFile().getPath()));
        new JSLinterAnnotationsBuilder(file2, annotationResult, holder, new JscsConfigurable(file2.getProject(), true), "JSCS: ", this.getInspectionClass(), new JSLinterStandardFixes().setEditConfig(false).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)errorBase -> {
            if (!useDefault) {
                if (!StringUtil.isEmptyOrSpaces((String)errorBase.getCode())) {
                    ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(3);
                    VirtualFile configFile = annotationResult.getConfigFile();
                    if (!noConfig) {
                        JSLinterEditConfigFileAction action = new JSLinterEditConfigFileAction(configFile);
                        action.setProperty(errorBase.getCode());
                        list2.add(action);
                    } else {
                        list2.add(new JscsCreateConfigFromPresetFix());
                    }
                    if (errorBase instanceof JSLinterError) {
                        if (this.isOnTheFly()) {
                            list2.add((IntentionAction)new JscsSuppressRuleFix(((JSLinterError)errorBase).getLine(), errorBase.getCode()));
                        }
                        list2.add((IntentionAction)new JscsSuppressRuleForFileFix(errorBase.getCode()));
                        JscsExternalAnnotator.addExcludeFileInConfigFix(list2, noConfig ? null : configFile, file2);
                    }
                    list2.add(new JscsFixAction().asIntentionAction());
                    return list2;
                }
                if (errorBase instanceof JscsTypeError) {
                    VirtualFile configFile = annotationResult.getConfigFile();
                    return Collections.singletonList(new EditFirstTypeErrorInConfig(configFile));
                }
            }
            return null;
        }))).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static void addExcludeFileInConfigFix(List<IntentionAction> list2, VirtualFile configFile, PsiFile file2) {
        String configPath = configFile == null ? file2.getProject().getBasePath() : configFile.getParent().getPath();
        String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)configPath), (String)FileUtil.toSystemIndependentName((String)file2.getVirtualFile().getPath()), (char)'/');
        if (relativePath != null) {
            relativePath = JscsExternalAnnotator.correctRelativePathForJscs(relativePath);
            if (configFile == null) {
                list2.add(new JscsCreateConfigAndExcludeFix(file2.getName(), relativePath));
            } else {
                list2.add(new JscsExcludeFileInConfigFix(configFile, file2.getName(), relativePath));
            }
        }
    }

    private static String correctRelativePathForJscs(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        if (!relativePath.startsWith(".")) {
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            relativePath = "." + relativePath;
        }
        return relativePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createJscsRunner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JscsSuppressRuleForFileFix
    extends BaseIntentionAction {
        @NotNull
        private final String myCode;

        public JscsSuppressRuleForFileFix(@NotNull String code) {
            if (code == null) {
                JscsSuppressRuleForFileFix.$$$reportNull$$$0(0);
            }
            this.myCode = code;
        }

        @NotNull
        public String getFamilyName() {
            return "Suppress for current file";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                JscsSuppressRuleForFileFix.$$$reportNull$$$0(1);
            }
            return true;
        }

        @NotNull
        public String getText() {
            String string = "Suppress " + this.myCode + " for file";
            if (string == null) {
                JscsSuppressRuleForFileFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            Document document2;
            if (project == null) {
                JscsSuppressRuleForFileFix.$$$reportNull$$$0(3);
            }
            if ((document2 = JSLinterUtil.getDocumentForElement((PsiElement)file2)) == null) {
                return;
            }
            document2.insertString(0, (CharSequence)("// jscs:disable " + this.myCode + "\n"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleForFileFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JscsSuppressRuleFix
    extends BaseIntentionAction {
        private final int myZeroBasedLineNumber;
        @NotNull
        private final String myCode;

        public JscsSuppressRuleFix(int zeroBasedLineNumber, @NotNull String code) {
            if (code == null) {
                JscsSuppressRuleFix.$$$reportNull$$$0(0);
            }
            this.myZeroBasedLineNumber = zeroBasedLineNumber;
            this.myCode = code;
        }

        @NotNull
        public String getFamilyName() {
            return "Suppress for current line";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                JscsSuppressRuleFix.$$$reportNull$$$0(1);
            }
            return true;
        }

        @NotNull
        public String getText() {
            String string = "Suppress " + this.myCode + " for current line";
            if (string == null) {
                JscsSuppressRuleFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            Document document2;
            if (project == null) {
                JscsSuppressRuleFix.$$$reportNull$$$0(3);
            }
            if ((document2 = JSLinterUtil.getDocumentForElement((PsiElement)file2)) == null) {
                return;
            }
            int offset = editor.getCaretModel().getOffset();
            JscsInspection.JscsSuppressForLineByCommentFix.suppressRuleForLine(project, document2, file2, this.myZeroBasedLineNumber, offset, this.myCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/JscsExternalAnnotator$JscsSuppressRuleFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

