/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinterCodeStyleImportSourceTracker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDismissedPropertyKey;
    @NotNull
    private final Processor<? super VirtualFile> myFileSelector;
    @NotNull
    private final Runnable myDismissAction;
    private boolean psiChangedListenerRegistered;

    public LinterCodeStyleImportSourceTracker(@NotNull Project project, @NotNull String dismissedPropertyKey, @NotNull Processor<? super VirtualFile> fileSelector) {
        if (project == null) {
            LinterCodeStyleImportSourceTracker.$$$reportNull$$$0(0);
        }
        if (dismissedPropertyKey == null) {
            LinterCodeStyleImportSourceTracker.$$$reportNull$$$0(1);
        }
        if (fileSelector == null) {
            LinterCodeStyleImportSourceTracker.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDismissedPropertyKey = dismissedPropertyKey;
        this.myFileSelector = fileSelector;
        this.myDismissAction = () -> {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myDismissedPropertyKey, true);
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        };
    }

    public synchronized void registerPsiChangedListener() {
        if (this.psiChangedListenerRegistered) {
            return;
        }
        this.psiChangedListenerRegistered = true;
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file2) {
                if (file2 == null) {
                    return;
                }
                VirtualFile vFile = file2.getViewProvider().getVirtualFile();
                if (!LinterCodeStyleImportSourceTracker.this.shouldDismiss(vFile)) {
                    EditorNotifications.getInstance((Project)LinterCodeStyleImportSourceTracker.this.myProject).updateNotifications(vFile);
                }
            }
        }, (Disposable)this.myProject);
    }

    public boolean shouldDismiss(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LinterCodeStyleImportSourceTracker.$$$reportNull$$$0(3);
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.myDismissedPropertyKey) || !this.myFileSelector.process((Object)file2);
    }

    @NotNull
    public Runnable getDismissAction() {
        Runnable runnable = this.myDismissAction;
        if (runnable == null) {
            LinterCodeStyleImportSourceTracker.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dismissedPropertyKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/LinterCodeStyleImportSourceTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDismissAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldDismiss";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

