/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterConfiguration<T extends JSLinterState>
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private volatile ExtendedLinterState<T> myExtendedState;
    private boolean myStateElementLoaded;

    public JSLinterConfiguration(@NotNull Project project) {
        if (project == null) {
            JSLinterConfiguration.$$$reportNull$$$0(0);
        }
        this.myStateElementLoaded = false;
        this.myProject = project;
    }

    public final void setExtendedState(@NotNull ExtendedLinterState<T> extendedState) {
        if (extendedState == null) {
            JSLinterConfiguration.$$$reportNull$$$0(1);
        }
        ExtendedLinterState<T> oldExtendedState = this.getExtendedState();
        if (extendedState.isEnabled() != oldExtendedState.isEnabled()) {
            this.setEnabled(extendedState.isEnabled());
        }
        this.savePrivateSettings(extendedState.getState());
        this.myExtendedState = extendedState;
        if (!extendedState.equals(oldExtendedState)) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public final void setExtendedState(boolean enabled, @NotNull T state) {
        if (state == null) {
            JSLinterConfiguration.$$$reportNull$$$0(2);
        }
        this.setExtendedState(ExtendedLinterState.create(enabled, state));
    }

    protected abstract void savePrivateSettings(@NotNull T var1);

    @NotNull
    public final ExtendedLinterState<T> getExtendedState() {
        return this.getExtendedState(false);
    }

    @NotNull
    public final ExtendedLinterState<T> getExtendedState(boolean clearCaches) {
        ExtendedLinterState<T> extendedState = this.myExtendedState;
        if (extendedState == null || clearCaches) {
            boolean enabled = this.isEnabled();
            T state = extendedState != null ? extendedState.getState() : this.getDefaultState();
            state = this.loadPrivateSettings(state);
            extendedState = ExtendedLinterState.create(enabled, state);
            this.myExtendedState = extendedState;
        }
        ExtendedLinterState<T> extendedLinterState = extendedState;
        if (extendedLinterState == null) {
            JSLinterConfiguration.$$$reportNull$$$0(3);
        }
        return extendedLinterState;
    }

    @NotNull
    protected abstract T loadPrivateSettings(@NotNull T var1);

    public final Element getState() {
        ExtendedLinterState<T> extendedState = this.myExtendedState;
        if (extendedState == null) {
            return null;
        }
        T state = extendedState.getState();
        if (!this.myStateElementLoaded && state.equals(this.getDefaultState())) {
            return null;
        }
        Element element = this.toXml(state);
        if (element == null && this.myStateElementLoaded) {
            element = new Element("any");
        }
        return element;
    }

    public final void loadState(@NotNull Element element) {
        if (element == null) {
            JSLinterConfiguration.$$$reportNull$$$0(4);
        }
        if (element != null) {
            this.myStateElementLoaded = true;
            T state = this.fromXml(element);
            state = this.loadPrivateSettings(state);
            this.myExtendedState = ExtendedLinterState.create(this.isEnabled(), state);
        }
    }

    public boolean isEnabled() {
        return JSLinterInspection.isToolEnabled(this.myProject, this.getInspectionClass(), null);
    }

    public void setEnabled(boolean enabled) {
        JSLinterInspection.setToolEnabled(this.myProject, this.getInspectionClass(), enabled);
    }

    @NotNull
    protected abstract Class<? extends JSLinterInspection> getInspectionClass();

    @Nullable
    protected abstract Element toXml(@NotNull T var1);

    @NotNull
    protected abstract T fromXml(@NotNull Element var1);

    @NotNull
    protected abstract T getDefaultState();

    @NotNull
    public static <T extends JSLinterConfiguration> T getInstance(@NotNull Project project, @NotNull Class<T> configurationClass) {
        if (project == null) {
            JSLinterConfiguration.$$$reportNull$$$0(5);
        }
        if (configurationClass == null) {
            JSLinterConfiguration.$$$reportNull$$$0(6);
        }
        JSLinterConfiguration jSLinterConfiguration = (JSLinterConfiguration)ServiceManager.getService((Project)project, configurationClass);
        if (jSLinterConfiguration == null) {
            JSLinterConfiguration.$$$reportNull$$$0(7);
        }
        return (T)jSLinterConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExtendedState";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

