/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

class LibraryCommitChangesMerger {
    private static final Logger LOG = Logger.getInstance(LibraryCommitChangesMerger.class);
    private final JSLibraryManager myLibraryManager;
    private final long myMergeDelayMillis;
    private final AtomicNotNullLazyValue<Alarm> myAlarmLazyValue;

    LibraryCommitChangesMerger(@NotNull JSLibraryManager libraryManager, long mergeDelayMillis) {
        if (libraryManager == null) {
            LibraryCommitChangesMerger.$$$reportNull$$$0(0);
        }
        this.myLibraryManager = libraryManager;
        this.myMergeDelayMillis = mergeDelayMillis;
        this.myAlarmLazyValue = AtomicNotNullLazyValue.createValue(() -> new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myLibraryManager.getProject()));
    }

    void request() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                WriteAction.run(() -> this.myLibraryManager.commitChanges());
            } else {
                LOG.error("Skipping request");
            }
        } else {
            Alarm alarm = (Alarm)this.myAlarmLazyValue.getValue();
            alarm.cancelAllRequests();
            alarm.addRequest(() -> WriteAction.run(() -> this.myLibraryManager.commitChanges()), this.myMergeDelayMillis, ModalityState.NON_MODAL);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryManager", "com/intellij/lang/javascript/library/LibraryCommitChangesMerger", "<init>"));
    }
}

