/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCallChainToPipeIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(1);
        }
        JSCallExpression callExpression = JSCallChainToPipeIntention.findCall(element);
        assert (callExpression != null);
        StringBuilder newExpressionBuilder = new StringBuilder(callExpression.getArguments()[0].getText());
        JSCallChainToPipeIntention.appendMethod(callExpression, newExpressionBuilder);
        JSCallExpression parentCall = JSCallChainToPipeIntention.findCall(callExpression.getParent());
        while (parentCall != null && JSCallChainToPipeIntention.isArgument(parentCall, (PsiElement)callExpression)) {
            callExpression = parentCall;
            JSCallChainToPipeIntention.appendMethod(callExpression, newExpressionBuilder);
            parentCall = JSCallChainToPipeIntention.findCall(parentCall.getParent());
        }
        callExpression.replace(JSPsiElementFactory.createJSExpression(newExpressionBuilder.toString(), element));
    }

    private static boolean isArgument(@NotNull JSCallExpression call, @NotNull PsiElement parent) {
        if (call == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(3);
        }
        for (JSExpression argument : call.getArguments()) {
            if (argument != parent) continue;
            return true;
        }
        return false;
    }

    private static void appendMethod(JSCallExpression callExpression, StringBuilder builder) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        builder.append(" |> ").append(methodExpression == null ? "" : methodExpression.getText());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.call.chain.to.pipe", (Object[])new Object[0]);
        if (string == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSCallChainToPipeIntention.$$$reportNull$$$0(7);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        return DialectDetector.hasFeature(element, JSLanguageFeature.PIPE_EXPRESSIONS) && JSCallChainToPipeIntention.findCall(element) != null;
    }

    @Nullable
    private static JSCallExpression findCall(@Nullable PsiElement element) {
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class, (boolean)false, (Class[])new Class[]{JSSourceElement.class});
        if (callExpression == null || callExpression instanceof JSNewExpression || callExpression.getArguments().length != 1 || callExpression.getMethodExpression() == null) {
            return null;
        }
        return callExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCallChainToPipeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCallChainToPipeIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isArgument";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

