/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspectionBase;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertLetToConstInspection
extends ES6ConvertVarToLetConstInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertLetToConstInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertLetToConstInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSVarStatement(JSVarStatement node) {
                boolean isBatch;
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                ASTNode varNode = node.getNode().findChildByType(JSTokenTypes.LET_KEYWORD);
                if (varNode == null || !ES6ConvertVarToLetConstInspectionBase.isAvailableForStatement(node)) {
                    return;
                }
                boolean bl = isBatch = !holder.isOnTheFly() || ES6ConvertLetToConstInspection.this.myEmulateBatch && ApplicationManager.getApplication().isUnitTestMode();
                if (!ES6ConvertVarToLetConstQuickFix.canBeConst(node, true, isBatch)) {
                    return;
                }
                if (isBatch) {
                    ES6ConvertVarToLetConstQuickFix fix = new ES6ConvertVarToLetConstQuickFix(node).setInBatch(true).forceVariant(true);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.let.to.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                } else {
                    boolean asIntention = ES6ConvertLetToConstInspection.this.checkHighlightLevel(node);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.let.to.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(true).setForceFix(asIntention)});
                }
            }
        };
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/intentions/ES6ConvertLetToConstInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

