/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.unusedsymbols;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalCandidatesCollector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolCache;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedSymbolsVisitor;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedGlobalSymbolsPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile myFile;
    private final Queue<PsiElement> myUnusedSymbols;

    protected JSUnusedGlobalSymbolsPass(@NotNull PsiFile file2, @NotNull Document document2) {
        if (file2 == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), document2);
        this.myUnusedSymbols = new ConcurrentLinkedQueue<PsiElement>();
        this.myFile = file2;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        HighlightDisplayKey toolKey;
        if (progress == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(2);
        }
        if (!HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)this.myFile)) {
            return;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        if (!profile.isToolEnabled(toolKey = HighlightDisplayKey.find((String)JSUnusedGlobalSymbolsInspection.SHORT_NAME), (PsiElement)this.myFile) || profile.getErrorLevel(toolKey, (PsiElement)this.myFile) == HighlightDisplayLevel.DO_NOT_SHOW) {
            return;
        }
        JSUnusedGlobalSymbolsInspection tool = (JSUnusedGlobalSymbolsInspection)profile.getUnwrappedTool(JSUnusedGlobalSymbolsInspection.SHORT_NAME, (PsiElement)this.myFile);
        if (tool == null) {
            return;
        }
        THashSet candidates = new THashSet();
        JSUnusedGlobalCandidatesCollector collector = new JSUnusedGlobalCandidatesCollector((Set<? super PsiElement>)candidates, tool);
        for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)this.myFile)) {
            element.accept((PsiElementVisitor)collector);
        }
        JSUnusedGlobalSymbolsPass.searchForUnusedSymbols(this.myFile, (Set<PsiElement>)candidates, this.myUnusedSymbols);
    }

    public static void searchForUnusedSymbols(@NotNull PsiFile file2, @NotNull Set<PsiElement> candidates, @NotNull Queue<PsiElement> outUnusedSymbols) {
        if (file2 == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(3);
        }
        if (candidates == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(4);
        }
        if (outUnusedSymbols == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(5);
        }
        UnusedElementsData unusedElementsData = new UnusedElementsData(file2);
        JSUnusedSymbolsVisitor inspectionVisitor = new JSUnusedSymbolsVisitor(unusedElementsData::addProcessedCandidate);
        for (PsiElement candidate : candidates) {
            candidate.accept((PsiElementVisitor)inspectionVisitor);
        }
        unusedElementsData.searchForCandidateReferencingFiles();
        unusedElementsData.searchInCandidateFiles();
        unusedElementsData.fillElementsToReport(outUnusedSymbols);
    }

    @NotNull
    private static Set<String> getNamesToSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(6);
        }
        String candidateName = null;
        if (ES6PsiUtil.getDefaultElement(elementToSearch) != null) {
            PsiDirectory directory;
            PsiFile file2 = elementToSearch.getContainingFile();
            String nameWithoutExtension = JSFileReference.getFileNameWithoutExtension(file2.getName(), JSFileReference.IMPLICIT_EXTENSIONS);
            if ("index".equals(nameWithoutExtension) && (directory = file2.getContainingDirectory()) != null) {
                Set set = ContainerUtil.set((Object[])new String[]{nameWithoutExtension, directory.getName()});
                if (set == null) {
                    JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(7);
                }
                return set;
            }
            Set<String> set = Collections.singleton(nameWithoutExtension);
            if (set == null) {
                JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(8);
            }
            return set;
        }
        if (elementToSearch instanceof JSNamedElement) {
            candidateName = ((JSNamedElement)elementToSearch).getName();
        } else if (elementToSearch instanceof ES6ImportSpecifier) {
            candidateName = ((ES6ImportSpecifier)elementToSearch).getReferenceName();
        } else {
            Logger.getInstance(JSUnusedSymbolsVisitor.class).error("Unknown element passed: " + elementToSearch.getClass().getSimpleName());
        }
        Set<String> set = candidateName != null ? Collections.singleton(candidateName) : Collections.emptySet();
        if (set == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Nullable
    public static GlobalSearchScope getScopeForSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(10);
        }
        Project project = elementToSearch.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile file2 = elementToSearch.getContainingFile().getVirtualFile();
        if (file2 == null || projectFileIndex.isInLibrary(file2) || JSLibraryUtil.isProbableLibraryFile(file2, project)) {
            return null;
        }
        SearchScope scope = elementToSearch.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        if (!GlobalSearchScope.allScope((Project)project).contains(file2)) {
            return null;
        }
        return (GlobalSearchScope)scope;
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        TextRange dirtyScope = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).getFileStatusMap().getFileDirtyScope(this.myDocument, this.getId());
        if (dirtyScope == null) {
            return;
        }
        final ArrayList infos = new ArrayList(this.myUnusedSymbols.size());
        JSAnnotatorProblemReporter reporter = new JSAnnotatorProblemReporter(this.myFile){

            @Override
            protected void createAnnotation(@NotNull TextRange range, @NotNull String message, @NotNull ProblemHighlightType type, @Nullable HighlightDisplayKey displayKey, @NotNull HighlightSeverity severity, @Nullable ProblemGroup problemGroup, @NotNull List<? extends IntentionAction> fixesToRegister) {
                HighlightInfo info;
                if (range == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (severity == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (fixesToRegister == null) {
                    1.$$$reportNull$$$0(4);
                }
                HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)JSUnusedGlobalSymbolsPass.this.myProject));
                HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(range).severity(severity).descriptionAndTooltip(message);
                if (problemGroup != null) {
                    builder.problemGroup(problemGroup);
                }
                if ((info = builder.create()) != null) {
                    for (IntentionAction intentionAction : fixesToRegister) {
                        info.registerFix(intentionAction, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)displayKey), range, displayKey);
                    }
                    infos.add(info);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "range";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "severity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixesToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolsPass$1";
                objectArray[2] = "createAnnotation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement unusedSymbol : this.myUnusedSymbols) {
            JSUnusedSymbolProblemDescriptor descriptor2 = JSUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
            if (descriptor2 == null) continue;
            reporter.registerProblem(descriptor2.myIdentifier, descriptor2.myRange, descriptor2.myMessage, ProblemHighlightType.LIKE_UNUSED_SYMBOL, JSUnusedGlobalSymbolsInspection.SHORT_NAME, descriptor2.myFixes, IntentionAction.EMPTY_ARRAY);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)dirtyScope.getStartOffset(), (int)dirtyScope.getEndOffset(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private static boolean isToSkipFromUnused(PsiElement element) {
        return element instanceof TypeScriptInterface && "ImportMeta".equals(((TypeScriptInterface)element).getName());
    }

    @Nullable
    public static JSUnusedSymbolProblemDescriptor registerProblem(@NotNull PsiElement element) {
        PsiElement nameIdentifier;
        if (element == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(11);
        }
        if (JSUnusedGlobalSymbolsPass.isToSkipFromUnused(element)) {
            return null;
        }
        TextRange textRange = null;
        if (element instanceof JSNamedElement) {
            nameIdentifier = ((JSNamedElement)element).getNameIdentifier();
        } else {
            nameIdentifier = element;
            if (nameIdentifier instanceof ES6ExportDefaultAssignment) {
                textRange = JSUnusedGlobalSymbolsPass.exportDefaultHighlightRangeCorrection(element);
            }
        }
        if (nameIdentifier == null) {
            return null;
        }
        FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(new JSNamedElementPresenter(element).describeWithShortName());
        fix.registerElementRefForFix(nameIdentifier, null);
        LocalQuickFix[] fixes = new LocalQuickFix[]{fix};
        String message = JSUnusedLocalSymbolsInspection.unusedMessage(element);
        if (element.getParent() instanceof ES6ExportDefaultAssignment || element instanceof ES6ExportDefaultAssignment || element instanceof ES6ExportSpecifier) {
            message = message.replace("#ref", "").trim();
        }
        return new JSUnusedSymbolProblemDescriptor(nameIdentifier, textRange, message, fixes);
    }

    private static TextRange exportDefaultHighlightRangeCorrection(@NotNull PsiElement element) {
        if (element == null) {
            JSUnusedGlobalSymbolsPass.$$$reportNull$$$0(12);
        }
        ASTNode node = element.getNode();
        ASTNode exportNode = node.findChildByType(JSTokenTypes.EXPORT_KEYWORD);
        ASTNode defaultNode = node.findChildByType(JSTokenTypes.DEFAULT_KEYWORD);
        if (exportNode != null && defaultNode != null && exportNode.getStartOffset() < defaultNode.getStartOffset()) {
            return TextRange.create((int)exportNode.getTextRange().getStartOffset(), (int)defaultNode.getTextRange().getEndOffset());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outUnusedSymbols";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolsPass";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolsPass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "searchForUnusedSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamesToSearch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForSearch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportDefaultHighlightRangeCorrection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnusedElementsData {
        private final BidirectionalMultiMap<PsiElement, PsiElement> processedCandidates;
        private final MultiMap<VirtualFile, PsiElement> candidateReferencingFiles;
        private final Set<PsiElement> definitelyUnusedElementsToReport;
        @NotNull
        private final PsiFile myFile;

        UnusedElementsData(@NotNull PsiFile baseFile) {
            if (baseFile == null) {
                UnusedElementsData.$$$reportNull$$$0(0);
            }
            this.processedCandidates = new BidirectionalMultiMap();
            this.candidateReferencingFiles = MultiMap.create();
            this.definitelyUnusedElementsToReport = new HashSet<PsiElement>();
            this.myFile = baseFile;
        }

        void addProcessedCandidate(@NotNull PsiElement elementToSearch, @NotNull PsiElement elementToReport) {
            if (elementToSearch == null) {
                UnusedElementsData.$$$reportNull$$$0(1);
            }
            if (elementToReport == null) {
                UnusedElementsData.$$$reportNull$$$0(2);
            }
            this.processedCandidates.put((Object)elementToReport, (Object)elementToSearch);
        }

        void searchForCandidateReferencingFiles() {
            HashSet<PsiElement> definitelyUsedElementsToReport = new HashSet<PsiElement>();
            block0: for (PsiElement elementToReport : this.processedCandidates.getKeys()) {
                boolean hasFilesToCheck = false;
                for (PsiElement elementToSearch : this.processedCandidates.getValues((Object)elementToReport)) {
                    ThreeState isUsed = JSUnusedGlobalSymbolCache.isUsedImplicitlyOrFromCache(elementToSearch);
                    if (isUsed == ThreeState.YES) {
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue block0;
                    }
                    if (isUsed == ThreeState.NO && (elementToSearch = UnusedElementsData.substituteForStaticTsMember(elementToSearch)) == null) continue;
                    PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)elementToSearch.getProject());
                    GlobalSearchScope scope = JSUnusedGlobalSymbolsPass.getScopeForSearch(elementToSearch);
                    if (scope == null) {
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue block0;
                    }
                    Set names = JSUnusedGlobalSymbolsPass.getNamesToSearch(elementToSearch);
                    if (names.isEmpty()) {
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue block0;
                    }
                    for (String name : names) {
                        if (helper.isCheapEnoughToSearch(name, scope, this.myFile, null) != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) continue;
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue block0;
                    }
                    hasFilesToCheck = true;
                    for (String name : names) {
                        PsiElement finalElementToSearch = elementToSearch;
                        helper.processCandidateFilesForText(scope, (short)255, true, name, virtualFile -> {
                            this.candidateReferencingFiles.putValue(virtualFile, (Object)finalElementToSearch);
                            return true;
                        });
                    }
                }
                if (hasFilesToCheck) continue;
                this.definitelyUnusedElementsToReport.add(elementToReport);
            }
            this.removeCandidateElementsToReport(this.definitelyUnusedElementsToReport);
            this.removeCandidateElementsToReport(definitelyUsedElementsToReport);
        }

        private void removeCandidateElementsToReport(@NotNull Collection<PsiElement> elementsToReport) {
            if (elementsToReport == null) {
                UnusedElementsData.$$$reportNull$$$0(3);
            }
            for (PsiElement elementToReport : elementsToReport) {
                this.processedCandidates.removeKey((Object)elementToReport);
            }
        }

        void searchInCandidateFiles() {
            for (Map.Entry entry : this.candidateReferencingFiles.entrySet()) {
                PsiFile psiFile;
                VirtualFile candidateReferencingFile = (VirtualFile)entry.getKey();
                Collection elementsToSearch = (Collection)entry.getValue();
                elementsToSearch.retainAll(this.processedCandidates.getValues());
                if (elementsToSearch.isEmpty() || (psiFile = this.myFile.getManager().findFile(candidateReferencingFile)) == null) continue;
                GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)psiFile);
                for (PsiElement elementToSearch : elementsToSearch) {
                    PsiReference reference = JSUnusedGlobalSymbolCache.findAnyReference(elementToSearch, (SearchScope)fileScope);
                    if (reference != null) {
                        this.removeCandidateElementsToReport(new ArrayList<PsiElement>(this.processedCandidates.getKeys((Object)elementToSearch)));
                        JSUnusedGlobalSymbolCache.saveFoundReference(reference, elementToSearch);
                        continue;
                    }
                    if (this.handleSubstitutedElement(elementToSearch, fileScope, (NullableFunction<PsiElement, PsiElement>)((NullableFunction)UnusedElementsData::substituteForStaticTsMember), (Condition<PsiReference>)((Condition)UnusedElementsData::isOwnStaticAccess))) continue;
                    this.handleSubstitutedElement(elementToSearch, fileScope, (NullableFunction<PsiElement, PsiElement>)((NullableFunction)UnusedElementsData::substituteForExportDefault), (Condition<PsiReference>)((Condition)UnusedElementsData::isDynamicWholeModuleImport));
                }
            }
            for (PsiElement elementToSearch : this.processedCandidates.getValues()) {
                JSUnusedGlobalSymbolCache.saveFoundReference(null, elementToSearch);
            }
        }

        private boolean handleSubstitutedElement(PsiElement elementToSearch, GlobalSearchScope fileScope, NullableFunction<PsiElement, PsiElement> substitute, Condition<PsiReference> isAcceptableReference) {
            PsiElement adjusted = (PsiElement)substitute.fun((Object)elementToSearch);
            if (adjusted == null) {
                return false;
            }
            PsiReference anyReference = JSUnusedGlobalSymbolCache.findAnyReference(adjusted, (SearchScope)fileScope);
            if (anyReference != null && isAcceptableReference.value((Object)anyReference)) {
                this.removeCandidateElementsToReport(new ArrayList<PsiElement>(this.processedCandidates.getKeys((Object)elementToSearch)));
                JSUnusedGlobalSymbolCache.saveFoundReference(anyReference, elementToSearch);
            }
            return true;
        }

        @Nullable
        private static PsiElement substituteForStaticTsMember(@Nullable PsiElement elementToSearch) {
            JSAttributeList list2;
            if (elementToSearch instanceof JSAttributeListOwner && (list2 = ((JSAttributeListOwner)elementToSearch).getAttributeList()) != null && list2.getAccessType() == JSAttributeList.AccessType.PUBLIC && list2.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return JSResolveUtil.getClassOfContext(elementToSearch);
            }
            return null;
        }

        private static boolean isOwnStaticAccess(@NotNull PsiReference reference) {
            if (reference == null) {
                UnusedElementsData.$$$reportNull$$$0(4);
            }
            if (reference instanceof JSReferenceExpression) {
                PsiElement parent = ((JSReferenceExpression)reference).getContext();
                if (parent instanceof JSCallLikeExpression) {
                    return false;
                }
                if (parent instanceof JSReferenceExpression) {
                    return ((JSReferenceExpression)parent).getQualifier() != reference;
                }
                return true;
            }
            return false;
        }

        @Nullable
        private static PsiElement substituteForExportDefault(@Nullable PsiElement elementToSearch) {
            return elementToSearch instanceof ES6ExportDefaultAssignment ? elementToSearch.getContainingFile() : null;
        }

        private static boolean isDynamicWholeModuleImport(@NotNull PsiReference reference) {
            PsiElement parent;
            PsiElement element;
            if (reference == null) {
                UnusedElementsData.$$$reportNull$$$0(5);
            }
            if ((element = reference.getElement()) instanceof JSLiteralExpression && ((parent = (PsiElement)ObjectUtils.coalesce((Object)JSUtils.findCallExprByArg(element), (Object)element.getParent())) instanceof JSCallExpression && ((JSCallExpression)parent).isRequireCall() || parent instanceof ES6ImportCall)) {
                PsiElement importTarget = JSUtils.getParentSkipParentheses(parent);
                if (parent instanceof ES6ImportCall && ES6PsiUtil.isAwaitExpression(importTarget)) {
                    importTarget = importTarget.getParent();
                }
                return !(importTarget instanceof JSExpressionStatement);
            }
            return false;
        }

        void fillElementsToReport(@NotNull Collection<PsiElement> outElementsToReport) {
            if (outElementsToReport == null) {
                UnusedElementsData.$$$reportNull$$$0(6);
            }
            outElementsToReport.addAll(this.definitelyUnusedElementsToReport);
            outElementsToReport.addAll(this.processedCandidates.getKeys());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReport";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsToReport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outElementsToReport";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolsPass$UnusedElementsData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addProcessedCandidate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCandidateElementsToReport";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOwnStaticAccess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDynamicWholeModuleImport";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillElementsToReport";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class JSUnusedSymbolProblemDescriptor {
        @NotNull
        public final PsiElement myIdentifier;
        @Nullable
        public final TextRange myRange;
        @NotNull
        public final String myMessage;
        public final LocalQuickFix @NotNull [] myFixes;

        public JSUnusedSymbolProblemDescriptor(@NotNull PsiElement nameIdentifier, @Nullable TextRange textRange, @NotNull String message, LocalQuickFix @NotNull [] fixes) {
            if (nameIdentifier == null) {
                JSUnusedSymbolProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                JSUnusedSymbolProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                JSUnusedSymbolProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myIdentifier = nameIdentifier;
            this.myRange = textRange;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nameIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedGlobalSymbolsPass$JSUnusedSymbolProblemDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

