/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringConcatenationToES6TemplateInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                IElementType sign = node.getOperationSign();
                if (sign != JSTokenTypes.PLUS) {
                    return;
                }
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.STRING_TEMPLATES)) {
                    return;
                }
                PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)node);
                if (parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.PLUS) {
                    return;
                }
                Unit unit = JSStringConcatenationToES6TemplateInspection.processExpression((JSExpression)node);
                if (!unit.operands.isEmpty() && unit.canEvaluateToString) {
                    ProblemHighlightType severity = null;
                    if (unit.hasInterestingParts) {
                        severity = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    } else if (holder.isOnTheFly()) {
                        severity = ProblemHighlightType.INFORMATION;
                    }
                    if (severity != null) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.replace.string.concatenation.with.es6.template.inspection.name", (Object[])new Object[0]), severity, new LocalQuickFix[]{new ReplaceWithTemplateFix((JSExpression)node)});
                    }
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                super.visitJSLiteralExpression(node);
                if (!node.isStringLiteral() || node.getParent() instanceof TypeScriptLiteralType || !DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.STRING_TEMPLATES) || !holder.isOnTheFly()) {
                    return;
                }
                PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)node);
                if (parent instanceof JSBinaryExpression) {
                    return;
                }
                holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.replace.string.concatenation.with.es6.template.fix.text", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ReplaceWithTemplateFix((JSExpression)node)});
            }
        };
    }

    @NotNull
    private static Unit processExpression(@Nullable JSExpression expression) {
        return JSStringConcatenationToES6TemplateInspection.doProcessExpression(expression, 0);
    }

    @NotNull
    private static Unit doProcessExpression(@Nullable JSExpression expression, int depth) {
        IElementType sign;
        if (depth >= JavaScriptParserBase.MAX_TREE_DEPTH) {
            Unit unit = Unit.EMPTY;
            if (unit == null) {
                JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(2);
            }
            return unit;
        }
        ++depth;
        if (expression instanceof JSLiteralExpression) {
            if (expression.getParent() instanceof TypeScriptLiteralType) {
                Unit unit = Unit.EMPTY;
                if (unit == null) {
                    JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(3);
                }
                return unit;
            }
            if (((JSLiteralExpression)expression).isQuotedLiteral()) {
                return new Unit(expression, false, true);
            }
            if (((JSLiteralExpression)expression).isNumericLiteral()) {
                return new Unit(expression, true, false);
            }
        }
        if (expression instanceof JSParenthesizedExpression) {
            return JSStringConcatenationToES6TemplateInspection.doProcessExpression(JSUtils.unparenthesize(expression), depth);
        }
        if (expression instanceof JSConditionalExpression) {
            Unit then = JSStringConcatenationToES6TemplateInspection.doProcessExpression(((JSConditionalExpression)expression).getThen(), depth);
            Unit elseResult = JSStringConcatenationToES6TemplateInspection.doProcessExpression(((JSConditionalExpression)expression).getElse(), depth);
            return new Unit(expression, then.hasInterestingParts || elseResult.hasInterestingParts, then.canEvaluateToString || elseResult.canEvaluateToString);
        }
        if (expression instanceof JSBinaryExpression && (sign = ((JSBinaryExpression)expression).getOperationSign()) == JSTokenTypes.PLUS) {
            boolean isDynamic;
            JSExpression leftExpression = ((JSBinaryExpression)expression).getLOperand();
            JSExpression rightExpression = ((JSBinaryExpression)expression).getROperand();
            Unit left = JSStringConcatenationToES6TemplateInspection.doProcessExpression(leftExpression, depth);
            Unit right = JSStringConcatenationToES6TemplateInspection.doProcessExpression(rightExpression, depth);
            boolean bl = isDynamic = left.hasInterestingParts || right.hasInterestingParts;
            if (!left.canEvaluateToString && !right.canEvaluateToString) {
                return new Unit(expression, isDynamic, false);
            }
            return new Unit(ContainerUtil.concat(left.operands, right.operands), isDynamic, true);
        }
        return new Unit(ContainerUtil.createMaybeSingletonList((Object)expression), JSStringConcatenationToES6TemplateInspection.isDynamicExpression(expression), false);
    }

    private static boolean isDynamicExpression(@Nullable JSExpression expression) {
        if (expression instanceof JSReferenceExpression || expression instanceof JSCallExpression || expression instanceof JSIndexedPropertyAccessExpression) {
            return true;
        }
        if (expression instanceof JSPrefixExpression) {
            return JSStringConcatenationToES6TemplateInspection.isDynamicExpression(((JSPrefixExpression)expression).getExpression());
        }
        if (expression instanceof JSParenthesizedExpression) {
            return JSStringConcatenationToES6TemplateInspection.isDynamicExpression(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSBinaryExpression) {
            return JSStringConcatenationToES6TemplateInspection.isDynamicExpression(((JSBinaryExpression)expression).getLOperand()) || JSStringConcatenationToES6TemplateInspection.isDynamicExpression(((JSBinaryExpression)expression).getROperand());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithTemplateFix
    extends LocalQuickFixOnPsiElement
    implements PriorityAction {
        private final PriorityAction.Priority myPriority;

        private ReplaceWithTemplateFix(@NotNull JSExpression node) {
            if (node == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)node);
            this.myPriority = node instanceof JSBinaryExpression ? PriorityAction.Priority.HIGH : PriorityAction.Priority.NORMAL;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"js.replace.string.concatenation.with.es6.template.fix.text", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(3);
            }
            return priority;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSExpression expression;
            if (project == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(4);
            }
            if (file2 == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(6);
            }
            if (endElement == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(7);
            }
            if ((expression = (JSExpression)ObjectUtils.tryCast((Object)startElement, JSExpression.class)) == null) {
                return;
            }
            List<JSExpression> operands = JSStringConcatenationToES6TemplateInspection.processExpression((JSExpression)expression).operands;
            JSStringTemplateExpression replacementPsi = JSPsiElementFactory.createJSExpression(ReplaceWithTemplateFix.getReplacementText(operands), (PsiElement)expression, JSStringTemplateExpression.class);
            expression.replace((JSExpression)replacementPsi);
        }

        private static String getReplacementText(@NotNull List<JSExpression> operands) {
            if (operands == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(8);
            }
            StringBuilder result2 = new StringBuilder();
            result2.append('`');
            THashSet processedComments = new THashSet();
            ArrayList<PsiElement> commentsBefore = new ArrayList<PsiElement>();
            ArrayList<PsiElement> commentsAfter = new ArrayList<PsiElement>();
            for (JSExpression operand : operands) {
                if ((operand = JSUtils.unparenthesize(operand)) == null) continue;
                ReplaceWithTemplateFix.collectComments(operands, operand, (THashSet<PsiElement>)processedComments, commentsBefore, commentsAfter);
                if (operand instanceof JSStringTemplateExpression) {
                    result2.append(StringUtil.unquoteString((String)operand.getText(), (char)'`'));
                } else if (operand instanceof JSLiteralExpression) {
                    Object value = ((JSLiteralExpression)operand).getValue();
                    if (value != null) {
                        result2.append(ReplaceWithTemplateFix.escapeForTemplateString(value.toString()));
                    }
                } else {
                    ReplaceWithTemplateFix.appendArgument(result2, operand, commentsBefore, commentsAfter);
                }
                commentsBefore.addAll(commentsAfter);
                commentsAfter.clear();
            }
            result2.append('`');
            return result2.toString();
        }

        private static void collectComments(@NotNull List<JSExpression> operands, @NotNull JSExpression operand, @NotNull THashSet<PsiElement> processedComments, @NotNull List<PsiElement> commentsBefore, @NotNull List<PsiElement> commentsAfter) {
            if (operands == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(9);
            }
            if (operand == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(10);
            }
            if (processedComments == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(11);
            }
            if (commentsBefore == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(12);
            }
            if (commentsAfter == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(13);
            }
            if (operand != ContainerUtil.getFirstItem(operands)) {
                commentsBefore.addAll(ReplaceWithTemplateFix.collectComments(operand, processedComments, false));
            }
            if (operand != ContainerUtil.getLastItem(operands)) {
                commentsAfter.addAll(ReplaceWithTemplateFix.collectComments(operand, processedComments, true));
            }
        }

        @NotNull
        private static List<PsiElement> collectComments(@NotNull JSExpression expression, @NotNull THashSet<PsiElement> processedComments, boolean forward) {
            if (expression == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(14);
            }
            if (processedComments == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(15);
            }
            ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
            PsiElement current = ReplaceWithTemplateFix.getNextElement((PsiElement)expression, forward);
            while (current instanceof PsiWhiteSpace || current instanceof PsiComment || current != null && current.getNode().getElementType() == JSTokenTypes.PLUS) {
                PsiElement next = ReplaceWithTemplateFix.getNextElement(current, forward);
                if (current instanceof PsiComment && !processedComments.contains((Object)current)) {
                    comments.add(current);
                    processedComments.add((Object)current);
                    if (next instanceof PsiWhiteSpace) {
                        comments.add(next);
                    }
                }
                current = next;
            }
            ArrayList<PsiElement> arrayList = comments;
            if (arrayList == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(16);
            }
            return arrayList;
        }

        @Nullable
        private static PsiElement getNextElement(@NotNull PsiElement element, boolean forward) {
            if (element == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(17);
            }
            return forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        }

        private static void appendArgument(@NotNull StringBuilder result2, @NotNull JSExpression expression, @NotNull List<PsiElement> commentsBefore, @NotNull List<PsiElement> commentsAfter) {
            if (result2 == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(18);
            }
            if (expression == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(19);
            }
            if (commentsBefore == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(20);
            }
            if (commentsAfter == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(21);
            }
            result2.append("${");
            for (PsiElement comment : commentsBefore) {
                result2.append(comment.getText());
            }
            result2.append(expression.getText());
            for (PsiElement comment : commentsAfter) {
                result2.append(comment.getText());
            }
            commentsBefore.clear();
            commentsAfter.clear();
            result2.append("}");
        }

        @NotNull
        private static String escapeForTemplateString(@NotNull String text) {
            if (text == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(22);
            }
            StringBuilder result2 = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(text, '`', false, true, true, result2);
            String string = result2.toString();
            if (string == null) {
                ReplaceWithTemplateFix.$$$reportNull$$$0(23);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection$ReplaceWithTemplateFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operands";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processedComments";
                    break;
                }
                case 12: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentsBefore";
                    break;
                }
                case 13: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentsAfter";
                    break;
                }
                case 14: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection$ReplaceWithTemplateFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectComments";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeForTemplateString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 23: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getReplacementText";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "collectComments";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getNextElement";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "appendArgument";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeForTemplateString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 16: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Unit {
        @NotNull
        final List<JSExpression> operands;
        final boolean hasInterestingParts;
        final boolean canEvaluateToString;
        static Unit EMPTY = new Unit(ContainerUtil.emptyList(), false, false);

        private Unit(@NotNull List<JSExpression> operands, boolean hasInterestingParts, boolean canEvaluateToString) {
            if (operands == null) {
                Unit.$$$reportNull$$$0(0);
            }
            this.operands = operands;
            this.hasInterestingParts = hasInterestingParts;
            this.canEvaluateToString = canEvaluateToString;
        }

        private Unit(@NotNull JSExpression operand, boolean dynamic, boolean canEvaluateToString) {
            if (operand == null) {
                Unit.$$$reportNull$$$0(1);
            }
            this((List<JSExpression>)new SmartList((Object)operand), dynamic, canEvaluateToString);
        }

        public String toString() {
            return "Unit{operands=" + this.operands + ", hasInterestingParts=" + this.hasInterestingParts + ", evaluatesToString=" + this.canEvaluateToString + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operands";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operand";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection$Unit";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

