/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJoinVariableDeclarationAndAssignmentInspection
extends JSInspection {
    private final boolean myForceShow;

    public JSJoinVariableDeclarationAndAssignmentInspection() {
        this(false);
    }

    public JSJoinVariableDeclarationAndAssignmentInspection(boolean forceShow) {
        this.myForceShow = forceShow;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSJoinVariableDeclarationAndAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSJoinVariableDeclarationAndAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSVarStatement(JSVarStatement node) {
                for (JSVariable variable : node.getVariables()) {
                    this.processJSVariable(variable, node);
                }
                super.visitJSVarStatement(node);
            }

            private void processJSVariable(@NotNull JSVariable node, @NotNull JSVarStatement statement) {
                PsiElement identifier;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((identifier = node.getNameIdentifier()) != null && node.getInitializer() == null && !JSDestructuringUtil.isDestructuring(node.getParent())) {
                    boolean single = statement.getVariables().length == 1;
                    MultiMap scopesToRefs = MultiMap.create();
                    String name = node.getName();
                    PsiElement scope = node.getDeclarationScope();
                    if (name != null && scope != null) {
                        SyntaxTraverser.psiTraverser((PsiElement)scope).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() == null).filter(e -> name.equals(e.getReferenceName())).forEach(e -> {
                            JSElement blockScope = this.getScope((JSReferenceExpression)e, node);
                            if (blockScope != null && e.resolve() == node) {
                                scopesToRefs.putValue((Object)blockScope, e);
                            }
                        });
                        if (!scopesToRefs.isEmpty()) {
                            PsiElement scopeToMoveTo;
                            ArrayList<JSReferenceExpression> allRefs;
                            ArrayList<PsiElement> allScopes = new ArrayList<PsiElement>(scopesToRefs.keySet());
                            allScopes.sort(Comparator.comparing(s -> s.getTextOffset()));
                            if (this.areSatisfiableScopes(allScopes) && !(allRefs = new ArrayList<JSReferenceExpression>(scopesToRefs.get((Object)(scopeToMoveTo = (PsiElement)allScopes.get(0))))).isEmpty()) {
                                allRefs.sort(Comparator.comparing(s -> s.getTextOffset()));
                                JSReferenceExpression reference = this.findReference(allRefs, DialectDetector.isActionScript((PsiElement)node));
                                if (reference != null) {
                                    ASTNode varModifier = statement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
                                    TextRange range = single && varModifier != null ? new TextRange(varModifier.getStartOffset(), identifier.getTextRange().getEndOffset()).shiftLeft(statement.getTextOffset()) : identifier.getTextRange().shiftLeft((single ? statement : node).getTextOffset());
                                    holder.registerProblem((PsiElement)(single ? statement : node), JavaScriptBundle.message((String)"js.join.declaration.assignment.inspection.name", (Object[])new Object[0]), JSJoinVariableDeclarationAndAssignmentInspection.this.myForceShow ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, range, new LocalQuickFix[]{JSFixFactory.getInstance().createJoinDeclarationAndAssignmentFix(node, reference)});
                                }
                            }
                        }
                    }
                }
            }

            private JSReferenceExpression findReference(List<JSReferenceExpression> allRefs, boolean isActionScript) {
                if (!isActionScript) {
                    JSReferenceExpression reference = allRefs.get(0);
                    PsiElement parent = reference.getParent();
                    return parent instanceof JSDefinitionExpression || parent instanceof JSForInStatement ? reference : null;
                }
                for (JSReferenceExpression ref : allRefs) {
                    if (ref.getParent() instanceof JSVariable) continue;
                    if (ref.getParent() instanceof JSDefinitionExpression) {
                        return ref;
                    }
                    return null;
                }
                return null;
            }

            private boolean areSatisfiableScopes(List<PsiElement> scopes) {
                return this.allRangesIntersect(scopes.get(0), scopes);
            }

            private boolean allRangesIntersect(PsiElement scope, List<PsiElement> scopes) {
                TextRange scopeTextRange = scope.getTextRange();
                return scopes.stream().allMatch(s -> s == scope || s.getTextRange().intersects(scopeTextRange));
            }

            @Nullable
            private JSElement getScope(JSReferenceExpression e, JSVariable node) {
                if (node.hasBlockScope()) {
                    return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)e, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
                }
                return (JSElement)PsiTreeUtil.getContextOfType((PsiElement)e, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSJoinVariableDeclarationAndAssignmentInspection$1";
                objectArray[2] = "processJSVariable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSJoinVariableDeclarationAndAssignmentInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

