/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertLoopsUtils {
    @NotNull
    private static final String INDEXED_FOR_IN_TEXT = "for (let %s = 0; %s < %s; %s++){}";
    @NotNull
    private static final String FOR_OF_TEXT = "for (const %s of %s) {}";
    @NotNull
    private static final String INDEX_TEXT = "let %s = %s.indexOf(%s)%s";
    @NotNull
    private static final String ITEM_TEXT = "%s = %s[%s]%s";
    @NotNull
    private static final String IGNORED = "ignored";

    @NotNull
    private static JSLoopStatement getPlainIndexedForInStatement(@NotNull String collectionExpressionText, @NotNull String indexText, @NotNull PsiElement context) {
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(0);
        }
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(2);
        }
        String collectionExpressionLengthText = collectionExpressionText + ".length";
        String text = String.format(INDEXED_FOR_IN_TEXT, indexText, indexText, collectionExpressionLengthText, indexText);
        JSLoopStatement jSLoopStatement = (JSLoopStatement)JSPsiElementFactory.createJSStatement(text, context, JSForStatement.class);
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(3);
        }
        return jSLoopStatement;
    }

    @NotNull
    private static JSLoopStatement getPlainForInStatement(@NotNull String collectionExpressionText, @NotNull String itemText, @NotNull PsiElement context) {
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(4);
        }
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(6);
        }
        String text = String.format(FOR_OF_TEXT, itemText, collectionExpressionText);
        JSLoopStatement jSLoopStatement = (JSLoopStatement)JSPsiElementFactory.createJSStatement(text, context, JSForInStatement.class);
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(7);
        }
        return jSLoopStatement;
    }

    private static JSBlockStatement updateForInBody(@NotNull JSElement jsExpression, @NotNull JSFunction function2, @NotNull String itemText, @NotNull JSBlockStatement forOfBlockBody) {
        if (jsExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(8);
        }
        if (function2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(9);
        }
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(10);
        }
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(11);
        }
        if (jsExpression instanceof JSCallExpression) {
            if (((JSCallExpression)jsExpression).getArguments()[0] instanceof JSReferenceExpression) {
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)forOfBlockBody);
                String callText = String.format("%s(%s)%s", ((JSCallExpression)jsExpression).getArguments()[0].getText(), itemText, semicolon);
                JSStatement callStatement = JSPsiElementFactory.createJSStatement(callText, (PsiElement)jsExpression);
                JSChangeUtil.doAddAfter((PsiElement)forOfBlockBody, (PsiElement)callStatement, forOfBlockBody.getFirstChild());
            } else {
                forOfBlockBody = JSFunctionsRefactoringUtil.copyFunctionBody(function2, forOfBlockBody);
                JSConvertLoopsUtils.replaceReturnWithContinue(forOfBlockBody);
            }
        }
        return forOfBlockBody;
    }

    public static void addIndexStatementText(@NotNull String indexText, @NotNull String itemText, @NotNull String collectionExpressionText, @NotNull JSBlockStatement forOfBlockBody) {
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(12);
        }
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(13);
        }
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(14);
        }
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(15);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)forOfBlockBody);
        String indexStatementText = String.format(INDEX_TEXT, indexText, collectionExpressionText, itemText, semicolon);
        JSStatement indexStatement = JSPsiElementFactory.createJSStatement(indexStatementText, (PsiElement)forOfBlockBody);
        JSChangeUtil.doAddAfter((PsiElement)forOfBlockBody, (PsiElement)indexStatement, forOfBlockBody.getFirstChild());
    }

    public static void replaceReturnWithContinue(@NotNull JSBlockStatement forOfBlockBody) {
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(16);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)forOfBlockBody);
        for (JSReturnStatement returnStatement : JSConvertLoopsUtils.getReturnStatements(forOfBlockBody)) {
            JSExpression returnExpression = returnStatement.getExpression();
            if (returnExpression == null) {
                JSStatement breakStatement = JSPsiElementFactory.createJSStatement("continue" + semicolon, (PsiElement)returnStatement);
                returnStatement.replace(breakStatement);
                continue;
            }
            JSStatement expressionStatement = JSPsiElementFactory.createJSStatement(returnExpression.getText() + semicolon, (PsiElement)returnStatement);
            returnStatement.replace(expressionStatement);
        }
    }

    @NotNull
    private static Collection<JSReturnStatement> getReturnStatements(@NotNull JSBlockStatement forOfBlockBody) {
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(17);
        }
        final ArrayList<JSReturnStatement> returnStatements = new ArrayList<JSReturnStatement>();
        forOfBlockBody.accept((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                super.visitJSReturnStatement(node);
                returnStatements.add(node);
            }
        });
        ArrayList<JSReturnStatement> arrayList = returnStatements;
        if (arrayList == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static void addItemStatementText(@NotNull String itemText, @NotNull String indexText, @NotNull String collectionExpressionText, @NotNull JSStatement forOfBlockBody, boolean needLetKeyword) {
        if (itemText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(19);
        }
        if (indexText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(20);
        }
        if (collectionExpressionText == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(21);
        }
        if (forOfBlockBody == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(22);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)forOfBlockBody);
        String declarationText = needLetKeyword ? "let %s = %s[%s]%s" : ITEM_TEXT;
        String itemStatementText = String.format(declarationText, itemText, collectionExpressionText, indexText, semicolon);
        JSStatement itemStatement = JSPsiElementFactory.createJSStatement(itemStatementText, (PsiElement)forOfBlockBody);
        JSChangeUtil.doAddAfter((PsiElement)forOfBlockBody, (PsiElement)itemStatement, forOfBlockBody.getFirstChild());
    }

    @Nullable
    private static JSExpression getCollectionExpression(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(23);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        JSExpression collectionExpression = referenceExpression.getQualifier();
        if (collectionExpression == null) {
            return null;
        }
        return collectionExpression;
    }

    @Nullable
    public static JSFunction getFunction(@NotNull JSCallExpression callExpression) {
        JSExpression argument;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(24);
        }
        if ((argument = callExpression.getArguments()[0]) instanceof JSFunctionExpression) {
            return (JSFunction)argument;
        }
        if (argument instanceof JSReferenceExpression) {
            return JSPsiImplUtils.getPossibleFunction(((JSReferenceExpression)argument).resolve());
        }
        return null;
    }

    public static boolean isForEachCall(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(25);
        }
        return (methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && callExpression.getArguments().length == 1;
    }

    @NotNull
    public static JSStatement getIndexedStatementFromForOf(@NotNull JSForInStatement forInStatement) {
        String itemText;
        JSExpression collectionExpression;
        if (forInStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(26);
        }
        if ((collectionExpression = forInStatement.getCollectionExpression()) == null) {
            JSForInStatement jSForInStatement = forInStatement;
            if (jSForInStatement == null) {
                JSConvertLoopsUtils.$$$reportNull$$$0(27);
            }
            return jSForInStatement;
        }
        JSStatement oldBodyBlock = forInStatement.getBody();
        if (oldBodyBlock == null) {
            JSForInStatement jSForInStatement = forInStatement;
            if (jSForInStatement == null) {
                JSConvertLoopsUtils.$$$reportNull$$$0(28);
            }
            return jSForInStatement;
        }
        String collectionExpressionText = collectionExpression.getText();
        JSVarStatement declarationStatement = forInStatement.getVarDeclaration();
        boolean needLetKeyword = true;
        if (declarationStatement == null) {
            JSExpression variableExpression = forInStatement.getVariableExpression();
            if (variableExpression == null) {
                JSForInStatement jSForInStatement = forInStatement;
                if (jSForInStatement == null) {
                    JSConvertLoopsUtils.$$$reportNull$$$0(29);
                }
                return jSForInStatement;
            }
            itemText = variableExpression.getText();
            needLetKeyword = false;
        } else {
            itemText = declarationStatement.getDeclarations()[0].getText();
        }
        String indexTextWithoutType = JSNameSuggestionsUtil.ensureUniqueVariableName("i", (PsiElement)forInStatement, new HashSet<String>(), false);
        JSLoopStatement plainIndexedForInStatement = JSConvertLoopsUtils.getPlainIndexedForInStatement(collectionExpressionText, indexTextWithoutType, (PsiElement)forInStatement);
        JSStatement forOfBlockBody = plainIndexedForInStatement.getBody();
        assert (forOfBlockBody != null);
        forOfBlockBody = JSChangeUtil.replaceStatement(forOfBlockBody, (JSStatement)oldBodyBlock.copy());
        JSConvertLoopsUtils.addItemStatementText(itemText, indexTextWithoutType, collectionExpressionText, forOfBlockBody, needLetKeyword);
        JSLoopStatement jSLoopStatement = plainIndexedForInStatement;
        if (jSLoopStatement == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(30);
        }
        return jSLoopStatement;
    }

    @Nullable
    public static JSStatement getForInStatementFromCall(@NotNull JSCallExpression callExpression, @NotNull JSFunction function2, @NotNull LoopType loopType) {
        JSLoopStatement plainForInStatement;
        JSExpression expression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(31);
        }
        if (function2 == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(32);
        }
        if (loopType == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(33);
        }
        JSParameterListElement[] parameters = function2.getParameters();
        ArrayList<String> callArgsForReferenceFunction = new ArrayList<String>();
        boolean hasItemText = parameters.length > 0;
        boolean hasIndexText = parameters.length > 1;
        String itemTextWithType = IGNORED;
        String itemTextWithoutType = IGNORED;
        if (hasItemText) {
            JSParameterListElement item = parameters[0];
            itemTextWithType = item.getText();
            itemTextWithoutType = item.getName() == null ? itemTextWithType : item.getName();
            callArgsForReferenceFunction.add(itemTextWithoutType);
        }
        String indexTextWithType = "i";
        String indexTextWithoutType = "i";
        if (hasIndexText) {
            JSParameterListElement index = parameters[1];
            indexTextWithType = index.getText();
            indexTextWithoutType = index.getName() == null ? indexTextWithType : index.getName();
            callArgsForReferenceFunction.add(indexTextWithoutType);
        }
        if ((expression = JSConvertLoopsUtils.getCollectionExpression(callExpression)) == null) {
            return null;
        }
        String collectionExpressionText = expression.getText();
        switch (loopType) {
            case FOR_OF: {
                plainForInStatement = JSConvertLoopsUtils.getPlainForInStatement(collectionExpressionText, itemTextWithoutType, (PsiElement)function2);
                break;
            }
            case INDEXED: {
                plainForInStatement = JSConvertLoopsUtils.getPlainIndexedForInStatement(collectionExpressionText, indexTextWithoutType, (PsiElement)function2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)loopType));
            }
        }
        JSBlockStatement forOfBlockBody = (JSBlockStatement)plainForInStatement.getBody();
        assert (forOfBlockBody != null);
        String args = String.join((CharSequence)",", callArgsForReferenceFunction);
        forOfBlockBody = JSConvertLoopsUtils.updateForInBody((JSElement)callExpression, function2, args, forOfBlockBody);
        if (hasIndexText && loopType == LoopType.FOR_OF) {
            JSConvertLoopsUtils.addIndexStatementText(indexTextWithType, itemTextWithoutType, collectionExpressionText, forOfBlockBody);
        }
        if (hasItemText && loopType == LoopType.INDEXED) {
            JSConvertLoopsUtils.addItemStatementText(itemTextWithType, indexTextWithoutType, collectionExpressionText, (JSStatement)forOfBlockBody, true);
        }
        return plainForInStatement;
    }

    public static boolean isObjectLiteral(@NotNull JSExpression jsExpression) {
        if (jsExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(34);
        }
        if (jsExpression instanceof JSObjectLiteralExpression) {
            return true;
        }
        if (!(jsExpression instanceof JSReferenceExpressionImpl)) {
            return false;
        }
        PsiElement resolve = ((JSReferenceExpressionImpl)jsExpression).resolve();
        if (!(resolve instanceof JSVariable)) {
            return false;
        }
        JSExpression initializer = ((JSVariable)resolve).getInitializer();
        return initializer instanceof JSObjectLiteralExpression;
    }

    public static boolean isCallExpressionObjectLiteral(@NotNull JSCallExpression callExpression) {
        JSExpression collectionExpression;
        if (callExpression == null) {
            JSConvertLoopsUtils.$$$reportNull$$$0(35);
        }
        if ((collectionExpression = JSConvertLoopsUtils.getCollectionExpression(callExpression)) == null) {
            return false;
        }
        return JSConvertLoopsUtils.isObjectLiteral(collectionExpression);
    }

    public static boolean isArrayType(@Nullable JSCallExpression callExpression) {
        if (callExpression == null) {
            return false;
        }
        JSExpression collectionExpression = JSConvertLoopsUtils.getCollectionExpression(callExpression);
        return JSConvertLoopsUtils.isArrayType(collectionExpression);
    }

    public static boolean isArrayType(@Nullable JSExpression expression) {
        if (expression instanceof JSArrayLiteralExpression) {
            return true;
        }
        return JSTypeUtils.isArrayLikeType(JSResolveUtil.getExpressionJSType(expression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpressionText";
                break;
            }
            case 1: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexText";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemText";
                break;
            }
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsExpression";
                break;
            }
            case 9: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOfBlockBody";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInStatement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConvertLoopsUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainIndexedForInStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainForInStatement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatements";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedStatementFromForOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlainIndexedForInStatement";
                break;
            }
            case 3: 
            case 7: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPlainForInStatement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateForInBody";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addIndexStatementText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceReturnWithContinue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatements";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addItemStatementText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isForEachCall";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedStatementFromForOf";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getForInStatementFromCall";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteral";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCallExpressionObjectLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum LoopType {
        FOR_OF,
        INDEXED;

    }
}

