/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCheckFunctionSignaturesInspection
extends JSInspection {
    public static final String SHORT_NAME = JSCheckFunctionSignaturesInspection.calcShortNameFromClass(JSCheckFunctionSignaturesInspection.class);
    public boolean myCheckGuessedTypes;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message((String)"js.check.function.signature.guess.optionality", (Object[])new Object[0]), JavaScriptBundle.message((String)"js.check.function.signature.guess.optionality.hint", (Object[])new Object[0]), "myCheckGuessedTypes");
    }

    protected boolean isAllowedToCheckCallExpression(JSCallExpression node) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        return dialect == null || !dialect.isTypeScript && dialect != DialectOptionHolder.FLOW;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                PsiElement arrayInitializingType;
                if (!JSCheckFunctionSignaturesInspection.this.isAllowedToCheckCallExpression(node)) {
                    return;
                }
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSParenthesizedExpression) {
                    methodExpression = JSUtils.unparenthesize(methodExpression);
                }
                if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSSuperExpression) {
                    PsiReference reference = methodExpression.getReference();
                    if (reference == null) {
                        return;
                    }
                    PsiElement resolve = reference.resolve();
                    if (resolve == null && reference instanceof PsiPolyVariantReference) {
                        resolve = JSCheckFunctionSignaturesInspection.reportIncompleteAsArgumentTypesMismatch(((PsiPolyVariantReference)reference).multiResolve(false));
                    }
                    if (resolve != null && resolve.isValid()) {
                        JSFunctionItem function2;
                        boolean checkFunction = true;
                        if (!JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes && (function2 = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)methodExpression, true)) instanceof JSFunction && !JSPsiImplUtils.signatureIsExplicitlyDeclared(function2)) {
                            checkFunction = false;
                        }
                        if (checkFunction) {
                            this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, resolve);
                        }
                    }
                } else if (methodExpression instanceof JSFunctionExpression && (JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes || JSPsiImplUtils.signatureIsExplicitlyDeclared((JSFunctionItem)((JSFunctionExpression)methodExpression)))) {
                    this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, (PsiElement)methodExpression);
                } else if (methodExpression instanceof JSArrayLiteralExpression && node instanceof JSNewExpression && (arrayInitializingType = ((JSNewExpression)node).getArrayInitializingType()) != null) {
                    String typeName = JSImportHandlingUtil.resolveTypeName(arrayInitializingType.getText(), (PsiElement)node);
                    ((JSArrayLiteralExpression)methodExpression).getExpressionStream().filter(Objects::nonNull).forEach(expr -> JSCheckFunctionSignaturesInspection.getTypeChecker((PsiElement)expr, holder).checkExpressionIsAssignableToTypeAndReportError((JSExpression)expr, typeName, "javascript.vector.literal.element.type.mismatch", null, true));
                }
            }

            @NotNull
            private JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context).getFunctionSignatureChecker(holder);
                if (jSFunctionSignatureChecker == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSFunctionSignatureChecker;
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.checkSignatureMatchesOverridden((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.checkSignatureMatchesOverridden(node);
            }

            private void checkSignatureMatchesOverridden(JSFunction function2) {
                if (!DialectDetector.isJavaScript((PsiElement)function2)) {
                    return;
                }
                Collection<JSPsiElementBase> members = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function2, true);
                if (members.isEmpty()) {
                    return;
                }
                JSParameterListElement[] parameters = function2.getParameters();
                if (members.size() == 1) {
                    JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)members.iterator().next(), null, false);
                    if (overridden == null) {
                        return;
                    }
                    this.checkCompatibleSignature(function2, parameters, overridden, true);
                } else {
                    for (JSPsiElementBase member : members) {
                        JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)member, null, false);
                        if (overridden == null || !this.checkCompatibleSignature(function2, parameters, overridden, false)) continue;
                        return;
                    }
                    PsiElement nameIdentifier = function2.getNameIdentifier();
                    holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : function2), JavaScriptBundle.message((String)"javascript.validation.message.function.override.incompatible.signature.generic", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean checkCompatibleSignature(JSFunction function2, JSParameterListElement[] parameters, JSFunctionItem overridden, boolean reportProblems) {
                PsiFile file2 = overridden.getContainingFile();
                if (file2 instanceof JSFile && ((JSFile)file2).isPredefined()) {
                    return true;
                }
                if (!JSPsiImplUtils.signatureIsExplicitlyDeclared(overridden)) {
                    return true;
                }
                ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)overridden);
                JSParameterItem[] overriddenParameters = overridden.getParameters();
                if (overriddenParameters.length != parameters.length) {
                    if (reportProblems) {
                        String expectedSignature = JSFormatUtil.buildFunctionSignaturePresentation(overridden);
                        JSParameterList parameterList = function2.getParameterList();
                        if (parameterList != null) {
                            holder.registerProblem((PsiElement)parameterList, JavaScriptBundle.message((String)"javascript.validation.message.function.override.incompatible.signature", (Object[])new Object[]{expectedSignature}), new LocalQuickFix[0]);
                        }
                    }
                    return false;
                }
                boolean result2 = true;
                for (int i = 0; i < parameters.length; ++i) {
                    JSParameterListElement source;
                    JSType type = parameters[i].getJSType();
                    JSType overriddenType = overriddenParameters[i].getInferredType();
                    if (type == null || overriddenType == null || JSTypeUtils.hasForeignGenericParameter(overriddenType) || JSTypeUtils.areTypesCompatible(type, overriddenType, context, (PsiElement)function2)) continue;
                    if (reportProblems && (source = parameters[i]) instanceof JSNamedElement) {
                        boolean hasJSDoc = source instanceof JSPsiElementBase ? ((JSPsiElementBase)source).hasJSDoc() || function2.hasJSDoc() : function2.hasJSDoc();
                        this.registerTypeMismatchProblem(hasJSDoc, (JSNamedElement)source, overriddenType);
                    }
                    result2 = false;
                }
                JSType overriddenReturnType = overridden.getReturnType();
                JSType returnType = function2.getReturnType();
                if (overriddenReturnType != null && returnType != null && !JSTypeUtils.hasForeignGenericParameter(overriddenReturnType) && !overriddenReturnType.isDirectlyAssignableType(returnType, context)) {
                    if (reportProblems) {
                        this.registerTypeMismatchProblem(function2.hasJSDoc(), (JSNamedElement)function2, overriddenReturnType);
                    }
                    result2 = false;
                }
                return result2;
            }

            private void registerTypeMismatchProblem(boolean hasJSDoc, @NotNull JSNamedElement typedElement, @NotNull JSType overriddenType) {
                LocalQuickFix[] localQuickFixArray;
                if (typedElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (overriddenType == null) {
                    1.$$$reportNull$$$0(3);
                }
                String typeText = overriddenType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
                String message = JavaScriptBundle.message((String)"javascript.validation.message.function.method.invalid.overridden.parameter.type", (Object[])new Object[]{typeText});
                if (hasJSDoc) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ChangeJSDocTypeFix(typedElement, overriddenType);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiElement nameIdentifier = typedElement.getNameIdentifier();
                holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : typedElement), message, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typedElement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overriddenType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionSignatureChecker";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getFunctionSignatureChecker";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "registerTypeMismatchProblem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public static PsiElement reportIncompleteAsArgumentTypesMismatch(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(3);
        }
        return resolveResults.length == 1 && resolveResults[0] instanceof JSResolveResult && ((JSResolveResult)resolveResults[0]).getResolveProblemKey() == "javascript.argument.types.mismatch" ? resolveResults[0].getElement() : null;
    }

    @NotNull
    private static JSTypeChecker getTypeChecker(PsiElement context, ProblemsHolder holder) {
        JSTypeChecker jSTypeChecker = JSAnalysisHandlersFactory.forElement(context).getTypeChecker(holder);
        if (jSTypeChecker == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(4);
        }
        return jSTypeChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompleteAsArgumentTypesMismatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

