/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateClassOrInterfaceFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myTargetName;
    private final boolean myIsInterface;
    @Nullable
    private final JSType myExpectedType;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myConstructorArguments;
    @Nullable
    private final SmartPsiElementPointer<TypeScriptTypeArgumentList> myTypeArguments;
    private final boolean myTargetNameIsQualified;

    public ES6CreateClassOrInterfaceFix(@NotNull PsiElement expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable TypeScriptTypeArgumentList typeArguments, @Nullable JSType expectedType) {
        if (expression == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(0);
        }
        super(expression);
        String expressionText = expression instanceof ES6ImportExportDeclarationPart ? JSReferenceChecker.getNameToCreate((ES6ImportExportDeclarationPart)expression) : expression.getText();
        this.myTargetNameIsQualified = expressionText.indexOf(46) > 0;
        this.myTargetName = this.myTargetNameIsQualified ? expressionText.substring(expressionText.lastIndexOf(46) + 1) : expressionText;
        this.myIsInterface = isInterface;
        this.myExpectedType = expectedType;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)expression.getProject());
        this.myConstructorArguments = constructorArguments != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)constructorArguments) : null;
        this.myTypeArguments = typeArguments != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)typeArguments) : null;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(4);
        }
        if (this.myTargetNameIsQualified && !(startElement instanceof JSReferenceExpression)) {
            return false;
        }
        if (!super.isAvailable(project, file2, startElement, endElement)) {
            return false;
        }
        if (this.myIsInterface && !DialectDetector.hasFeature(startElement, JSLanguageFeature.TYPES)) {
            return false;
        }
        if (this.myTargetNameIsQualified) {
            JSExpression qualifier = ((JSReferenceExpression)startElement).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement element = BaseCreateFix.resolveScopeFromQualifier((JSReferenceExpression)qualifier);
            if (!(element instanceof TypeScriptModule) && !(element instanceof JSFile)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getText() {
        String key = this.myIsInterface ? "javascript.create.interface.intention.name" : "javascript.create.class.intention.name";
        String string = JavaScriptBundle.message((String)key, (Object[])new Object[]{this.myTargetName});
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.doInvoke(project, file2, editor, startElement));
    }

    private void doInvoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement) {
        JSArgumentList argumentList;
        JSClass result2;
        JSClass jsClass;
        if (project == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(12);
        }
        if (startElement == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(13);
        }
        boolean isImportExport = startElement instanceof ES6ImportExportSpecifier;
        boolean isExportDefault = startElement instanceof ES6ImportedBinding;
        PsiElement declarationScope = ES6CreateClassOrInterfaceFix.getDeclarationScope(startElement);
        if (declarationScope == null) {
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(startElement);
        if (!FileModificationService.getInstance().preparePsiElementForWrite(declarationScope)) {
            return;
        }
        String declarationText = ES6CreateClassOrInterfaceFix.getDeclarationText(this.myIsInterface, this.myTargetName, this.getBaseClass(this.myExpectedType), ES6CreateClassOrInterfaceFix.getTypeArgumentsString(this.myTypeArguments == null ? null : (TypeScriptTypeArgumentList)this.myTypeArguments.getElement()), this.getImplementsList(this.myExpectedType), this.myTargetNameIsQualified || isImportExport && !BaseCreateFix.isExportWithoutFrom(startElement), isExportDefault);
        if (!isExportDefault) {
            result2 = jsClass = JSPsiElementFactory.createJSClass(declarationText, declarationScope);
        } else {
            ES6ExportDefaultAssignment assignment = JSPsiElementFactory.createJSStatement(declarationText, declarationScope, ES6ExportDefaultAssignment.class);
            result2 = assignment;
            jsClass = (JSClassExpression)assignment.getExpression();
        }
        if (jsClass == null) {
            return;
        }
        if (dialect != null && dialect.isTypeScript) {
            TypeScriptImplementMemberUtil.implementAllMissingMembersForMemberOwner((PsiElement)jsClass, null);
        }
        Object object = jsClass = (result2 = declarationScope.addBefore((PsiElement)result2, ES6CreateClassOrInterfaceFix.getInsertionAnchor(declarationScope, startElement))) instanceof JSClass ? result2 : (JSClassExpression)((ES6ExportDefaultAssignment)result2).getExpression();
        assert (editor != null);
        assert (jsClass != null);
        BaseCreateFix.navigate(project, editor, jsClass.getTextOffset(), declarationScope.getContainingFile().getVirtualFile());
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(result2.getParent().getNode(), result2.getNode());
        JSArgumentList jSArgumentList = argumentList = this.myConstructorArguments != null ? (JSArgumentList)this.myConstructorArguments.getElement() : null;
        if (argumentList != null && argumentList.getArguments().length > 0) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document2 = documentManager.getDocument(file2);
            if (document2 == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document2);
            ES6CreateConstructorFix.generateConstructor(jsClass, argumentList, editor);
        }
    }

    @Nullable
    @Contract(value="null -> null")
    private static String getTypeArgumentsString(@Nullable TypeScriptTypeArgumentList list2) {
        if (list2 == null) {
            return null;
        }
        JSTypeDeclaration[] arguments = list2.getTypeArguments();
        return ES6CreateClassOrInterfaceFix.getTypeArgumentsString(arguments, Collections.emptySet());
    }

    @Nullable
    public static String getTypeArgumentsString(JSTypeDeclaration[] arguments, Set<String> conflictingNames) {
        if (arguments.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder("<");
        if (arguments.length <= 3) {
            builder.append(ES6CreateClassOrInterfaceFix.resolveConflicts("T", conflictingNames));
            if (arguments.length > 1) {
                builder.append(", ").append(ES6CreateClassOrInterfaceFix.resolveConflicts("U", conflictingNames));
            }
            if (arguments.length > 2) {
                builder.append(", ").append(ES6CreateClassOrInterfaceFix.resolveConflicts("V", conflictingNames));
            }
            return builder.append(">").toString();
        }
        int j = 0;
        int length = arguments.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            while (conflictingNames.contains("T" + j)) {
                ++j;
            }
            builder.append("T").append(j);
            ++j;
        }
        return builder.append(">").toString();
    }

    @NotNull
    private static String resolveConflicts(String originalName, Set<String> conflictingNames) {
        String tt = originalName;
        int j = 0;
        while (conflictingNames.contains(tt)) {
            tt = originalName + j;
            ++j;
        }
        String string = tt;
        if (string == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static PsiElement getDeclarationScope(PsiElement element) {
        PsiElement resolvedElement;
        JSExpression qualifier;
        if (element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding) {
            return ES6PsiUtil.computeFromFileForImportExport(element);
        }
        if (element instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)element).getQualifier()) instanceof JSReferenceExpression && ((resolvedElement = BaseCreateFix.resolveScopeFromQualifier((JSReferenceExpression)qualifier)) instanceof TypeScriptModule || resolvedElement instanceof JSFile)) {
            return resolvedElement;
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, parent -> parent instanceof JSFile || parent instanceof JSEmbeddedContent && !JSPsiImplUtils.isEmbeddedExpressionContent(parent) && !JSPsiImplUtils.isEmbeddedTypeContext(parent));
    }

    @Nullable
    private static PsiElement getInsertionAnchor(@NotNull PsiElement declarationScope, @NotNull PsiElement element) {
        PsiElement anchorInCurrentScope;
        if (declarationScope == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(15);
        }
        if (element == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(16);
        }
        if ((anchorInCurrentScope = PsiTreeUtil.findFirstParent((PsiElement)element, el -> el.getParent() == declarationScope)) != null) {
            return JSPsiImplUtils.findLeadingCommentOrSelf(anchorInCurrentScope);
        }
        return declarationScope instanceof JSFile ? null : declarationScope.getLastChild();
    }

    private static String getDeclarationText(boolean isInterface, String name, String baseClass, String typeArguments, List<String> implementsList, boolean shouldExport, boolean exportDefault) {
        StringBuilder builder = new StringBuilder();
        if (exportDefault) {
            builder.append("export default ");
        } else if (shouldExport) {
            builder.append("export ");
        }
        builder.append(isInterface ? "interface " : "class ").append(name);
        if (!StringUtil.isEmpty((String)typeArguments)) {
            builder.append(typeArguments);
        }
        if (!StringUtil.isEmpty((String)baseClass)) {
            builder.append(" extends ").append(baseClass);
        }
        if (!implementsList.isEmpty()) {
            builder.append(" implements ").append(StringUtil.join(implementsList, s -> s, (String)","));
        }
        builder.append("{\n}");
        return builder.toString();
    }

    @Nullable
    private String getBaseClass(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            return this.getNameIfApplicable(expectedType, false);
        }
        if (expectedType instanceof JSIntersectionType) {
            List classNames = ContainerUtil.mapNotNull(((JSIntersectionType)expectedType).getTypes(), type -> this.getNameIfApplicable((JSType)type, false));
            return classNames.size() == 1 ? (String)classNames.get(0) : null;
        }
        return null;
    }

    @NotNull
    private List<String> getImplementsList(@Nullable JSType expectedType) {
        if (expectedType instanceof JSNamedType) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)this.getNameIfApplicable(expectedType, true));
            if (list2 == null) {
                ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(17);
            }
            return list2;
        }
        if (expectedType instanceof JSIntersectionType) {
            List list3 = ContainerUtil.mapNotNull(((JSIntersectionType)expectedType).getTypes(), type -> this.getNameIfApplicable((JSType)type, true));
            if (list3 == null) {
                ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(18);
            }
            return list3;
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(19);
        }
        return list4;
    }

    @Nullable
    private String getNameIfApplicable(@NotNull JSType expectedType, boolean isInterface) {
        String name;
        JSResolvedTypeInfo resolvedType;
        if (expectedType == null) {
            ES6CreateClassOrInterfaceFix.$$$reportNull$$$0(20);
        }
        if (expectedType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)expectedType).resolveType()).isInterface() == isInterface && !StringUtil.equals((CharSequence)(name = expectedType.getTypeText(JSType.TypeTextFormat.CODE)), (CharSequence)this.myTargetName)) {
            return name;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationScope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6CreateClassOrInterfaceFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConflicts";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionAnchor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNameIfApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

