/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.ES6ConvertForInToForOfQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSConvertToForEachIntention;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertToForOfInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertToForOfInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertToForOfInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSForInStatement(JSForInStatement node) {
                if (node.isForEach()) {
                    return;
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                String varName = (String)JSConvertToForEachIntention.getForInVarName(node).getFirst();
                if (varName == null) {
                    return;
                }
                JSExpression collectionExpression = node.getCollectionExpression();
                JSExpression array = null;
                if (collectionExpression instanceof JSReferenceExpression) {
                    PsiElement resolve = ((JSReferenceExpression)collectionExpression).resolve();
                    if (resolve != null && resolve.isValid() && resolve instanceof JSNamedElement) {
                        array = resolve;
                    }
                } else {
                    array = collectionExpression;
                }
                if (array == null) {
                    return;
                }
                JSType type = JSResolveUtil.getElementJSType((PsiElement)array);
                if (type == null || !JSTypeUtils.isIterableCollectionType(type)) {
                    return;
                }
                ES6ConvertForInToForOfQuickFix fix = new ES6ConvertForInToForOfQuickFix(node);
                if (fix.isAvailable(node.getProject(), null, node.getContainingFile())) {
                    TextRange textRange;
                    JSStatement body = node.getBody();
                    if (body == null) {
                        body = (JSStatement)PsiTreeUtil.findChildOfType((PsiElement)node, JSStatement.class);
                    }
                    if (body == null) {
                        textRange = null;
                    } else {
                        int nodeStartOffset;
                        int number;
                        int endOffset = body.getStartOffsetInParent() - 1;
                        Document document2 = PsiDocumentManager.getInstance((Project)holder.getProject()).getDocument(session.getFile());
                        if (document2 != null && (number = document2.getLineNumber(body.getTextRange().getStartOffset() - 1)) > document2.getLineNumber(nodeStartOffset = node.getTextRange().getStartOffset()) && number > 0) {
                            endOffset = document2.getLineEndOffset(number - 1) - nodeStartOffset;
                        }
                        textRange = new TextRange(0, endOffset);
                    }
                    holder.registerProblem((PsiElement)node, textRange, JavaScriptBundle.message((String)"js.convert.for.in.to.for.of.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6ConvertToForOfInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

