/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6AwaitOutsideAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            private boolean hasValidParentForAwait(PsiElement node, Ref<JSFunction> functionRef) {
                PsiElement parent;
                JSFunction parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
                if (parentFunction != null) {
                    functionRef.set((Object)parentFunction);
                    return parentFunction.isAsync();
                }
                JSStatement statement = (JSStatement)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSStatement.class});
                while (statement != null) {
                    parent = statement.getParent();
                    if (parent instanceof JSCaseClause) {
                        parent = parent.getParent();
                    }
                    if (!(parent instanceof JSStatement)) break;
                    statement = (JSStatement)parent;
                }
                if (statement != null) {
                    parent = statement.getParent();
                    if (parent instanceof JSFile && ((JSFile)parent).getModuleStatus() == JSFile.ModuleStatus.ES6) {
                        return true;
                    }
                    if (parent instanceof JSEmbeddedContent && PsiUtilCore.getElementType((PsiElement)parent) instanceof JSEmbeddedContentElementType) {
                        return true;
                    }
                }
                return false;
            }

            public void visitJSPrefixExpression(JSPrefixExpression node) {
                Ref functionRef;
                if (node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD && !this.hasValidParentForAwait((PsiElement)node, (Ref<JSFunction>)(functionRef = Ref.create()))) {
                    holder.registerProblem(node.getFirstChild(), JavaScriptBundle.message((String)"js.possibly.async.function.error.description", (Object[])new Object[0]), ES6AwaitOutsideAsyncFunctionInspection.getAsyncFunctionFixes((JSFunction)functionRef.get()));
                }
            }

            public void visitJSForInStatement(JSForInStatement node) {
                Ref functionRef;
                if (node.isForAwait() && !this.hasValidParentForAwait((PsiElement)node, (Ref<JSFunction>)(functionRef = Ref.create()))) {
                    String message = JavaScriptBundle.message((String)"javascript.validation.message.for.await.no.async.context", (Object[])new Object[0]);
                    ASTNode awaitNode = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD);
                    if (awaitNode != null) {
                        TextRange range = new TextRange(0, awaitNode.getTextRange().getEndOffset() - node.getTextRange().getStartOffset());
                        holder.registerProblem((PsiElement)node, range, message, ES6AwaitOutsideAsyncFunctionInspection.getAsyncFunctionFixes((JSFunction)functionRef.get()));
                    }
                }
            }
        };
    }

    private static LocalQuickFix @NotNull [] getAsyncFunctionFixes(@Nullable JSFunction parentFunction) {
        JSExpression expression;
        JSCallExpression callExpression;
        if (parentFunction == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(2);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!ES6AwaitOutsideAsyncFunctionInspection.isCallbackParameter(parentFunction)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createMakeFunctionAsyncFix(parentFunction)};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(3);
            }
            return localQuickFixArray;
        }
        PsiElement parent = parentFunction.getParent();
        if (!ES6AwaitOutsideAsyncFunctionInspection.isCallbackParameter(parentFunction)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createMakeFunctionAsyncFix(parentFunction)};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(4);
            }
            return localQuickFixArray;
        }
        if (parent instanceof JSArgumentList && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSCallExpression.class)) != null && (expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)expression).getReferenceName())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createForEachToForOfFix()};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(5);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(6);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static boolean isCallbackParameter(JSFunction function2) {
        if (!(function2 instanceof JSFunctionExpression)) {
            return false;
        }
        return function2.getParent() instanceof JSArgumentList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6AwaitOutsideAsyncFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6AwaitOutsideAsyncFunctionInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

