/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexedFilesFilterProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JavaScriptIndex {
    public static final Key<Boolean> SKIP_STUB_CREATION = Key.create((String)"js.skip.stub.creation");
    public static final FileBasedIndex.InputFilter ourIndexedFilesFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){
        private final int JS_SPECIFIC_FILESIZE_LIMIT = StringUtil.parseInt((String)System.getProperty("idea.js.max.intellisense.filesize"), (int)8192) << 10;
        private final int MAX_JS_FILESIZE_LIMIT = Math.max(FileUtilRt.getUserFileSizeLimit(), this.JS_SPECIFIC_FILESIZE_LIMIT);
        private final int MAX_DTS_FILESIZE_LIMIT = FileUtilRt.getUserContentLoadLimit();

        public boolean acceptInput(@NotNull VirtualFile file2) {
            if (file2 == null) {
                1.$$$reportNull$$$0(0);
            }
            FileType fileType = file2.getFileType();
            if (!JavaScriptIndex.getFileTypesToIndexJS().contains(fileType)) {
                return false;
            }
            if (fileType == HtmlFileType.INSTANCE && file2.getFileSystem().getProtocol().equals("jar")) {
                return false;
            }
            String name = file2.getName();
            int cacheIndex = name.indexOf(".cache.");
            if (cacheIndex != -1 && name.endsWith(".js")) {
                boolean justHexDigits = cacheIndex > 0;
                for (int i = 0; i < cacheIndex && justHexDigits; ++i) {
                    justHexDigits = StringUtil.isHexDigit((char)name.charAt(i));
                }
                if (justHexDigits) {
                    return false;
                }
            }
            if (this.isMinifiedCopy(file2)) {
                return false;
            }
            if (Boolean.TRUE.equals(file2.getUserData(SKIP_STUB_CREATION))) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file2, (long)PersistentFSConstants.getMaxIntellisenseFileSize()) && JSMinifiedFileUtil.isFileContentMinified(file2)) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file2, (long)this.getLimitByFile(file2))) {
                return false;
            }
            for (JSIndexedFilesFilterProvider filter : JSIndexedFilesFilterProvider.EP_NAME.getExtensionList()) {
                if (filter.acceptInput(file2)) continue;
                return false;
            }
            return true;
        }

        private int getLimitByFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (TypeScriptUtil.isDefinitionFile(file2)) {
                return this.MAX_DTS_FILESIZE_LIMIT;
            }
            return this.MAX_JS_FILESIZE_LIMIT;
        }

        private boolean isMinifiedCopy(@NotNull VirtualFile file2) {
            String devName;
            String name;
            if (file2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return !StringUtil.equals((CharSequence)(name = file2.getName()), (CharSequence)(devName = JSLibraryUtil.getDevVersionLocation(name, false))) && file2.getParent() != null && file2.getParent().findChild(devName) != null;
        }

        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
            if (fileTypeSink == null) {
                1.$$$reportNull$$$0(3);
            }
            for (FileType ft : JavaScriptIndex.getFileTypesToIndexJS()) {
                fileTypeSink.consume((Object)ft);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeSink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JavaScriptIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptInput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLimitByFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMinifiedCopy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerFileTypesUsedForIndexing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final String ECMASCRIPT_JS2 = "ECMAScript.js2";
    private static final int BASE_VERSION = 171;
    private final Project myProject;
    private static final ClearableLazyValue<Set<FileType>> ourFileTypesToIndexJS = ClearableLazyValue.createAtomic(() -> {
        HashSet<Object> fileTypesForJSCompletion = new HashSet<Object>();
        fileTypesForJSCompletion.add(HtmlFileType.INSTANCE);
        for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Language language;
            if (!(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE) && !language.isKindOf((Language)HTMLLanguage.INSTANCE) && (!(language instanceof TemplateLanguage) || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null)) continue;
            fileTypesForJSCompletion.add(type);
        }
        return fileTypesForJSCompletion;
    });

    @NotNull
    public static Set<FileType> getFileTypesToIndexJS() {
        Set set = (Set)ourFileTypesToIndexJS.getValue();
        if (set == null) {
            JavaScriptIndex.$$$reportNull$$$0(0);
        }
        return set;
    }

    public JavaScriptIndex(Project project) {
        this.myProject = project;
    }

    public static int getVersionStatic() {
        return FrameworkIndexingHandler.computeTotalVersion(171);
    }

    public static boolean isAcceptableFile(VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ourIndexedFilesFilter.acceptInput(fileOrDir);
    }

    public static JavaScriptIndex getInstance(Project project) {
        return (JavaScriptIndex)ServiceManager.getService((Project)project, JavaScriptIndex.class);
    }

    public NavigationItem[] getFileByName(String name, boolean includeNonProjectItems) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name, (GlobalSearchScope)this.getCollectScope(includeNonProjectItems));
    }

    private GlobalSearchScope getCollectScope(boolean includeNonProjectItems) {
        return includeNonProjectItems ? JSResolveUtil.getJavaScriptSymbolsResolveScope(this.myProject) : ProjectScope.getContentScope((Project)this.myProject);
    }

    public final Project getProject() {
        return this.myProject;
    }

    public NavigationItem @NotNull [] getSymbolsByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, false);
    }

    private NavigationItem @NotNull [] processSymbols(String name, boolean includeNonProjectItems, boolean justClasses) {
        GlobalSearchScope scope = this.getCollectScope(includeNonProjectItems);
        Collection<JSPsiElementBase> symbolNavItems = JSClassResolver.findElementsByNameIncludingImplicit(name, scope, justClasses);
        if (!justClasses) {
            Collection<JSQualifiedNamedElement> qualified = JSResolveUtil.findElementsByName(name, this.myProject, scope);
            Iterator<JSQualifiedNamedElement> q = qualified.iterator();
            while (q.hasNext()) {
                JSQualifiedNamedElement element = q.next();
                if (JavaScriptIndex.isFromSwc(element)) continue;
                q.remove();
            }
            symbolNavItems.addAll(qualified);
        }
        NavigationItem[] navigationItemArray = symbolNavItems.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            JavaScriptIndex.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    private static boolean isFromSwc(JSQualifiedNamedElement element) {
        return element.getContainingFile().getVirtualFile().getName().endsWith(".swf");
    }

    public NavigationItem[] getClassByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, true);
    }

    public static String intern(String name) {
        return RecentStringHolder.ourSerializationManager.internString(name);
    }

    static {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ourFileTypesToIndexJS.drop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/index/JavaScriptIndex$2", "beforeFileTypesChanged"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/index/JavaScriptIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesToIndexJS";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processSymbols";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class RecentStringHolder {
        private static final SerializationManager ourSerializationManager = SerializationManager.getInstance();

        private RecentStringHolder() {
        }
    }
}

