/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSThisType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalTypeEvaluator
extends JSLocalTypeEvaluatorBase {
    @Nullable
    @Contract(value="null -> !null")
    public static JSType evaluateTypeLocally(@Nullable JSExpression expression) {
        return new JSLocalTypeEvaluator().evaluate(expression);
    }

    @Override
    @Nullable
    protected JSType getThisExpressionType(@NotNull JSExpression expression) {
        JSType typeFromComment;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(0);
        }
        return (typeFromComment = JSDocumentationUtils.findContextType((PsiElement)expression)) != null ? typeFromComment : new JSThisType(JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
    }

    @Override
    @Nullable
    protected JSType getNewExpressionType(@NotNull JSNewExpression expression) {
        JSExpression methodExpression;
        JSType innerType;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(1);
        }
        Object object = innerType = (methodExpression = expression.getMethodExpression()) != null ? this.evaluate(methodExpression) : JSAnyType.get((PsiElement)expression, false);
        if (innerType != null && !(innerType instanceof JSAnyType)) {
            return new JSApplyNewType(innerType, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
        }
        return JSSymbolUtil.evaluateNamespaceLocally((JSExpression)expression);
    }

    @Override
    @Nullable
    protected JSType getReferenceExpressionType(@NotNull JSReferenceExpression expression) {
        String referenceName;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(2);
        }
        if ((referenceName = expression.getReferenceName()) != null) {
            JSExpression qualifier = expression.getQualifier();
            if (qualifier == null) {
                JSType predefinedType = JSSymbolUtil.getPredefinedType(expression);
                if (predefinedType != null) {
                    return predefinedType;
                }
                return new JSReferenceType(referenceName, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
            }
            JSType qualifierType = this.evaluate(qualifier);
            if (qualifierType != null) {
                return new JSQualifiedReferenceType(referenceName, qualifierType, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType getIndexedPropertyAccessExpressionType(@NotNull JSIndexedPropertyAccessExpression expression) {
        JSExpression qualifier;
        JSType qualifierType;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(3);
        }
        if ((qualifierType = this.evaluate(qualifier = expression.getQualifier())) != null) {
            JSType argumentType = this.evaluate(expression.getIndexExpression());
            return new JSApplyIndexedAccessType(qualifierType, argumentType, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType getArrayLiteralExpressionType(@NotNull JSArrayLiteralExpression expression) {
        List<JSType> types2;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((types2 = this.getArrayNestedTypes(expression, 5, false)) == null) {
            return null;
        }
        if (types2.size() > 1) {
            boolean allEquivalent = true;
            JSType firstType = types2.get(0);
            ProcessingContext context = new ProcessingContext();
            for (int i = 1; i < types2.size(); ++i) {
                if (firstType.isEquivalentTo(types2.get(i), context, false)) continue;
                allEquivalent = false;
                break;
            }
            if (allEquivalent) {
                return new JSArrayTypeImpl(firstType, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
            }
        }
        return JSCompositeTypeFactory.createTupleType(JSLocalTypeEvaluator.createTypeSource((PsiElement)expression), types2, false, -1, false);
    }

    @Override
    @Nullable
    protected JSType getCallLikeExpressionType(@NotNull JSCallLikeExpression expression, @Nullable JSExpression methodExpression) {
        JSType innerType;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (expression instanceof JSCallExpression && ((JSCallExpression)expression).isRequireCall()) {
            return this.qetRequireCallType((JSCallExpression)expression);
        }
        JSType jSType = innerType = methodExpression != null ? this.evaluate(methodExpression) : null;
        if (innerType != null && !(innerType instanceof JSAnyType)) {
            List<JSType> argumentTypes = this.getArguments(expression);
            return new JSApplyCallType(innerType, argumentTypes, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @NotNull
    private List<JSType> getArguments(@NotNull JSCallLikeExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.map((Object[])expression.getArguments(), this::evaluate);
        if (list2 == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    private JSType qetRequireCallType(@NotNull JSCallExpression requireCall) {
        JSType module;
        if (requireCall == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (!requireCall.isRequireCall()) {
            return null;
        }
        List<JSType> arguments = this.getArguments((JSCallLikeExpression)requireCall);
        if (arguments.size() >= 1 && (module = arguments.get(0)) != null) {
            return new JSRequireCallExpressionType(module, JSTypeSourceFactory.createTypeSource((PsiElement)requireCall, true));
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType getConditionalExpressionType(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(9);
        }
        JSType thenType = this.evaluate(expression.getThen());
        JSType elseType = this.evaluate(expression.getElse());
        SmartList types2 = new SmartList();
        ContainerUtil.addAllNotNull((Collection)types2, (Object[])new JSType[]{thenType, elseType});
        if (!types2.isEmpty()) {
            if (types2.size() == 1) {
                return ((JSType)types2.get(0)).copyWithStrict(false);
            }
            boolean isStrictType = types2.size() == 2 && ((JSType)types2.get(0)).isSourceStrict() && ((JSType)types2.get(1)).isSourceStrict();
            JSTypeSource commonTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, isStrictType);
            return JSCompositeTypeImpl.getCommonType((Collection<? extends JSType>)types2, commonTypeSource, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThisExpressionType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArrayLiteralExpressionType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCallLikeExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "qetRequireCallType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConditionalExpressionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

