/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneralCasesHandler
extends FrameworkIndexingHandler {
    private static final String EXTEND_PROPERTY_NAME = "extend";
    private static final String IMPLEMENT_PROPERTY_NAME = "implement";
    private static final String MIXES_PROPERTY_NAME = "include";
    private static final String[] INTERESTED_PROPERTIES = new String[]{"extend", "implement", "include", "Extends", "Implements", "members", "proto", "statics", "own"};

    @Override
    public String @NotNull [] interestedProperties() {
        if (INTERESTED_PROPERTIES == null) {
            JSGeneralCasesHandler.$$$reportNull$$$0(0);
        }
        return INTERESTED_PROPERTIES;
    }

    @Override
    public boolean processProperty(@Nullable String name, @NotNull JSProperty property, @NotNull JSElementIndexingData outData) {
        if (property == null) {
            JSGeneralCasesHandler.$$$reportNull$$$0(1);
        }
        if (outData == null) {
            JSGeneralCasesHandler.$$$reportNull$$$0(2);
        }
        JSExpression value = property.getValue();
        PsiElement parent = property.getParent();
        PsiElement grandParent = parent.getParent();
        if ((EXTEND_PROPERTY_NAME.equals(name) || IMPLEMENT_PROPERTY_NAME.equals(name) || MIXES_PROPERTY_NAME.equals(name) || "Extends".equals(name) || "Implements".equals(name)) && (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression || value instanceof JSArrayLiteralExpression || value instanceof JSCallExpression) && parent instanceof JSObjectLiteralExpression && grandParent instanceof JSArgumentList) {
            JSExpression baseNs = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            if (baseNs != null) {
                JSExpression[] classesToExtend = JSSymbolUtil.findClassesNames(value);
                String baseType = JSSymbolUtil.getQualifierOfExprAsString((JSElement)baseNs);
                if (baseType != null && classesToExtend.length > 0) {
                    for (JSExpression classToExtend : classesToExtend) {
                        outData.addBaseType(baseType, JSStringUtil.unquoteAndUnescapeString(classToExtend.getText()));
                    }
                    return false;
                }
            }
        } else if (("members".equals(name) || "proto".equals(name) || "statics".equals(name) || "own".equals(name)) && (value instanceof JSCallExpression || value instanceof JSObjectLiteralExpression) && grandParent instanceof JSArgumentList) {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSGeneralCasesHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSGeneralCasesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

