/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSMethodHierarchyUtil {
    JSMethodHierarchyUtil() {
    }

    @Nullable
    static JSPsiElementBase getContainingClass(@NotNull JSPsiElementBase method) {
        JSClass jsClass;
        if (method == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(0);
        }
        if ((jsClass = JSResolveUtil.getClassOfContext((PsiElement)method)) != null) {
            return jsClass;
        }
        JSQualifiedName parentNs = method.getJSNamespace().getQualifiedName();
        if (parentNs == null) {
            return null;
        }
        JSClassResolver classResolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)method).getClassResolver();
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)method.getContainingFile());
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        classResolver.processElementsByQNameIncludingImplicit(parentNs.getQualifiedName(), scope, (Processor<JSPsiElementBase>)processor);
        return (JSPsiElementBase)processor.getFoundValue();
    }

    static JSPsiElementBase @NotNull [] getSuperClasses(@NotNull JSPsiElementBase clazz) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(1);
        }
        if (clazz instanceof JSClass) {
            JSClass[] jSClassArray = ((JSClass)clazz).getSuperClasses();
            if (jSClassArray == null) {
                JSMethodHierarchyUtil.$$$reportNull$$$0(2);
            }
            return jSClassArray;
        }
        JSQualifiedName qualifiedName = JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz);
        if (qualifiedName == null) {
            if (JSPsiElementBase.EMPTY_ARRAY == null) {
                JSMethodHierarchyUtil.$$$reportNull$$$0(3);
            }
            return JSPsiElementBase.EMPTY_ARRAY;
        }
        String typeString = JSBaseTypesIndex.getTextForProcessingHierarchy(qualifiedName, JSContext.INSTANCE);
        Collection<JSPsiElementBase> result2 = JSTypeEvaluateManager.findNearestExtendedJSTypes(clazz, typeString);
        JSPsiElementBase[] jSPsiElementBaseArray = result2.toArray(JSPsiElementBase.EMPTY_ARRAY);
        if (jSPsiElementBaseArray == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(4);
        }
        return jSPsiElementBaseArray;
    }

    @Nullable
    static JSFunctionItem findMethodInClass(@Nullable JSFunctionItem method, @NotNull JSPsiElementBase clazz, boolean lookInSupers) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(5);
        }
        return JSMethodHierarchyUtil.findMethodInClass(method, clazz, lookInSupers, null);
    }

    @Nullable
    private static JSFunctionItem findMethodInClass(@Nullable JSFunctionItem method, @NotNull JSPsiElementBase clazz, boolean lookInSupers, @Nullable Set<JSPsiElementBase> visited) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(6);
        }
        if (method == null || visited != null && !visited.add(clazz)) {
            return null;
        }
        if (method instanceof JSFunction && clazz instanceof JSClass) {
            return JSInheritanceUtil.findMethodInClass((JSFunction)method, (JSClass)clazz, lookInSupers);
        }
        String name = method.getName();
        if (name == null) {
            return null;
        }
        JSQualifiedName classNs = JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz);
        if (classNs == null) {
            return null;
        }
        String qName = JSQualifiedNameImpl.create(name, classNs).getQualifiedName();
        Collection<JSPsiElementBase> methods = JSDialectSpecificHandlersFactory.forElement((PsiElement)clazz).getClassResolver().findElementsByQNameIncludingImplicit(qName, clazz.getContainingFile());
        Optional methodInCurrentClass = StreamEx.of(methods).map(it -> {
            JSExpression initializer;
            if (!(it instanceof JSFunctionItem) && it instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)it).getInitializer()) instanceof JSFunctionItem) {
                return initializer;
            }
            return it;
        }).select(JSFunctionItem.class).findFirst();
        if (methodInCurrentClass.isPresent() || !lookInSupers) {
            return methodInCurrentClass.orElse(null);
        }
        JSPsiElementBase[] superClasses = JSMethodHierarchyUtil.getSuperClasses(clazz);
        if (visited == null) {
            visited = new HashSet<JSPsiElementBase>();
        }
        for (JSPsiElementBase superClass : superClasses) {
            JSFunctionItem methodInClass = JSMethodHierarchyUtil.findMethodInClass(method, superClass, true, visited);
            if (methodInClass == null) continue;
            return methodInClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

